/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.ArticleCategory;
import net.shopxx.service.ArticleCategoryService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminArticleCategoryController")
@RequestMapping(value={"/admin/article_category"})
public class ArticleCategoryController
extends BaseController {
    @Resource(name="articleCategoryServiceImpl")
    private ArticleCategoryService IIIlllIl;

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("articleCategoryTree", (Object)this.IIIlllIl.findTree());
        return "/admin/article_category/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(ArticleCategory articleCategory, Long parentId, RedirectAttributes redirectAttributes) {
        articleCategory.setParent((ArticleCategory)this.IIIlllIl.find((Serializable)parentId));
        if (!this.IIIllIlI((Object)articleCategory, new Class[0])) {
            return "/admin/common/error";
        }
        articleCategory.setTreePath(null);
        articleCategory.setGrade(null);
        articleCategory.setChildren(null);
        articleCategory.setArticles(null);
        this.IIIlllIl.save((Object)articleCategory);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        ArticleCategory articleCategory = (ArticleCategory)this.IIIlllIl.find((Serializable)id);
        model.addAttribute("articleCategoryTree", (Object)this.IIIlllIl.findTree());
        model.addAttribute("articleCategory", (Object)articleCategory);
        model.addAttribute("children", (Object)this.IIIlllIl.findChildren(articleCategory));
        return "/admin/article_category/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(ArticleCategory articleCategory, Long parentId, RedirectAttributes redirectAttributes) {
        articleCategory.setParent((ArticleCategory)this.IIIlllIl.find((Serializable)parentId));
        if (!this.IIIllIlI((Object)articleCategory, new Class[0])) {
            return "/admin/common/error";
        }
        if (articleCategory.getParent() != null) {
            ArticleCategory articleCategory2 = articleCategory.getParent();
            if (articleCategory2.equals((Object)articleCategory)) {
                return "/admin/common/error";
            }
            List list = this.IIIlllIl.findChildren(articleCategory2);
            if (list != null && list.contains(articleCategory2)) {
                return "/admin/common/error";
            }
        }
        this.IIIlllIl.update((Object)articleCategory, new String[]{"treePath", "grade", "children", "articles"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(ModelMap model) {
        model.addAttribute("articleCategoryTree", (Object)this.IIIlllIl.findTree());
        return "/admin/article_category/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long id) {
        ArticleCategory articleCategory = (ArticleCategory)this.IIIlllIl.find((Serializable)id);
        if (articleCategory == null) {
            return IIIllIll;
        }
        Set set = articleCategory.getChildren();
        if (set != null && !set.isEmpty()) {
            return Message.error((String)"admin.articleCategory.deleteExistChildrenNotAllowed", (Object[])new Object[0]);
        }
        Set set2 = articleCategory.getArticles();
        if (set2 != null && !set2.isEmpty()) {
            return Message.error((String)"admin.articleCategory.deleteExistArticleNotAllowed", (Object[])new Object[0]);
        }
        this.IIIlllIl.delete((Serializable)id);
        return IIIlllII;
    }
}

