/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.util.HashSet;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Article;
import net.shopxx.entity.ArticleCategory;
import net.shopxx.entity.Tag;
import net.shopxx.service.ArticleCategoryService;
import net.shopxx.service.ArticleService;
import net.shopxx.service.TagService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminArticleController")
@RequestMapping(value={"/admin/article"})
public class ArticleController
extends BaseController {
    @Resource(name="articleServiceImpl")
    private ArticleService IIIlllIl;
    @Resource(name="articleCategoryServiceImpl")
    private ArticleCategoryService IIIllllI;
    @Resource(name="tagServiceImpl")
    private TagService IIIlllll;

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("articleCategoryTree", (Object)this.IIIllllI.findTree());
        model.addAttribute("tags", (Object)this.IIIlllll.findList(Tag.Type.article));
        return "/admin/article/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Article article, Long articleCategoryId, Long[] tagIds, RedirectAttributes redirectAttributes) {
        article.setArticleCategory((ArticleCategory)this.IIIllllI.find((Serializable)articleCategoryId));
        article.setTags(new HashSet(this.IIIlllll.findList((Serializable[])tagIds)));
        if (!this.IIIllIlI((Object)article, new Class[0])) {
            return "/admin/common/error";
        }
        article.setHits(Long.valueOf(0L));
        article.setPageNumber(null);
        this.IIIlllIl.save((Object)article);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("articleCategoryTree", (Object)this.IIIllllI.findTree());
        model.addAttribute("tags", (Object)this.IIIlllll.findList(Tag.Type.article));
        model.addAttribute("article", this.IIIlllIl.find((Serializable)id));
        return "/admin/article/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Article article, Long articleCategoryId, Long[] tagIds, RedirectAttributes redirectAttributes) {
        article.setArticleCategory((ArticleCategory)this.IIIllllI.find((Serializable)articleCategoryId));
        article.setTags(new HashSet(this.IIIlllll.findList((Serializable[])tagIds)));
        if (!this.IIIllIlI((Object)article, new Class[0])) {
            return "/admin/common/error";
        }
        this.IIIlllIl.update((Object)article, new String[]{"hits", "pageNumber"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, ModelMap model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(pageable));
        return "/admin/article/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        this.IIIlllIl.delete((Serializable[])ids);
        return IIIlllII;
    }
}

