/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.shopxx.ExcelView;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Coupon;
import net.shopxx.service.AdminService;
import net.shopxx.service.CouponCodeService;
import net.shopxx.service.CouponService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminCouponController")
@RequestMapping(value={"/admin/coupon"})
public class CouponController
extends BaseController {
    @Resource(name="couponServiceImpl")
    private CouponService IIIlllIl;
    @Resource(name="couponCodeServiceImpl")
    private CouponCodeService IIIllllI;
    @Resource(name="adminServiceImpl")
    private AdminService IIIlllll;

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("operators", (Object)Coupon.Operator.values());
        return "/admin/coupon/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Coupon coupon, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI((Object)coupon, new Class[0])) {
            return "/admin/common/error";
        }
        if (coupon.getBeginDate() != null && coupon.getEndDate() != null && coupon.getBeginDate().after(coupon.getEndDate())) {
            return "/admin/common/error";
        }
        if (coupon.getStartPrice() != null && coupon.getEndPrice() != null && coupon.getStartPrice().compareTo(coupon.getEndPrice()) > 0) {
            return "/admin/common/error";
        }
        if (coupon.getIsExchange().booleanValue() && coupon.getPoint() == null) {
            return "/admin/common/error";
        }
        if (coupon.getPriceOperator() == Coupon.Operator.divide && coupon.getPriceValue() != null && coupon.getPriceValue().compareTo(new BigDecimal(0)) == 0) {
            return "/admin/common/error";
        }
        if (!coupon.getIsExchange().booleanValue()) {
            coupon.setPoint(null);
        }
        coupon.setCouponCodes(null);
        coupon.setPromotions(null);
        coupon.setOrders(null);
        this.IIIlllIl.save((Object)coupon);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("coupon", this.IIIlllIl.find((Serializable)id));
        model.addAttribute("operators", (Object)Coupon.Operator.values());
        return "/admin/coupon/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Coupon coupon, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI((Object)coupon, new Class[0])) {
            return "/admin/common/error";
        }
        if (coupon.getBeginDate() != null && coupon.getEndDate() != null && coupon.getBeginDate().after(coupon.getEndDate())) {
            return "/admin/common/error";
        }
        if (coupon.getStartPrice() != null && coupon.getEndPrice() != null && coupon.getStartPrice().compareTo(coupon.getEndPrice()) > 0) {
            return "/admin/common/error";
        }
        if (coupon.getIsExchange().booleanValue() && coupon.getPoint() == null) {
            return "/admin/common/error";
        }
        if (coupon.getPriceOperator() == Coupon.Operator.divide && coupon.getPriceValue() != null && coupon.getPriceValue().compareTo(new BigDecimal(0)) == 0) {
            return "/admin/common/error";
        }
        if (!coupon.getIsExchange().booleanValue()) {
            coupon.setPoint(null);
        }
        this.IIIlllIl.update((Object)coupon, new String[]{"couponCodes", "promotions", "orders"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, ModelMap model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(pageable));
        return "/admin/coupon/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        this.IIIlllIl.delete((Serializable[])ids);
        return IIIlllII;
    }

    @RequestMapping(value={"/build"}, method={RequestMethod.GET})
    public String build(Long id, ModelMap model) {
        Coupon coupon = (Coupon)this.IIIlllIl.find((Serializable)id);
        model.addAttribute("coupon", (Object)coupon);
        model.addAttribute("totalCount", (Object)this.IIIllllI.count(coupon, null, null, null, null));
        model.addAttribute("usedCount", (Object)this.IIIllllI.count(coupon, null, null, null, Boolean.valueOf(true)));
        return "/admin/coupon/build";
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public ModelAndView download(Long id, Integer count, ModelMap model) {
        if (count == null || count <= 0) {
            count = 50;
        }
        Coupon coupon = (Coupon)this.IIIlllIl.find((Serializable)id);
        List list = this.IIIllllI.build(coupon, null, count);
        String string = "coupon_code_" + new SimpleDateFormat("yyyyMM").format(new Date()) + ".xls";
        String[] stringArray = new String[]{String.valueOf(this.IIIllIlI("admin.coupon.type", new Object[0])) + ": " + coupon.getName(), String.valueOf(this.IIIllIlI("admin.coupon.count", new Object[0])) + ": " + count, String.valueOf(this.IIIllIlI("admin.coupon.operator", new Object[0])) + ": " + this.IIIlllll.getCurrentUsername(), String.valueOf(this.IIIllIlI("admin.coupon.date", new Object[0])) + ": " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())};
        return new ModelAndView((View)new ExcelView(string, null, new String[]{"code"}, new String[]{this.IIIllIlI("admin.coupon.title", new Object[0])}, null, null, (Collection)list, stringArray), (Map)model);
    }
}

