/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.CommonAttributes;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.Setting;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Area;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Member;
import net.shopxx.entity.MemberAttribute;
import net.shopxx.entity.MemberRank;
import net.shopxx.service.AdminService;
import net.shopxx.service.AreaService;
import net.shopxx.service.MemberAttributeService;
import net.shopxx.service.MemberRankService;
import net.shopxx.service.MemberService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminMemberController")
@RequestMapping(value={"/admin/member"})
public class MemberController
extends BaseController {
    @Resource(name="memberServiceImpl")
    private MemberService IIIlllIl;
    @Resource(name="memberRankServiceImpl")
    private MemberRankService IIIllllI;
    @Resource(name="memberAttributeServiceImpl")
    private MemberAttributeService IIIlllll;
    @Resource(name="areaServiceImpl")
    private AreaService IIlIIIII;
    @Resource(name="adminServiceImpl")
    private AdminService IIlIIIIl;

    @RequestMapping(value={"/check_username"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkUsername(String username) {
        if (StringUtils.isEmpty((String)username)) {
            return false;
        }
        return !this.IIIlllIl.usernameDisabled(username) && !this.IIIlllIl.usernameExists(username);
    }

    @RequestMapping(value={"/check_email"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkEmail(String previousEmail, String email) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        return this.IIIlllIl.emailUnique(previousEmail, email);
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(Long id, ModelMap model) {
        model.addAttribute("genders", (Object)Member.Gender.values());
        model.addAttribute("memberAttributes", (Object)this.IIIlllll.findList());
        model.addAttribute("member", this.IIIlllIl.find((Serializable)id));
        return "/admin/member/view";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("genders", (Object)Member.Gender.values());
        model.addAttribute("memberRanks", (Object)this.IIIllllI.findAll());
        model.addAttribute("memberAttributes", (Object)this.IIIlllll.findList());
        return "/admin/member/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Member member, Long memberRankId, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        member.setMemberRank((MemberRank)this.IIIllllI.find((Serializable)memberRankId));
        if (!this.IIIllIlI((Object)member, new Class[]{BaseEntity.Save.class})) {
            return "/admin/common/error";
        }
        Setting setting = SettingUtils.get();
        if (member.getUsername().length() < setting.getUsernameMinLength() || member.getUsername().length() > setting.getUsernameMaxLength()) {
            return "/admin/common/error";
        }
        if (member.getPassword().length() < setting.getPasswordMinLength() || member.getPassword().length() > setting.getPasswordMaxLength()) {
            return "/admin/common/error";
        }
        if (this.IIIlllIl.usernameDisabled(member.getUsername()) || this.IIIlllIl.usernameExists(member.getUsername())) {
            return "/admin/common/error";
        }
        if (!setting.getIsDuplicateEmail().booleanValue() && this.IIIlllIl.emailExists(member.getEmail())) {
            return "/admin/common/error";
        }
        member.removeAttributeValue();
        for (MemberAttribute memberAttribute : this.IIIlllll.findList()) {
            List<String> list;
            String[] stringArray;
            String string = request.getParameter("memberAttribute_" + memberAttribute.getId());
            if (memberAttribute.getType() == MemberAttribute.Type.name || memberAttribute.getType() == MemberAttribute.Type.address || memberAttribute.getType() == MemberAttribute.Type.zipCode || memberAttribute.getType() == MemberAttribute.Type.phone || memberAttribute.getType() == MemberAttribute.Type.mobile || memberAttribute.getType() == MemberAttribute.Type.text || memberAttribute.getType() == MemberAttribute.Type.select) {
                if (memberAttribute.getIsRequired().booleanValue() && StringUtils.isEmpty((String)string)) {
                    return "/admin/common/error";
                }
                member.setAttributeValue(memberAttribute, (Object)string);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.gender) {
                String[] stringArray2 = stringArray = StringUtils.isNotEmpty((String)string) ? Member.Gender.valueOf((String)string) : null;
                if (memberAttribute.getIsRequired().booleanValue() && stringArray == null) {
                    return "/admin/common/error";
                }
                member.setGender((Member.Gender)stringArray);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.birth) {
                block17: {
                    try {
                        String[] stringArray3 = stringArray = StringUtils.isNotEmpty((String)string) ? DateUtils.parseDate((String)string, (String[])CommonAttributes.DATE_PATTERNS) : null;
                        if (!memberAttribute.getIsRequired().booleanValue() || stringArray != null) break block17;
                        return "/admin/common/error";
                    }
                    catch (ParseException parseException) {
                        return "/admin/common/error";
                    }
                }
                member.setBirth((Date)stringArray);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.area) {
                String[] stringArray4 = stringArray = StringUtils.isNotEmpty((String)string) ? (String[])this.IIlIIIII.find((Serializable)Long.valueOf(string)) : null;
                if (stringArray != null) {
                    member.setArea((Area)stringArray);
                    continue;
                }
                if (!memberAttribute.getIsRequired().booleanValue()) continue;
                return "/admin/common/error";
            }
            if (memberAttribute.getType() != MemberAttribute.Type.checkbox) continue;
            stringArray = request.getParameterValues("memberAttribute_" + memberAttribute.getId());
            List<String> list2 = list = stringArray != null ? Arrays.asList(stringArray) : null;
            if (memberAttribute.getIsRequired().booleanValue() && (list == null || list.isEmpty())) {
                return "/admin/common/error";
            }
            member.setAttributeValue(memberAttribute, list);
        }
        member.setUsername(member.getUsername().toLowerCase());
        member.setPassword(DigestUtils.md5Hex((String)member.getPassword()));
        member.setAmount(new BigDecimal(0));
        member.setIsLocked(Boolean.valueOf(false));
        member.setLoginFailureCount(Integer.valueOf(0));
        member.setLockedDate(null);
        member.setRegisterIp(request.getRemoteAddr());
        member.setLoginIp(null);
        member.setLoginDate(null);
        member.setSafeKey(null);
        member.setCart(null);
        member.setOrders(null);
        member.setDeposits(null);
        member.setPayments(null);
        member.setCouponCodes(null);
        member.setReceivers(null);
        member.setReviews(null);
        member.setConsultations(null);
        member.setFavoriteProducts(null);
        member.setProductNotifies(null);
        member.setInMessages(null);
        member.setOutMessages(null);
        this.IIIlllIl.save(member, this.IIlIIIIl.getCurrent());
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("genders", (Object)Member.Gender.values());
        model.addAttribute("memberRanks", (Object)this.IIIllllI.findAll());
        model.addAttribute("memberAttributes", (Object)this.IIIlllll.findList());
        model.addAttribute("member", this.IIIlllIl.find((Serializable)id));
        return "/admin/member/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Member member, Long memberRankId, Integer modifyPoint, BigDecimal modifyBalance, String depositMemo, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        member.setMemberRank((MemberRank)this.IIIllllI.find((Serializable)memberRankId));
        if (!this.IIIllIlI((Object)member, new Class[0])) {
            return "/admin/common/error";
        }
        Setting setting = SettingUtils.get();
        if (member.getPassword() != null && (member.getPassword().length() < setting.getPasswordMinLength() || member.getPassword().length() > setting.getPasswordMaxLength())) {
            return "/admin/common/error";
        }
        Member member2 = (Member)this.IIIlllIl.find((Serializable)member.getId());
        if (member2 == null) {
            return "/admin/common/error";
        }
        if (!setting.getIsDuplicateEmail().booleanValue() && !this.IIIlllIl.emailUnique(member2.getEmail(), member.getEmail())) {
            return "/admin/common/error";
        }
        member.removeAttributeValue();
        for (MemberAttribute memberAttribute : this.IIIlllll.findList()) {
            List<String> list;
            String[] stringArray;
            String string = request.getParameter("memberAttribute_" + memberAttribute.getId());
            if (memberAttribute.getType() == MemberAttribute.Type.name || memberAttribute.getType() == MemberAttribute.Type.address || memberAttribute.getType() == MemberAttribute.Type.zipCode || memberAttribute.getType() == MemberAttribute.Type.phone || memberAttribute.getType() == MemberAttribute.Type.mobile || memberAttribute.getType() == MemberAttribute.Type.text || memberAttribute.getType() == MemberAttribute.Type.select) {
                if (memberAttribute.getIsRequired().booleanValue() && StringUtils.isEmpty((String)string)) {
                    return "/admin/common/error";
                }
                member.setAttributeValue(memberAttribute, (Object)string);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.gender) {
                String[] stringArray2 = stringArray = StringUtils.isNotEmpty((String)string) ? Member.Gender.valueOf((String)string) : null;
                if (memberAttribute.getIsRequired().booleanValue() && stringArray == null) {
                    return "/admin/common/error";
                }
                member.setGender((Member.Gender)stringArray);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.birth) {
                block20: {
                    try {
                        String[] stringArray3 = stringArray = StringUtils.isNotEmpty((String)string) ? DateUtils.parseDate((String)string, (String[])CommonAttributes.DATE_PATTERNS) : null;
                        if (!memberAttribute.getIsRequired().booleanValue() || stringArray != null) break block20;
                        return "/admin/common/error";
                    }
                    catch (ParseException parseException) {
                        return "/admin/common/error";
                    }
                }
                member.setBirth((Date)stringArray);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.area) {
                String[] stringArray4 = stringArray = StringUtils.isNotEmpty((String)string) ? (String[])this.IIlIIIII.find((Serializable)Long.valueOf(string)) : null;
                if (stringArray != null) {
                    member.setArea((Area)stringArray);
                    continue;
                }
                if (!memberAttribute.getIsRequired().booleanValue()) continue;
                return "/admin/common/error";
            }
            if (memberAttribute.getType() != MemberAttribute.Type.checkbox) continue;
            stringArray = request.getParameterValues("memberAttribute_" + memberAttribute.getId());
            List<String> list2 = list = stringArray != null ? Arrays.asList(stringArray) : null;
            if (memberAttribute.getIsRequired().booleanValue() && (list == null || list.isEmpty())) {
                return "/admin/common/error";
            }
            member.setAttributeValue(memberAttribute, list);
        }
        if (StringUtils.isEmpty((String)member.getPassword())) {
            member.setPassword(member2.getPassword());
        } else {
            member.setPassword(DigestUtils.md5Hex((String)member.getPassword()));
        }
        if (member2.getIsLocked().booleanValue() && !member.getIsLocked().booleanValue()) {
            member.setLoginFailureCount(Integer.valueOf(0));
            member.setLockedDate(null);
        } else {
            member.setIsLocked(member2.getIsLocked());
            member.setLoginFailureCount(member2.getLoginFailureCount());
            member.setLockedDate(member2.getLockedDate());
        }
        BeanUtils.copyProperties((Object)member, (Object)member2, (String[])new String[]{"username", "point", "amount", "balance", "registerIp", "loginIp", "loginDate", "safeKey", "cart", "orders", "deposits", "payments", "couponCodes", "receivers", "reviews", "consultations", "favoriteProducts", "productNotifies", "inMessages", "outMessages"});
        this.IIIlllIl.update(member2, modifyPoint, modifyBalance, depositMemo, this.IIlIIIIl.getCurrent());
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, ModelMap model) {
        model.addAttribute("memberRanks", (Object)this.IIIllllI.findAll());
        model.addAttribute("memberAttributes", (Object)this.IIIlllll.findAll());
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(pageable));
        return "/admin/member/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        if (ids != null) {
            Long[] longArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Long l = longArray[n2];
                Member member = (Member)this.IIIlllIl.find((Serializable)l);
                if (member != null && member.getBalance().compareTo(new BigDecimal(0)) > 0) {
                    return Message.error((String)"admin.member.deleteExistDepositNotAllowed", (Object[])new Object[]{member.getUsername()});
                }
                ++n2;
            }
            this.IIIlllIl.delete((Serializable[])ids);
        }
        return IIIlllII;
    }
}

