/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.MemberRank;
import net.shopxx.service.MemberRankService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminMemberRankController")
@RequestMapping(value={"/admin/member_rank"})
public class MemberRankController
extends BaseController {
    @Resource(name="memberRankServiceImpl")
    private MemberRankService IIIlllIl;

    @RequestMapping(value={"/check_name"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkName(String previousName, String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        return this.IIIlllIl.nameUnique(previousName, name);
    }

    @RequestMapping(value={"/check_amount"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkAmount(BigDecimal previousAmount, BigDecimal amount) {
        if (amount == null) {
            return false;
        }
        return this.IIIlllIl.amountUnique(previousAmount, amount);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        return "/admin/member_rank/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(MemberRank memberRank, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI((Object)memberRank, new Class[0])) {
            return "/admin/common/error";
        }
        if (this.IIIlllIl.nameExists(memberRank.getName())) {
            return "/admin/common/error";
        }
        if (memberRank.getIsSpecial().booleanValue()) {
            memberRank.setAmount(null);
        } else if (memberRank.getAmount() == null || this.IIIlllIl.amountExists(memberRank.getAmount())) {
            return "/admin/common/error";
        }
        memberRank.setMembers(null);
        memberRank.setPromotions(null);
        this.IIIlllIl.save((Object)memberRank);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("memberRank", this.IIIlllIl.find((Serializable)id));
        return "/admin/member_rank/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(MemberRank memberRank, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI((Object)memberRank, new Class[0])) {
            return "/admin/common/error";
        }
        MemberRank memberRank2 = (MemberRank)this.IIIlllIl.find((Serializable)memberRank.getId());
        if (memberRank2 == null) {
            return "/admin/common/error";
        }
        if (!this.IIIlllIl.nameUnique(memberRank2.getName(), memberRank.getName())) {
            return "/admin/common/error";
        }
        if (memberRank2.getIsDefault().booleanValue()) {
            memberRank.setIsDefault(Boolean.valueOf(true));
        }
        if (memberRank.getIsSpecial().booleanValue()) {
            memberRank.setAmount(null);
        } else if (memberRank.getAmount() == null || !this.IIIlllIl.amountUnique(memberRank2.getAmount(), memberRank.getAmount())) {
            return "/admin/common/error";
        }
        this.IIIlllIl.update((Object)memberRank, new String[]{"members", "promotions"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, ModelMap model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(pageable));
        return "/admin/member_rank/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        if (ids != null) {
            Long[] longArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Long l = longArray[n2];
                MemberRank memberRank = (MemberRank)this.IIIlllIl.find((Serializable)l);
                if (memberRank != null && memberRank.getMembers() != null && !memberRank.getMembers().isEmpty()) {
                    return Message.error((String)"admin.memberRank.deleteExistNotAllowed", (Object[])new Object[]{memberRank.getName()});
                }
                ++n2;
            }
            long l = this.IIIlllIl.count();
            if ((long)ids.length >= l) {
                return Message.error((String)"admin.common.deleteAllNotAllowed", (Object[])new Object[0]);
            }
            this.IIIlllIl.delete((Serializable[])ids);
        }
        return IIIlllII;
    }
}

