/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Member;
import net.shopxx.service.MemberService;
import net.shopxx.service.MessageService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminMessageController")
@RequestMapping(value={"/admin/message"})
public class MessageController
extends BaseController {
    @Resource(name="messageServiceImpl")
    MessageService IIIlllIl;
    @Resource(name="memberServiceImpl")
    MemberService IIIllllI;

    @RequestMapping(value={"/check_username"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkUsername(String username) {
        return this.IIIllllI.usernameExists(username);
    }

    @RequestMapping(value={"/send"}, method={RequestMethod.GET})
    public String send(Long draftMessageId, Model model) {
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)draftMessageId);
        if (message != null && message.getIsDraft().booleanValue() && message.getSender() == null) {
            model.addAttribute("draftMessage", (Object)message);
        }
        return "admin/message/send";
    }

    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    public String send(Long draftMessageId, String username, String title, String content, @RequestParam(defaultValue="false") Boolean isDraft, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI(net.shopxx.entity.Message.class, "content", (Object)content, new Class[0])) {
            return "/admin/common/error";
        }
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)draftMessageId);
        if (message != null && message.getIsDraft().booleanValue() && message.getSender() == null) {
            this.IIIlllIl.delete((Object)message);
        }
        Member member = null;
        if (StringUtils.isNotEmpty((String)username) && (member = this.IIIllllI.findByUsername(username)) == null) {
            return "/admin/common/error";
        }
        net.shopxx.entity.Message message2 = new net.shopxx.entity.Message();
        message2.setTitle(title);
        message2.setContent(content);
        message2.setIp(request.getRemoteAddr());
        message2.setIsDraft(isDraft);
        message2.setSenderRead(Boolean.valueOf(true));
        message2.setReceiverRead(Boolean.valueOf(false));
        message2.setSenderDelete(Boolean.valueOf(false));
        message2.setReceiverDelete(Boolean.valueOf(false));
        message2.setSender(null);
        message2.setReceiver(member);
        message2.setForMessage(null);
        message2.setReplyMessages(null);
        this.IIIlllIl.save((Object)message2);
        if (isDraft.booleanValue()) {
            this.IIIllIlI(redirectAttributes, Message.success((String)"admin.message.saveDraftSuccess", (Object[])new Object[0]));
            return "redirect:draft.jhtml";
        }
        this.IIIllIlI(redirectAttributes, Message.success((String)"admin.message.sendSuccess", (Object[])new Object[0]));
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(Long id, Model model) {
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)id);
        if (message == null || message.getIsDraft().booleanValue() || message.getForMessage() != null) {
            return "/admin/common/error";
        }
        if (message.getSender() != null && message.getReceiver() != null || message.getReceiver() == null && message.getReceiverDelete() != false || message.getSender() == null && message.getSenderDelete().booleanValue()) {
            return "/admin/common/error";
        }
        if (message.getReceiver() == null) {
            message.setReceiverRead(Boolean.valueOf(true));
        } else {
            message.setSenderRead(Boolean.valueOf(true));
        }
        this.IIIlllIl.update((Object)message);
        model.addAttribute("adminMessage", (Object)message);
        return "/admin/message/view";
    }

    @RequestMapping(value={"/reply"}, method={RequestMethod.POST})
    public String reply(Long id, String content, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI(net.shopxx.entity.Message.class, "content", (Object)content, new Class[0])) {
            return "/admin/common/error";
        }
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)id);
        if (message == null || message.getIsDraft().booleanValue() || message.getForMessage() != null) {
            return "/admin/common/error";
        }
        if (message.getSender() != null && message.getReceiver() != null || message.getReceiver() == null && message.getReceiverDelete() != false || message.getSender() == null && message.getSenderDelete().booleanValue()) {
            return "/admin/common/error";
        }
        net.shopxx.entity.Message message2 = new net.shopxx.entity.Message();
        message2.setTitle("reply: " + message.getTitle());
        message2.setContent(content);
        message2.setIp(request.getRemoteAddr());
        message2.setIsDraft(Boolean.valueOf(false));
        message2.setSenderRead(Boolean.valueOf(true));
        message2.setReceiverRead(Boolean.valueOf(false));
        message2.setSenderDelete(Boolean.valueOf(false));
        message2.setReceiverDelete(Boolean.valueOf(false));
        message2.setSender(null);
        message2.setReceiver(message.getReceiver() == null ? message.getSender() : message.getReceiver());
        if (message.getReceiver() == null && !message.getSenderDelete().booleanValue() || message.getSender() == null && !message.getReceiverDelete().booleanValue()) {
            message2.setForMessage(message);
        }
        message2.setReplyMessages(null);
        this.IIIlllIl.save((Object)message2);
        if (message.getSender() == null) {
            message.setSenderRead(Boolean.valueOf(true));
            message.setReceiverRead(Boolean.valueOf(false));
        } else {
            message.setSenderRead(Boolean.valueOf(false));
            message.setReceiverRead(Boolean.valueOf(true));
        }
        this.IIIlllIl.update((Object)message);
        if (message.getReceiver() == null && !message.getSenderDelete().booleanValue() || message.getSender() == null && !message.getReceiverDelete().booleanValue()) {
            this.IIIllIlI(redirectAttributes, IIIlllII);
            return "redirect:view.jhtml?id=" + message.getId();
        }
        this.IIIllIlI(redirectAttributes, Message.success((String)"admin.message.replySuccess", (Object[])new Object[0]));
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, Model model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(null, pageable));
        return "/admin/message/list";
    }

    @RequestMapping(value={"/draft"}, method={RequestMethod.GET})
    public String draft(Pageable pageable, Model model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findDraftPage(null, pageable));
        return "/admin/message/draft";
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        if (ids != null) {
            Long[] longArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Long l = longArray[n2];
                this.IIIlllIl.delete(l, null);
                ++n2;
            }
        }
        return IIIlllII;
    }
}

