/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Admin;
import net.shopxx.entity.Area;
import net.shopxx.entity.DeliveryCorp;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order;
import net.shopxx.entity.OrderItem;
import net.shopxx.entity.Payment;
import net.shopxx.entity.PaymentMethod;
import net.shopxx.entity.Product;
import net.shopxx.entity.Refunds;
import net.shopxx.entity.Returns;
import net.shopxx.entity.ReturnsItem;
import net.shopxx.entity.Shipping;
import net.shopxx.entity.ShippingItem;
import net.shopxx.entity.ShippingMethod;
import net.shopxx.entity.Sn;
import net.shopxx.service.AdminService;
import net.shopxx.service.AreaService;
import net.shopxx.service.DeliveryCorpService;
import net.shopxx.service.OrderItemService;
import net.shopxx.service.OrderService;
import net.shopxx.service.PaymentMethodService;
import net.shopxx.service.ProductService;
import net.shopxx.service.ShippingMethodService;
import net.shopxx.service.SnService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="adminOrderController")
@RequestMapping(value={"/admin/order"})
public class OrderController
extends BaseController {
    @Resource(name="adminServiceImpl")
    private AdminService IIIlllIl;
    @Resource(name="areaServiceImpl")
    private AreaService IIIllllI;
    @Resource(name="productServiceImpl")
    private ProductService IIIlllll;
    @Resource(name="orderServiceImpl")
    private OrderService IIlIIIII;
    @Resource(name="orderItemServiceImpl")
    private OrderItemService IIlIIIIl;
    @Resource(name="shippingMethodServiceImpl")
    private ShippingMethodService IIlIIIlI;
    @Resource(name="deliveryCorpServiceImpl")
    private DeliveryCorpService IIlIIIll;
    @Resource(name="paymentMethodServiceImpl")
    private PaymentMethodService IIlIIlII;
    @Resource(name="snServiceImpl")
    private SnService IIlIIlIl;

    @RequestMapping(value={"/check_lock"}, method={RequestMethod.POST})
    @ResponseBody
    public Message checkLock(Long id) {
        Order order = (Order)this.IIlIIIII.find((Serializable)id);
        if (order == null) {
            return Message.warn((String)"admin.common.invalid", (Object[])new Object[0]);
        }
        Admin admin = this.IIIlllIl.getCurrent();
        if (order.isLocked(admin)) {
            if (order.getOperator() != null) {
                return Message.warn((String)"admin.order.adminLocked", (Object[])new Object[]{order.getOperator().getUsername()});
            }
            return Message.warn((String)"admin.order.memberLocked", (Object[])new Object[0]);
        }
        order.setLockExpire(DateUtils.addSeconds((Date)new Date(), (int)60));
        order.setOperator(admin);
        this.IIlIIIII.update((Object)order);
        return IIIlllII;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(Long id, ModelMap model) {
        model.addAttribute("types", (Object)Payment.Type.values());
        model.addAttribute("refundsTypes", (Object)Refunds.Type.values());
        model.addAttribute("paymentMethods", (Object)this.IIlIIlII.findAll());
        model.addAttribute("shippingMethods", (Object)this.IIlIIIlI.findAll());
        model.addAttribute("deliveryCorps", (Object)this.IIlIIIll.findAll());
        model.addAttribute("order", this.IIlIIIII.find((Serializable)id));
        return "/admin/order/view";
    }

    @RequestMapping(value={"/confirm"}, method={RequestMethod.POST})
    public String confirm(Long id, RedirectAttributes redirectAttributes) {
        Order order = (Order)this.IIlIIIII.find((Serializable)id);
        Admin admin = this.IIIlllIl.getCurrent();
        if (order != null && !order.isExpired() && order.getOrderStatus() == Order.OrderStatus.unconfirmed && !order.isLocked(admin)) {
            this.IIlIIIII.confirm(order, admin);
            this.IIIllIlI(redirectAttributes, IIIlllII);
        } else {
            this.IIIllIlI(redirectAttributes, Message.warn((String)"admin.common.invalid", (Object[])new Object[0]));
        }
        return "redirect:view.jhtml?id=" + id;
    }

    @RequestMapping(value={"/complete"}, method={RequestMethod.POST})
    public String complete(Long id, RedirectAttributes redirectAttributes) {
        Order order = (Order)this.IIlIIIII.find((Serializable)id);
        Admin admin = this.IIIlllIl.getCurrent();
        if (order != null && !order.isExpired() && order.getOrderStatus() == Order.OrderStatus.confirmed && !order.isLocked(admin)) {
            this.IIlIIIII.complete(order, admin);
            this.IIIllIlI(redirectAttributes, IIIlllII);
        } else {
            this.IIIllIlI(redirectAttributes, Message.warn((String)"admin.common.invalid", (Object[])new Object[0]));
        }
        return "redirect:view.jhtml?id=" + id;
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancel(Long id, RedirectAttributes redirectAttributes) {
        Order order = (Order)this.IIlIIIII.find((Serializable)id);
        Admin admin = this.IIIlllIl.getCurrent();
        if (order != null && !order.isExpired() && order.getOrderStatus() == Order.OrderStatus.unconfirmed && !order.isLocked(admin)) {
            this.IIlIIIII.cancel(order, admin);
            this.IIIllIlI(redirectAttributes, IIIlllII);
        } else {
            this.IIIllIlI(redirectAttributes, Message.warn((String)"admin.common.invalid", (Object[])new Object[0]));
        }
        return "redirect:view.jhtml?id=" + id;
    }

    @RequestMapping(value={"/payment"}, method={RequestMethod.POST})
    public String payment(Long orderId, Long paymentMethodId, Payment payment, RedirectAttributes redirectAttributes) {
        Order order = (Order)this.IIlIIIII.find((Serializable)orderId);
        payment.setOrder(order);
        PaymentMethod paymentMethod = (PaymentMethod)this.IIlIIlII.find((Serializable)paymentMethodId);
        payment.setPaymentMethod(paymentMethod != null ? paymentMethod.getName() : null);
        if (!this.IIIllIlI((Object)payment, new Class[0])) {
            return "/admin/common/error";
        }
        if (order.isExpired() || order.getOrderStatus() != Order.OrderStatus.confirmed) {
            return "/admin/common/error";
        }
        if (order.getPaymentStatus() != Order.PaymentStatus.unpaid && order.getPaymentStatus() != Order.PaymentStatus.partialPayment) {
            return "/admin/common/error";
        }
        if (payment.getAmount().compareTo(new BigDecimal(0)) <= 0 || payment.getAmount().compareTo(order.getAmountPayable()) > 0) {
            return "/admin/common/error";
        }
        Member member = order.getMember();
        if (payment.getType() == Payment.Type.deposit && payment.getAmount().compareTo(member.getBalance()) > 0) {
            return "/admin/common/error";
        }
        Admin admin = this.IIIlllIl.getCurrent();
        if (order.isLocked(admin)) {
            return "/admin/common/error";
        }
        payment.setSn(this.IIlIIlIl.generate(Sn.Type.payment));
        payment.setStatus(Payment.Status.success);
        payment.setFee(new BigDecimal(0));
        payment.setOperator(admin.getUsername());
        payment.setPaymentDate(new Date());
        payment.setPaymentPluginId(null);
        payment.setExpire(null);
        payment.setDeposit(null);
        payment.setMember(null);
        this.IIlIIIII.payment(order, payment, admin);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:view.jhtml?id=" + orderId;
    }

    @RequestMapping(value={"/refunds"}, method={RequestMethod.POST})
    public String refunds(Long orderId, Long paymentMethodId, Refunds refunds, RedirectAttributes redirectAttributes) {
        Order order = (Order)this.IIlIIIII.find((Serializable)orderId);
        refunds.setOrder(order);
        PaymentMethod paymentMethod = (PaymentMethod)this.IIlIIlII.find((Serializable)paymentMethodId);
        refunds.setPaymentMethod(paymentMethod != null ? paymentMethod.getName() : null);
        if (!this.IIIllIlI((Object)refunds, new Class[0])) {
            return "/admin/common/error";
        }
        if (order.isExpired() || order.getOrderStatus() != Order.OrderStatus.confirmed) {
            return "/admin/common/error";
        }
        if (order.getPaymentStatus() != Order.PaymentStatus.paid && order.getPaymentStatus() != Order.PaymentStatus.partialPayment && order.getPaymentStatus() != Order.PaymentStatus.partialRefunds) {
            return "/admin/common/error";
        }
        if (refunds.getAmount().compareTo(new BigDecimal(0)) <= 0 || refunds.getAmount().compareTo(order.getAmountPaid()) > 0) {
            return "/admin/common/error";
        }
        Admin admin = this.IIIlllIl.getCurrent();
        if (order.isLocked(admin)) {
            return "/admin/common/error";
        }
        refunds.setSn(this.IIlIIlIl.generate(Sn.Type.refunds));
        refunds.setOperator(admin.getUsername());
        this.IIlIIIII.refunds(order, refunds, admin);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:view.jhtml?id=" + orderId;
    }

    @RequestMapping(value={"/shipping"}, method={RequestMethod.POST})
    public String shipping(Long orderId, Long shippingMethodId, Long deliveryCorpId, Long areaId, Shipping shipping, RedirectAttributes redirectAttributes) {
        OrderItem orderItem;
        ShippingItem shippingItem;
        Order order = (Order)this.IIlIIIII.find((Serializable)orderId);
        if (order == null) {
            return "/admin/common/error";
        }
        ShippingMethod shippingMethod = shipping.getShippingItems().iterator();
        while (shippingMethod.hasNext()) {
            shippingItem = (ShippingItem)shippingMethod.next();
            if (shippingItem == null || StringUtils.isEmpty((String)shippingItem.getSn()) || shippingItem.getQuantity() == null || shippingItem.getQuantity() <= 0) {
                shippingMethod.remove();
                continue;
            }
            orderItem = order.getOrderItem(shippingItem.getSn());
            if (orderItem == null || shippingItem.getQuantity() > orderItem.getQuantity() - orderItem.getShippedQuantity()) {
                return "/admin/common/error";
            }
            if (orderItem.getProduct() != null && orderItem.getProduct().getStock() != null && shippingItem.getQuantity() > orderItem.getProduct().getStock()) {
                return "/admin/common/error";
            }
            shippingItem.setName(orderItem.getFullName());
            shippingItem.setShipping(shipping);
        }
        shipping.setOrder(order);
        shippingMethod = (ShippingMethod)this.IIlIIIlI.find((Serializable)shippingMethodId);
        shipping.setShippingMethod(shippingMethod != null ? shippingMethod.getName() : null);
        shippingItem = (DeliveryCorp)this.IIlIIIll.find((Serializable)deliveryCorpId);
        shipping.setDeliveryCorp(shippingItem != null ? shippingItem.getName() : null);
        shipping.setDeliveryCorpUrl(shippingItem != null ? shippingItem.getUrl() : null);
        shipping.setDeliveryCorpCode(shippingItem != null ? shippingItem.getCode() : null);
        orderItem = (Area)this.IIIllllI.find((Serializable)areaId);
        shipping.setArea(orderItem != null ? orderItem.getFullName() : null);
        if (!this.IIIllIlI((Object)shipping, new Class[0])) {
            return "/admin/common/error";
        }
        if (order.isExpired() || order.getOrderStatus() != Order.OrderStatus.confirmed) {
            return "/admin/common/error";
        }
        if (order.getShippingStatus() != Order.ShippingStatus.unshipped && order.getShippingStatus() != Order.ShippingStatus.partialShipment) {
            return "/admin/common/error";
        }
        Admin admin = this.IIIlllIl.getCurrent();
        if (order.isLocked(admin)) {
            return "/admin/common/error";
        }
        shipping.setSn(this.IIlIIlIl.generate(Sn.Type.shipping));
        shipping.setOperator(admin.getUsername());
        this.IIlIIIII.shipping(order, shipping, admin);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:view.jhtml?id=" + orderId;
    }

    @RequestMapping(value={"/returns"}, method={RequestMethod.POST})
    public String returns(Long orderId, Long shippingMethodId, Long deliveryCorpId, Long areaId, Returns returns, RedirectAttributes redirectAttributes) {
        OrderItem orderItem;
        ReturnsItem returnsItem;
        Order order = (Order)this.IIlIIIII.find((Serializable)orderId);
        if (order == null) {
            return "/admin/common/error";
        }
        ShippingMethod shippingMethod = returns.getReturnsItems().iterator();
        while (shippingMethod.hasNext()) {
            returnsItem = (ReturnsItem)shippingMethod.next();
            if (returnsItem == null || StringUtils.isEmpty((String)returnsItem.getSn()) || returnsItem.getQuantity() == null || returnsItem.getQuantity() <= 0) {
                shippingMethod.remove();
                continue;
            }
            orderItem = order.getOrderItem(returnsItem.getSn());
            if (orderItem == null || returnsItem.getQuantity() > orderItem.getShippedQuantity() - orderItem.getReturnQuantity()) {
                return "/admin/common/error";
            }
            returnsItem.setName(orderItem.getFullName());
            returnsItem.setReturns(returns);
        }
        returns.setOrder(order);
        shippingMethod = (ShippingMethod)this.IIlIIIlI.find((Serializable)shippingMethodId);
        returns.setShippingMethod(shippingMethod != null ? shippingMethod.getName() : null);
        returnsItem = (DeliveryCorp)this.IIlIIIll.find((Serializable)deliveryCorpId);
        returns.setDeliveryCorp(returnsItem != null ? returnsItem.getName() : null);
        orderItem = (Area)this.IIIllllI.find((Serializable)areaId);
        returns.setArea(orderItem != null ? orderItem.getFullName() : null);
        if (!this.IIIllIlI((Object)returns, new Class[0])) {
            return "/admin/common/error";
        }
        if (order.isExpired() || order.getOrderStatus() != Order.OrderStatus.confirmed) {
            return "/admin/common/error";
        }
        if (order.getShippingStatus() != Order.ShippingStatus.shipped && order.getShippingStatus() != Order.ShippingStatus.partialShipment && order.getShippingStatus() != Order.ShippingStatus.partialReturns) {
            return "/admin/common/error";
        }
        Admin admin = this.IIIlllIl.getCurrent();
        if (order.isLocked(admin)) {
            return "/admin/common/error";
        }
        returns.setSn(this.IIlIIlIl.generate(Sn.Type.returns));
        returns.setOperator(admin.getUsername());
        this.IIlIIIII.returns(order, returns, admin);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:view.jhtml?id=" + orderId;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("paymentMethods", (Object)this.IIlIIlII.findAll());
        model.addAttribute("shippingMethods", (Object)this.IIlIIIlI.findAll());
        model.addAttribute("order", this.IIlIIIII.find((Serializable)id));
        return "/admin/order/edit";
    }

    @RequestMapping(value={"/order_item_add"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> orderItemAdd(String productSn) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Product product = this.IIIlllll.findBySn(productSn);
        if (product == null) {
            hashMap.put("message", Message.warn((String)"admin.order.productNotExist", (Object[])new Object[0]));
            return hashMap;
        }
        if (!product.getIsMarketable().booleanValue()) {
            hashMap.put("message", Message.warn((String)"admin.order.productNotMarketable", (Object[])new Object[0]));
            return hashMap;
        }
        if (product.getIsOutOfStock().booleanValue()) {
            hashMap.put("message", Message.warn((String)"admin.order.productOutOfStock", (Object[])new Object[0]));
            return hashMap;
        }
        hashMap.put("sn", product.getSn());
        hashMap.put("fullName", product.getFullName());
        hashMap.put("price", product.getPrice());
        hashMap.put("weight", product.getWeight());
        hashMap.put("isGift", product.getIsGift());
        hashMap.put("message", IIIlllII);
        return hashMap;
    }

    @RequestMapping(value={"/calculate"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> calculate(Order order, Long areaId, Long paymentMethodId, Long shippingMethodId) {
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Order order2 = order.getOrderItems().iterator();
        while (order2.hasNext()) {
            object2 = (OrderItem)order2.next();
            if (object2 != null && !StringUtils.isEmpty((String)object2.getSn())) continue;
            order2.remove();
        }
        order.setArea((Area)this.IIIllllI.find((Serializable)areaId));
        order.setPaymentMethod((PaymentMethod)this.IIlIIlII.find((Serializable)paymentMethodId));
        order.setShippingMethod((ShippingMethod)this.IIlIIIlI.find((Serializable)shippingMethodId));
        if (!this.IIIllIlI((Object)order, new Class[0])) {
            hashMap.put("message", Message.warn((String)"admin.common.invalid", (Object[])new Object[0]));
            return hashMap;
        }
        order2 = (Order)this.IIlIIIII.find((Serializable)order.getId());
        if (order2 == null) {
            hashMap.put("message", Message.error((String)"admin.common.invalid", (Object[])new Object[0]));
            return hashMap;
        }
        for (Object object2 : order.getOrderItems()) {
            Product product;
            if (object2.getId() != null) {
                product = (OrderItem)this.IIlIIIIl.find((Serializable)object2.getId());
                if (product == null || !order2.equals((Object)product.getOrder())) {
                    hashMap.put("message", Message.error((String)"admin.common.invalid", (Object[])new Object[0]));
                    return hashMap;
                }
                Product product2 = product.getProduct();
                if (product2 == null || product2.getStock() == null) continue;
                if (order2.getIsAllocatedStock().booleanValue()) {
                    if (object2.getQuantity() <= product2.getAvailableStock() + product.getQuantity()) continue;
                    hashMap.put("message", Message.warn((String)"admin.order.lowStock", (Object[])new Object[0]));
                    return hashMap;
                }
                if (object2.getQuantity() <= product2.getAvailableStock()) continue;
                hashMap.put("message", Message.warn((String)"admin.order.lowStock", (Object[])new Object[0]));
                return hashMap;
            }
            product = this.IIIlllll.findBySn(object2.getSn());
            if (product == null) {
                hashMap.put("message", Message.error((String)"admin.common.invalid", (Object[])new Object[0]));
                return hashMap;
            }
            if (product.getStock() == null || object2.getQuantity() <= product.getAvailableStock()) continue;
            hashMap.put("message", Message.warn((String)"admin.order.lowStock", (Object[])new Object[0]));
            return hashMap;
        }
        object2 = new HashMap();
        for (OrderItem orderItem : order.getOrderItems()) {
            object2.put(orderItem.getSn(), orderItem);
        }
        hashMap.put("weight", order.getWeight());
        hashMap.put("price", order.getPrice());
        hashMap.put("quantity", order.getQuantity());
        hashMap.put("amount", order.getAmount());
        hashMap.put("orderItems", object2);
        hashMap.put("message", IIIlllII);
        return hashMap;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Order order, Long areaId, Long paymentMethodId, Long shippingMethodId, RedirectAttributes redirectAttributes) {
        OrderItem orderItem;
        Order order2 = order.getOrderItems().iterator();
        while (order2.hasNext()) {
            orderItem = (OrderItem)order2.next();
            if (orderItem != null && !StringUtils.isEmpty((String)orderItem.getSn())) continue;
            order2.remove();
        }
        order.setArea((Area)this.IIIllllI.find((Serializable)areaId));
        order.setPaymentMethod((PaymentMethod)this.IIlIIlII.find((Serializable)paymentMethodId));
        order.setShippingMethod((ShippingMethod)this.IIlIIIlI.find((Serializable)shippingMethodId));
        if (!this.IIIllIlI((Object)order, new Class[0])) {
            return "/admin/common/error";
        }
        order2 = (Order)this.IIlIIIII.find((Serializable)order.getId());
        if (order2 == null) {
            return "/admin/common/error";
        }
        if (order2.isExpired() || order2.getOrderStatus() != Order.OrderStatus.unconfirmed) {
            return "/admin/common/error";
        }
        orderItem = this.IIIlllIl.getCurrent();
        if (order2.isLocked((Admin)orderItem)) {
            return "/admin/common/error";
        }
        if (!order.getIsInvoice().booleanValue()) {
            order.setInvoiceTitle(null);
            order.setTax(new BigDecimal(0));
        }
        for (OrderItem orderItem2 : order.getOrderItems()) {
            Product product;
            if (orderItem2.getId() != null) {
                product = (OrderItem)this.IIlIIIIl.find((Serializable)orderItem2.getId());
                if (product == null || !order2.equals((Object)product.getOrder())) {
                    return "/admin/common/error";
                }
                Product product2 = product.getProduct();
                if (product2 != null && product2.getStock() != null && (order2.getIsAllocatedStock() != false ? orderItem2.getQuantity() > product2.getAvailableStock() + product.getQuantity() : orderItem2.getQuantity() > product2.getAvailableStock())) {
                    return "/admin/common/error";
                }
                BeanUtils.copyProperties((Object)product, (Object)orderItem2, (String[])new String[]{"price", "quantity"});
                if (!product.getIsGift().booleanValue()) continue;
                orderItem2.setPrice(new BigDecimal(0));
                continue;
            }
            product = this.IIIlllll.findBySn(orderItem2.getSn());
            if (product == null) {
                return "/admin/common/error";
            }
            if (product.getStock() != null && orderItem2.getQuantity() > product.getAvailableStock()) {
                return "/admin/common/error";
            }
            orderItem2.setName(product.getName());
            orderItem2.setFullName(product.getFullName());
            if (product.getIsGift().booleanValue()) {
                orderItem2.setPrice(new BigDecimal(0));
            }
            orderItem2.setWeight(product.getWeight());
            orderItem2.setThumbnail(product.getThumbnail());
            orderItem2.setIsGift(product.getIsGift());
            orderItem2.setShippedQuantity(Integer.valueOf(0));
            orderItem2.setReturnQuantity(Integer.valueOf(0));
            orderItem2.setProduct(product);
            orderItem2.setOrder(order2);
        }
        order.setSn(order2.getSn());
        order.setOrderStatus(order2.getOrderStatus());
        order.setPaymentStatus(order2.getPaymentStatus());
        order.setShippingStatus(order2.getShippingStatus());
        order.setFee(order2.getFee());
        order.setAmountPaid(order2.getAmountPaid());
        order.setPromotion(order2.getPromotion());
        order.setExpire(order2.getExpire());
        order.setLockExpire(null);
        order.setIsAllocatedStock(order2.getIsAllocatedStock());
        order.setOperator(null);
        order.setMember(order2.getMember());
        order.setCouponCode(order2.getCouponCode());
        order.setCoupons(order2.getCoupons());
        order.setOrderLogs(order2.getOrderLogs());
        order.setDeposits(order2.getDeposits());
        order.setPayments(order2.getPayments());
        order.setRefunds(order2.getRefunds());
        order.setShippings(order2.getShippings());
        order.setReturns(order2.getReturns());
        this.IIlIIIII.update(order, (Admin)orderItem);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Order.OrderStatus orderStatus, Order.PaymentStatus paymentStatus, Order.ShippingStatus shippingStatus, Boolean hasExpired, Pageable pageable, ModelMap model) {
        model.addAttribute("orderStatus", (Object)orderStatus);
        model.addAttribute("paymentStatus", (Object)paymentStatus);
        model.addAttribute("shippingStatus", (Object)shippingStatus);
        model.addAttribute("hasExpired", (Object)hasExpired);
        model.addAttribute("page", (Object)this.IIlIIIII.findPage(orderStatus, paymentStatus, shippingStatus, hasExpired, pageable));
        return "/admin/order/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        if (ids != null) {
            Admin admin = this.IIIlllIl.getCurrent();
            Long[] longArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Long l = longArray[n2];
                Order order = (Order)this.IIlIIIII.find((Serializable)l);
                if (order != null && order.isLocked(admin)) {
                    return Message.error((String)"admin.order.deleteLockedNotAllowed", (Object[])new Object[]{order.getSn()});
                }
                ++n2;
            }
            this.IIlIIIII.delete((Serializable[])ids);
        }
        return IIIlllII;
    }
}

