/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.ProductCategory;
import net.shopxx.service.BrandService;
import net.shopxx.service.ProductCategoryService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminProductCategoryController")
@RequestMapping(value={"/admin/product_category"})
public class ProductCategoryController
extends BaseController {
    @Resource(name="productCategoryServiceImpl")
    private ProductCategoryService IIIlllIl;
    @Resource(name="brandServiceImpl")
    private BrandService IIIllllI;

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("productCategoryTree", (Object)this.IIIlllIl.findTree());
        model.addAttribute("brands", (Object)this.IIIllllI.findAll());
        return "/admin/product_category/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(ProductCategory productCategory, Long parentId, Long[] brandIds, RedirectAttributes redirectAttributes) {
        productCategory.setParent((ProductCategory)this.IIIlllIl.find((Serializable)parentId));
        productCategory.setBrands(new HashSet(this.IIIllllI.findList((Serializable[])brandIds)));
        if (!this.IIIllIlI((Object)productCategory, new Class[0])) {
            return "/admin/common/error";
        }
        productCategory.setTreePath(null);
        productCategory.setGrade(null);
        productCategory.setChildren(null);
        productCategory.setProducts(null);
        productCategory.setParameterGroups(null);
        productCategory.setAttributes(null);
        productCategory.setPromotions(null);
        this.IIIlllIl.save((Object)productCategory);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        ProductCategory productCategory = (ProductCategory)this.IIIlllIl.find((Serializable)id);
        model.addAttribute("productCategoryTree", (Object)this.IIIlllIl.findTree());
        model.addAttribute("brands", (Object)this.IIIllllI.findAll());
        model.addAttribute("productCategory", (Object)productCategory);
        model.addAttribute("children", (Object)this.IIIlllIl.findChildren(productCategory));
        return "/admin/product_category/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(ProductCategory productCategory, Long parentId, Long[] brandIds, RedirectAttributes redirectAttributes) {
        productCategory.setParent((ProductCategory)this.IIIlllIl.find((Serializable)parentId));
        productCategory.setBrands(new HashSet(this.IIIllllI.findList((Serializable[])brandIds)));
        if (!this.IIIllIlI((Object)productCategory, new Class[0])) {
            return "/admin/common/error";
        }
        if (productCategory.getParent() != null) {
            ProductCategory productCategory2 = productCategory.getParent();
            if (productCategory2.equals((Object)productCategory)) {
                return "/admin/common/error";
            }
            List list = this.IIIlllIl.findChildren(productCategory2);
            if (list != null && list.contains(productCategory2)) {
                return "/admin/common/error";
            }
        }
        this.IIIlllIl.update((Object)productCategory, new String[]{"treePath", "grade", "children", "products", "parameterGroups", "attributes", "promotions"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(ModelMap model) {
        model.addAttribute("productCategoryTree", (Object)this.IIIlllIl.findTree());
        return "/admin/product_category/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long id) {
        ProductCategory productCategory = (ProductCategory)this.IIIlllIl.find((Serializable)id);
        if (productCategory == null) {
            return IIIllIll;
        }
        Set set = productCategory.getChildren();
        if (set != null && !set.isEmpty()) {
            return Message.error((String)"admin.productCategory.deleteExistChildrenNotAllowed", (Object[])new Object[0]);
        }
        Set set2 = productCategory.getProducts();
        if (set2 != null && !set2.isEmpty()) {
            return Message.error((String)"admin.productCategory.deleteExistProductNotAllowed", (Object[])new Object[0]);
        }
        this.IIIlllIl.delete((Serializable)id);
        return IIIlllII;
    }
}

