/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.FileInfo$FileType;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.Setting;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Attribute;
import net.shopxx.entity.Brand;
import net.shopxx.entity.Goods;
import net.shopxx.entity.MemberRank;
import net.shopxx.entity.ParameterGroup;
import net.shopxx.entity.Product;
import net.shopxx.entity.ProductCategory;
import net.shopxx.entity.ProductImage;
import net.shopxx.entity.Promotion;
import net.shopxx.entity.Specification;
import net.shopxx.entity.SpecificationValue;
import net.shopxx.entity.Tag;
import net.shopxx.service.BrandService;
import net.shopxx.service.FileService;
import net.shopxx.service.GoodsService;
import net.shopxx.service.MemberRankService;
import net.shopxx.service.ProductCategoryService;
import net.shopxx.service.ProductImageService;
import net.shopxx.service.ProductService;
import net.shopxx.service.PromotionService;
import net.shopxx.service.SpecificationService;
import net.shopxx.service.SpecificationValueService;
import net.shopxx.service.TagService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="adminProductController")
@RequestMapping(value={"/admin/product"})
public class ProductController
extends BaseController {
    @Resource(name="productServiceImpl")
    private ProductService IIIlllIl;
    @Resource(name="productCategoryServiceImpl")
    private ProductCategoryService IIIllllI;
    @Resource(name="goodsServiceImpl")
    private GoodsService IIIlllll;
    @Resource(name="brandServiceImpl")
    private BrandService IIlIIIII;
    @Resource(name="promotionServiceImpl")
    private PromotionService IIlIIIIl;
    @Resource(name="tagServiceImpl")
    private TagService IIlIIIlI;
    @Resource(name="memberRankServiceImpl")
    private MemberRankService IIlIIIll;
    @Resource(name="productImageServiceImpl")
    private ProductImageService IIlIIlII;
    @Resource(name="specificationServiceImpl")
    private SpecificationService IIlIIlIl;
    @Resource(name="specificationValueServiceImpl")
    private SpecificationValueService IIlIIllI;
    @Resource(name="fileServiceImpl")
    private FileService IIlIIlll;

    @RequestMapping(value={"/check_sn"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkSn(String previousSn, String sn) {
        if (StringUtils.isEmpty((String)sn)) {
            return false;
        }
        return this.IIIlllIl.snUnique(previousSn, sn);
    }

    @RequestMapping(value={"/parameter_groups"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<ParameterGroup> parameterGroups(Long id) {
        ProductCategory productCategory = (ProductCategory)this.IIIllllI.find((Serializable)id);
        return productCategory.getParameterGroups();
    }

    @RequestMapping(value={"/attributes"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<Attribute> attributes(Long id) {
        ProductCategory productCategory = (ProductCategory)this.IIIllllI.find((Serializable)id);
        return productCategory.getAttributes();
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("productCategoryTree", (Object)this.IIIllllI.findTree());
        model.addAttribute("brands", (Object)this.IIlIIIII.findAll());
        model.addAttribute("tags", (Object)this.IIlIIIlI.findList(Tag.Type.product));
        model.addAttribute("memberRanks", (Object)this.IIlIIIll.findAll());
        model.addAttribute("specifications", (Object)this.IIlIIlIl.findAll());
        return "/admin/product/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Product product, Long productCategoryId, Long brandId, Long[] tagIds, Long[] specificationIds, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String[] stringArray;
        String string2;
        Object object;
        Object object2 = product.getProductImages().iterator();
        while (object2.hasNext()) {
            object = (ProductImage)object2.next();
            if (object == null || object.isEmpty()) {
                object2.remove();
                continue;
            }
            if (object.getFile() == null || object.getFile().isEmpty() || this.IIlIIlll.isValid(FileInfo$FileType.image, object.getFile())) continue;
            this.IIIllIlI(redirectAttributes, Message.error((String)"admin.upload.invalid", (Object[])new Object[0]));
            return "redirect:add.jhtml";
        }
        product.setProductCategory((ProductCategory)this.IIIllllI.find((Serializable)productCategoryId));
        product.setBrand((Brand)this.IIlIIIII.find((Serializable)brandId));
        product.setTags(new HashSet(this.IIlIIIlI.findList((Serializable[])tagIds)));
        if (!this.IIIllIlI((Object)product, new Class[0])) {
            return "/admin/common/error";
        }
        if (StringUtils.isNotEmpty((String)product.getSn()) && this.IIIlllIl.snExists(product.getSn())) {
            return "/admin/common/error";
        }
        if (product.getMarketPrice() == null) {
            object2 = this.IIIllIlI(product.getPrice());
            product.setMarketPrice((BigDecimal)object2);
        }
        if (product.getPoint() == null) {
            long l = this.IIIllIll(product.getPrice());
            product.setPoint(Long.valueOf(l));
        }
        product.setFullName(null);
        product.setAllocatedStock(Integer.valueOf(0));
        product.setScore(Float.valueOf(0.0f));
        product.setTotalScore(Long.valueOf(0L));
        product.setScoreCount(Long.valueOf(0L));
        product.setHits(Long.valueOf(0L));
        product.setWeekHits(Long.valueOf(0L));
        product.setMonthHits(Long.valueOf(0L));
        product.setSales(Long.valueOf(0L));
        product.setWeekSales(Long.valueOf(0L));
        product.setMonthSales(Long.valueOf(0L));
        product.setWeekHitsDate(new Date());
        product.setMonthHitsDate(new Date());
        product.setWeekSalesDate(new Date());
        product.setMonthSalesDate(new Date());
        product.setReviews(null);
        product.setConsultations(null);
        product.setFavoriteMembers(null);
        product.setPromotions(null);
        product.setCartItems(null);
        product.setOrderItems(null);
        product.setGiftItems(null);
        product.setProductNotifies(null);
        for (MemberRank memberRank : this.IIlIIIll.findAll()) {
            string2 = request.getParameter("memberPrice_" + memberRank.getId());
            if (StringUtils.isNotEmpty((String)string2) && new BigDecimal(string2).compareTo(new BigDecimal(0)) >= 0) {
                product.getMemberPrice().put(memberRank, new BigDecimal(string2));
                continue;
            }
            product.getMemberPrice().remove(memberRank);
        }
        for (ProductImage productImage : product.getProductImages()) {
            this.IIlIIlII.build(productImage);
        }
        Collections.sort(product.getProductImages());
        if (product.getImage() == null && product.getThumbnail() != null) {
            product.setImage(product.getThumbnail());
        }
        for (ParameterGroup parameterGroup : product.getProductCategory().getParameterGroups()) {
            for (String string2 : parameterGroup.getParameters()) {
                stringArray = request.getParameter("parameter_" + string2.getId());
                if (StringUtils.isNotEmpty((String)stringArray)) {
                    product.getParameterValue().put(string2, stringArray);
                    continue;
                }
                product.getParameterValue().remove(string2);
            }
        }
        for (Attribute attribute : product.getProductCategory().getAttributes()) {
            string2 = request.getParameter("attribute_" + attribute.getId());
            if (StringUtils.isNotEmpty((String)string2)) {
                product.setAttributeValue(attribute, string2);
                continue;
            }
            product.setAttributeValue(attribute, null);
        }
        Goods goods = new Goods();
        object = new ArrayList();
        if (specificationIds != null && specificationIds.length > 0) {
            int n = 0;
            while (n < specificationIds.length) {
                Specification specification = (Specification)this.IIlIIlIl.find((Serializable)specificationIds[n]);
                stringArray = request.getParameterValues("specification_" + specification.getId());
                if (stringArray != null && stringArray.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        Product product2;
                        if (n == 0) {
                            if (n2 == 0) {
                                product.setGoods(goods);
                                product.setSpecifications(new HashSet());
                                product.setSpecificationValues(new HashSet());
                                object.add(product);
                            } else {
                                product2 = new Product();
                                BeanUtils.copyProperties((Object)product, (Object)product2);
                                product2.setId(null);
                                product2.setCreateDate(null);
                                product2.setModifyDate(null);
                                product2.setSn(null);
                                product2.setFullName(null);
                                product2.setAllocatedStock(Integer.valueOf(0));
                                product2.setIsList(Boolean.valueOf(false));
                                product2.setScore(Float.valueOf(0.0f));
                                product2.setTotalScore(Long.valueOf(0L));
                                product2.setScoreCount(Long.valueOf(0L));
                                product2.setHits(Long.valueOf(0L));
                                product2.setWeekHits(Long.valueOf(0L));
                                product2.setMonthHits(Long.valueOf(0L));
                                product2.setSales(Long.valueOf(0L));
                                product2.setWeekSales(Long.valueOf(0L));
                                product2.setMonthSales(Long.valueOf(0L));
                                product2.setWeekHitsDate(new Date());
                                product2.setMonthHitsDate(new Date());
                                product2.setWeekSalesDate(new Date());
                                product2.setMonthSalesDate(new Date());
                                product2.setGoods(goods);
                                product2.setReviews(null);
                                product2.setConsultations(null);
                                product2.setFavoriteMembers(null);
                                product2.setSpecifications(new HashSet());
                                product2.setSpecificationValues(new HashSet());
                                product2.setPromotions(null);
                                product2.setCartItems(null);
                                product2.setOrderItems(null);
                                product2.setGiftItems(null);
                                product2.setProductNotifies(null);
                                object.add(product2);
                            }
                        }
                        product2 = (Product)object.get(n2);
                        SpecificationValue specificationValue = (SpecificationValue)this.IIlIIllI.find((Serializable)Long.valueOf(stringArray[n2]));
                        product2.getSpecifications().add(specification);
                        product2.getSpecificationValues().add(specificationValue);
                        ++n2;
                    }
                }
                ++n;
            }
        } else {
            product.setGoods(goods);
            product.setSpecifications(null);
            product.setSpecificationValues(null);
            object.add(product);
        }
        goods.getProducts().clear();
        goods.getProducts().addAll(object);
        this.IIIlllll.save((Object)goods);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("productCategoryTree", (Object)this.IIIllllI.findTree());
        model.addAttribute("brands", (Object)this.IIlIIIII.findAll());
        model.addAttribute("tags", (Object)this.IIlIIIlI.findList(Tag.Type.product));
        model.addAttribute("memberRanks", (Object)this.IIlIIIll.findAll());
        model.addAttribute("specifications", (Object)this.IIlIIlIl.findAll());
        model.addAttribute("product", this.IIIlllIl.find((Serializable)id));
        return "/admin/product/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Product product, Long productCategoryId, Long brandId, Long[] tagIds, Long[] specificationIds, Long[] specificationProductIds, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String[] stringArray;
        String string2;
        Object object;
        Product product2 = product.getProductImages().iterator();
        while (product2.hasNext()) {
            object = (ProductImage)product2.next();
            if (object == null || object.isEmpty()) {
                product2.remove();
                continue;
            }
            if (object.getFile() == null || object.getFile().isEmpty() || this.IIlIIlll.isValid(FileInfo$FileType.image, object.getFile())) continue;
            this.IIIllIlI(redirectAttributes, Message.error((String)"admin.upload.invalid", (Object[])new Object[0]));
            return "redirect:edit.jhtml?id=" + product.getId();
        }
        product.setProductCategory((ProductCategory)this.IIIllllI.find((Serializable)productCategoryId));
        product.setBrand((Brand)this.IIlIIIII.find((Serializable)brandId));
        product.setTags(new HashSet(this.IIlIIIlI.findList((Serializable[])tagIds)));
        if (!this.IIIllIlI((Object)product, new Class[0])) {
            return "/admin/common/error";
        }
        product2 = (Product)this.IIIlllIl.find((Serializable)product.getId());
        if (product2 == null) {
            return "/admin/common/error";
        }
        if (StringUtils.isNotEmpty((String)product.getSn()) && !this.IIIlllIl.snUnique(product2.getSn(), product.getSn())) {
            return "/admin/common/error";
        }
        if (product.getMarketPrice() == null) {
            object = this.IIIllIlI(product.getPrice());
            product.setMarketPrice((BigDecimal)object);
        }
        if (product.getPoint() == null) {
            long l = this.IIIllIll(product.getPrice());
            product.setPoint(Long.valueOf(l));
        }
        for (MemberRank memberRank : this.IIlIIIll.findAll()) {
            string2 = request.getParameter("memberPrice_" + memberRank.getId());
            if (StringUtils.isNotEmpty((String)string2) && new BigDecimal(string2).compareTo(new BigDecimal(0)) >= 0) {
                product.getMemberPrice().put(memberRank, new BigDecimal(string2));
                continue;
            }
            product.getMemberPrice().remove(memberRank);
        }
        for (ProductImage productImage : product.getProductImages()) {
            this.IIlIIlII.build(productImage);
        }
        Collections.sort(product.getProductImages());
        if (product.getImage() == null && product.getThumbnail() != null) {
            product.setImage(product.getThumbnail());
        }
        for (ParameterGroup parameterGroup : product.getProductCategory().getParameterGroups()) {
            for (String string2 : parameterGroup.getParameters()) {
                stringArray = request.getParameter("parameter_" + string2.getId());
                if (StringUtils.isNotEmpty((String)stringArray)) {
                    product.getParameterValue().put(string2, stringArray);
                    continue;
                }
                product.getParameterValue().remove(string2);
            }
        }
        for (Attribute attribute : product.getProductCategory().getAttributes()) {
            string2 = request.getParameter("attribute_" + attribute.getId());
            if (StringUtils.isNotEmpty((String)string2)) {
                product.setAttributeValue(attribute, string2);
                continue;
            }
            product.setAttributeValue(attribute, null);
        }
        Goods goods = product2.getGoods();
        ArrayList arrayList = new ArrayList();
        if (specificationIds != null && specificationIds.length > 0) {
            int n = 0;
            while (n < specificationIds.length) {
                Specification specification = (Specification)this.IIlIIlIl.find((Serializable)specificationIds[n]);
                stringArray = request.getParameterValues("specification_" + specification.getId());
                if (stringArray != null && stringArray.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        Product product3;
                        if (n == 0) {
                            if (n2 == 0) {
                                BeanUtils.copyProperties((Object)product, (Object)product2, (String[])new String[]{"id", "createDate", "modifyDate", "fullName", "allocatedStock", "score", "totalScore", "scoreCount", "hits", "weekHits", "monthHits", "sales", "weekSales", "monthSales", "weekHitsDate", "monthHitsDate", "weekSalesDate", "monthSalesDate", "goods", "reviews", "consultations", "favoriteMembers", "specifications", "specificationValues", "promotions", "cartItems", "orderItems", "giftItems", "productNotifies"});
                                product2.setSpecifications(new HashSet());
                                product2.setSpecificationValues(new HashSet());
                                arrayList.add(product2);
                            } else if (specificationProductIds != null && n2 < specificationProductIds.length) {
                                product3 = (Product)this.IIIlllIl.find((Serializable)specificationProductIds[n2]);
                                if (product3.getGoods() != goods) {
                                    return "/admin/common/error";
                                }
                                product3.setSpecifications(new HashSet());
                                product3.setSpecificationValues(new HashSet());
                                arrayList.add(product3);
                            } else {
                                product3 = new Product();
                                BeanUtils.copyProperties((Object)product, (Object)product3);
                                product3.setId(null);
                                product3.setCreateDate(null);
                                product3.setModifyDate(null);
                                product3.setSn(null);
                                product3.setFullName(null);
                                product3.setAllocatedStock(Integer.valueOf(0));
                                product3.setIsList(Boolean.valueOf(false));
                                product3.setScore(Float.valueOf(0.0f));
                                product3.setTotalScore(Long.valueOf(0L));
                                product3.setScoreCount(Long.valueOf(0L));
                                product3.setHits(Long.valueOf(0L));
                                product3.setWeekHits(Long.valueOf(0L));
                                product3.setMonthHits(Long.valueOf(0L));
                                product3.setSales(Long.valueOf(0L));
                                product3.setWeekSales(Long.valueOf(0L));
                                product3.setMonthSales(Long.valueOf(0L));
                                product3.setWeekHitsDate(new Date());
                                product3.setMonthHitsDate(new Date());
                                product3.setWeekSalesDate(new Date());
                                product3.setMonthSalesDate(new Date());
                                product3.setGoods(goods);
                                product3.setReviews(null);
                                product3.setConsultations(null);
                                product3.setFavoriteMembers(null);
                                product3.setSpecifications(new HashSet());
                                product3.setSpecificationValues(new HashSet());
                                product3.setPromotions(null);
                                product3.setCartItems(null);
                                product3.setOrderItems(null);
                                product3.setGiftItems(null);
                                product3.setProductNotifies(null);
                                arrayList.add(product3);
                            }
                        }
                        product3 = (Product)arrayList.get(n2);
                        SpecificationValue specificationValue = (SpecificationValue)this.IIlIIllI.find((Serializable)Long.valueOf(stringArray[n2]));
                        product3.getSpecifications().add(specification);
                        product3.getSpecificationValues().add(specificationValue);
                        ++n2;
                    }
                }
                ++n;
            }
        } else {
            product.setSpecifications(null);
            product.setSpecificationValues(null);
            BeanUtils.copyProperties((Object)product, (Object)product2, (String[])new String[]{"id", "createDate", "modifyDate", "fullName", "allocatedStock", "score", "totalScore", "scoreCount", "hits", "weekHits", "monthHits", "sales", "weekSales", "monthSales", "weekHitsDate", "monthHitsDate", "weekSalesDate", "monthSalesDate", "goods", "reviews", "consultations", "favoriteMembers", "promotions", "cartItems", "orderItems", "giftItems", "productNotifies"});
            arrayList.add(product2);
        }
        goods.getProducts().clear();
        goods.getProducts().addAll(arrayList);
        this.IIIlllll.update((Object)goods);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Long productCategoryId, Long brandId, Long promotionId, Long tagId, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert, Pageable pageable, ModelMap model) {
        ProductCategory productCategory = (ProductCategory)this.IIIllllI.find((Serializable)productCategoryId);
        Brand brand = (Brand)this.IIlIIIII.find((Serializable)brandId);
        Promotion promotion = (Promotion)this.IIlIIIIl.find((Serializable)promotionId);
        List list = this.IIlIIIlI.findList((Serializable[])new Long[]{tagId});
        model.addAttribute("productCategoryTree", (Object)this.IIIllllI.findTree());
        model.addAttribute("brands", (Object)this.IIlIIIII.findAll());
        model.addAttribute("promotions", (Object)this.IIlIIIIl.findAll());
        model.addAttribute("tags", (Object)this.IIlIIIlI.findList(Tag.Type.product));
        model.addAttribute("productCategoryId", (Object)productCategoryId);
        model.addAttribute("brandId", (Object)brandId);
        model.addAttribute("promotionId", (Object)promotionId);
        model.addAttribute("tagId", (Object)tagId);
        model.addAttribute("isMarketable", (Object)isMarketable);
        model.addAttribute("isList", (Object)isList);
        model.addAttribute("isTop", (Object)isTop);
        model.addAttribute("isGift", (Object)isGift);
        model.addAttribute("isOutOfStock", (Object)isOutOfStock);
        model.addAttribute("isStockAlert", (Object)isStockAlert);
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(productCategory, brand, promotion, list, null, null, null, isMarketable, isList, isTop, isGift, isOutOfStock, isStockAlert, Product.OrderType.dateDesc, pageable));
        return "/admin/product/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        this.IIIlllIl.delete((Serializable[])ids);
        return IIIlllII;
    }

    private BigDecimal IIIllIlI(BigDecimal bigDecimal) {
        Setting setting = SettingUtils.get();
        Double d = setting.getDefaultMarketPriceScale();
        return setting.setScale(bigDecimal.multiply(new BigDecimal(d.toString())));
    }

    private long IIIllIll(BigDecimal bigDecimal) {
        Setting setting = SettingUtils.get();
        Double d = setting.getDefaultPointScale();
        return bigDecimal.multiply(new BigDecimal(d.toString())).longValue();
    }
}

