/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.GiftItem;
import net.shopxx.entity.Product;
import net.shopxx.entity.Promotion;
import net.shopxx.service.BrandService;
import net.shopxx.service.CouponService;
import net.shopxx.service.MemberRankService;
import net.shopxx.service.ProductCategoryService;
import net.shopxx.service.ProductService;
import net.shopxx.service.PromotionService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="adminPromotionController")
@RequestMapping(value={"/admin/promotion"})
public class PromotionController
extends BaseController {
    @Resource(name="promotionServiceImpl")
    private PromotionService IIIlllIl;
    @Resource(name="memberRankServiceImpl")
    private MemberRankService IIIllllI;
    @Resource(name="productCategoryServiceImpl")
    private ProductCategoryService IIIlllll;
    @Resource(name="productServiceImpl")
    private ProductService IIlIIIII;
    @Resource(name="brandServiceImpl")
    private BrandService IIlIIIIl;
    @Resource(name="couponServiceImpl")
    private CouponService IIlIIIlI;

    @RequestMapping(value={"/product_select"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> productSelect(String q) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotEmpty((String)q)) {
            List list = this.IIlIIIII.search(q, Boolean.valueOf(false), Integer.valueOf(20));
            for (Product product : list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", product.getId());
                hashMap.put("sn", product.getSn());
                hashMap.put("fullName", product.getFullName());
                hashMap.put("path", product.getPath());
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    @RequestMapping(value={"/gift_select"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> giftSelect(String q) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotEmpty((String)q)) {
            List list = this.IIlIIIII.search(q, Boolean.valueOf(true), Integer.valueOf(20));
            for (Product product : list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", product.getId());
                hashMap.put("sn", product.getSn());
                hashMap.put("fullName", product.getFullName());
                hashMap.put("path", product.getPath());
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("operators", (Object)Promotion.Operator.values());
        model.addAttribute("memberRanks", (Object)this.IIIllllI.findAll());
        model.addAttribute("productCategories", (Object)this.IIIlllll.findAll());
        model.addAttribute("brands", (Object)this.IIlIIIIl.findAll());
        model.addAttribute("coupons", (Object)this.IIlIIIlI.findAll());
        return "/admin/promotion/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Promotion promotion, Long[] memberRankIds, Long[] productCategoryIds, Long[] brandIds, Long[] couponIds, Long[] productIds, RedirectAttributes redirectAttributes) {
        Product product2;
        promotion.setMemberRanks(new HashSet(this.IIIllllI.findList((Serializable[])memberRankIds)));
        promotion.setProductCategories(new HashSet(this.IIIlllll.findList((Serializable[])productCategoryIds)));
        promotion.setBrands(new HashSet(this.IIlIIIIl.findList((Serializable[])brandIds)));
        promotion.setCoupons(new HashSet(this.IIlIIIlI.findList((Serializable[])couponIds)));
        for (Product product2 : this.IIlIIIII.findList((Serializable[])productIds)) {
            if (product2.getIsGift().booleanValue()) continue;
            promotion.getProducts().add(product2);
        }
        product2 = promotion.getGiftItems().iterator();
        while (product2.hasNext()) {
            GiftItem giftItem = (GiftItem)product2.next();
            if (giftItem == null || giftItem.getGift() == null || giftItem.getGift().getId() == null) {
                product2.remove();
                continue;
            }
            giftItem.setGift((Product)this.IIlIIIII.find((Serializable)giftItem.getGift().getId()));
            giftItem.setPromotion(promotion);
        }
        if (!this.IIIllIlI((Object)promotion, new Class[0])) {
            return "/admin/common/error";
        }
        if (promotion.getBeginDate() != null && promotion.getEndDate() != null && promotion.getBeginDate().after(promotion.getEndDate())) {
            return "/admin/common/error";
        }
        if (promotion.getStartPrice() != null && promotion.getEndPrice() != null && promotion.getStartPrice().compareTo(promotion.getEndPrice()) > 0) {
            return "/admin/common/error";
        }
        if (promotion.getPriceOperator() == Promotion.Operator.divide && promotion.getPriceValue() != null && promotion.getPriceValue().compareTo(new BigDecimal(0)) == 0) {
            return "/admin/common/error";
        }
        if (promotion.getPointOperator() == Promotion.Operator.divide && promotion.getPointValue() != null && promotion.getPointValue().compareTo(new BigDecimal(0)) == 0) {
            return "/admin/common/error";
        }
        this.IIIlllIl.save((Object)promotion);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("promotion", this.IIIlllIl.find((Serializable)id));
        model.addAttribute("operators", (Object)Promotion.Operator.values());
        model.addAttribute("memberRanks", (Object)this.IIIllllI.findAll());
        model.addAttribute("productCategories", (Object)this.IIIlllll.findAll());
        model.addAttribute("brands", (Object)this.IIlIIIIl.findAll());
        model.addAttribute("coupons", (Object)this.IIlIIIlI.findAll());
        return "/admin/promotion/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Promotion promotion, Long[] memberRankIds, Long[] productCategoryIds, Long[] brandIds, Long[] couponIds, Long[] productIds, RedirectAttributes redirectAttributes) {
        Product product2;
        promotion.setMemberRanks(new HashSet(this.IIIllllI.findList((Serializable[])memberRankIds)));
        promotion.setProductCategories(new HashSet(this.IIIlllll.findList((Serializable[])productCategoryIds)));
        promotion.setBrands(new HashSet(this.IIlIIIIl.findList((Serializable[])brandIds)));
        promotion.setCoupons(new HashSet(this.IIlIIIlI.findList((Serializable[])couponIds)));
        for (Product product2 : this.IIlIIIII.findList((Serializable[])productIds)) {
            if (product2.getIsGift().booleanValue()) continue;
            promotion.getProducts().add(product2);
        }
        product2 = promotion.getGiftItems().iterator();
        while (product2.hasNext()) {
            GiftItem giftItem = (GiftItem)product2.next();
            if (giftItem == null || giftItem.getGift() == null || giftItem.getGift().getId() == null) {
                product2.remove();
                continue;
            }
            giftItem.setGift((Product)this.IIlIIIII.find((Serializable)giftItem.getGift().getId()));
            giftItem.setPromotion(promotion);
        }
        if (!this.IIIllIlI((Object)promotion, new Class[0])) {
            return "/admin/common/error";
        }
        if (promotion.getBeginDate() != null && promotion.getEndDate() != null && promotion.getBeginDate().after(promotion.getEndDate())) {
            return "/admin/common/error";
        }
        if (promotion.getPriceOperator() == Promotion.Operator.divide && promotion.getPriceValue() != null && promotion.getPriceValue().compareTo(new BigDecimal(0)) == 0) {
            return "/admin/common/error";
        }
        if (promotion.getPointOperator() == Promotion.Operator.divide && promotion.getPointValue() != null && promotion.getPointValue().compareTo(new BigDecimal(0)) == 0) {
            return "/admin/common/error";
        }
        this.IIIlllIl.update((Object)promotion);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, ModelMap model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(pageable));
        return "/admin/promotion/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        this.IIIlllIl.delete((Serializable[])ids);
        return IIIlllII;
    }
}

