/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Specification;
import net.shopxx.entity.SpecificationValue;
import net.shopxx.service.SpecificationService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminSpecificationController")
@RequestMapping(value={"/admin/specification"})
public class SpecificationController
extends BaseController {
    @Resource(name="specificationServiceImpl")
    private SpecificationService IIIlllIl;

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("types", (Object)Specification.Type.values());
        return "/admin/specification/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Specification specification, RedirectAttributes redirectAttributes) {
        Iterator iterator = specification.getSpecificationValues().iterator();
        while (iterator.hasNext()) {
            SpecificationValue specificationValue = (SpecificationValue)iterator.next();
            if (specificationValue == null || specificationValue.getName() == null) {
                iterator.remove();
                continue;
            }
            if (specification.getType() == Specification.Type.text) {
                specificationValue.setImage(null);
            }
            specificationValue.setSpecification(specification);
        }
        if (!this.IIIllIlI((Object)specification, new Class[0])) {
            return "/admin/common/error";
        }
        specification.setProducts(null);
        this.IIIlllIl.save((Object)specification);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("types", (Object)Specification.Type.values());
        model.addAttribute("specification", this.IIIlllIl.find((Serializable)id));
        return "/admin/specification/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Specification specification, RedirectAttributes redirectAttributes) {
        Iterator iterator = specification.getSpecificationValues().iterator();
        while (iterator.hasNext()) {
            SpecificationValue specificationValue = (SpecificationValue)iterator.next();
            if (specificationValue == null || specificationValue.getName() == null) {
                iterator.remove();
                continue;
            }
            if (specification.getType() == Specification.Type.text) {
                specificationValue.setImage(null);
            }
            specificationValue.setSpecification(specification);
        }
        if (!this.IIIllIlI((Object)specification, new Class[0])) {
            return "/admin/common/error";
        }
        this.IIIlllIl.update((Object)specification, new String[]{"products"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, ModelMap model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(pageable));
        return "/admin/specification/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        if (ids != null) {
            Long[] longArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Long l = longArray[n2];
                Specification specification = (Specification)this.IIIlllIl.find((Serializable)l);
                if (specification != null && specification.getProducts() != null && !specification.getProducts().isEmpty()) {
                    return Message.error((String)"admin.specification.deleteExistProductNotAllowed", (Object[])new Object[]{specification.getName()});
                }
                ++n2;
            }
            this.IIIlllIl.delete((Serializable[])ids);
        }
        return IIIlllII;
    }
}

