/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.io.Serializable;
import javax.annotation.Resource;
import net.shopxx.Pageable;
import net.shopxx.ResourceNotFoundException;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.ArticleCategory;
import net.shopxx.service.ArticleCategoryService;
import net.shopxx.service.ArticleService;
import net.shopxx.service.SearchService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shopArticleController")
@RequestMapping(value={"/article"})
public class ArticleController
extends BaseController {
    private static final int IIIlllIl = 20;
    @Resource(name="articleServiceImpl")
    private ArticleService IIIllllI;
    @Resource(name="articleCategoryServiceImpl")
    private ArticleCategoryService IIIlllll;
    @Resource(name="searchServiceImpl")
    private SearchService IIlIIIII;

    @RequestMapping(value={"/list/{id}"}, method={RequestMethod.GET})
    public String list(@PathVariable Long id, Integer pageNumber, ModelMap model) {
        ArticleCategory articleCategory = (ArticleCategory)this.IIIlllll.find((Serializable)id);
        if (articleCategory == null) {
            throw new ResourceNotFoundException();
        }
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(20));
        model.addAttribute("articleCategory", (Object)articleCategory);
        model.addAttribute("page", (Object)this.IIIllllI.findPage(articleCategory, null, pageable));
        return "/shop/article/list";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(String keyword, Integer pageNumber, ModelMap model) {
        if (StringUtils.isEmpty((String)keyword)) {
            return "/shop/common/error";
        }
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(20));
        model.addAttribute("articleKeyword", (Object)keyword);
        model.addAttribute("page", (Object)this.IIlIIIII.search(keyword, pageable));
        return "shop/article/search";
    }

    @RequestMapping(value={"/hits/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Long hits(@PathVariable Long id) {
        return this.IIIllllI.viewHits(id);
    }
}

