/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shopxx.Message;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Cart;
import net.shopxx.entity.CartItem;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.service.CartItemService;
import net.shopxx.service.CartService;
import net.shopxx.service.MemberService;
import net.shopxx.service.ProductService;
import net.shopxx.util.CookieUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="shopCartController")
@RequestMapping(value={"/cart"})
public class CartController
extends BaseController {
    @Resource(name="memberServiceImpl")
    private MemberService IIIlllIl;
    @Resource(name="productServiceImpl")
    private ProductService IIIllllI;
    @Resource(name="cartServiceImpl")
    private CartService IIIlllll;
    @Resource(name="cartItemServiceImpl")
    private CartItemService IIlIIIII;

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Message add(Long id, Integer quantity, HttpServletRequest request, HttpServletResponse response) {
        if (quantity == null || quantity < 1) {
            return IIIllIll;
        }
        Product product = (Product)this.IIIllllI.find((Serializable)id);
        if (product == null) {
            return Message.warn((String)"shop.cart.productNotExsit", (Object[])new Object[0]);
        }
        if (!product.getIsMarketable().booleanValue()) {
            return Message.warn((String)"shop.cart.productNotMarketable", (Object[])new Object[0]);
        }
        if (product.getIsGift().booleanValue()) {
            return Message.warn((String)"shop.cart.notForSale", (Object[])new Object[0]);
        }
        Cart cart = this.IIIlllll.getCurrent();
        Member member = this.IIIlllIl.getCurrent();
        if (cart == null) {
            cart = new Cart();
            cart.setKey(String.valueOf(UUID.randomUUID().toString()) + DigestUtils.md5Hex((String)RandomStringUtils.randomAlphabetic((int)30)));
            cart.setMember(member);
            this.IIIlllll.save((Object)cart);
        }
        if (Cart.MAX_PRODUCT_COUNT != null && cart.getCartItems().size() >= Cart.MAX_PRODUCT_COUNT) {
            return Message.warn((String)"shop.cart.addCountNotAllowed", (Object[])new Object[]{Cart.MAX_PRODUCT_COUNT});
        }
        if (cart.contains(product)) {
            CartItem cartItem = cart.getCartItem(product);
            if (CartItem.MAX_QUANTITY != null && cartItem.getQuantity() + quantity > CartItem.MAX_QUANTITY) {
                return Message.warn((String)"shop.cart.maxCartItemQuantity", (Object[])new Object[]{CartItem.MAX_QUANTITY});
            }
            if (product.getStock() != null && cartItem.getQuantity() + quantity > product.getAvailableStock()) {
                return Message.warn((String)"shop.cart.productLowStock", (Object[])new Object[0]);
            }
            cartItem.add(quantity.intValue());
            this.IIlIIIII.update((Object)cartItem);
        } else {
            if (CartItem.MAX_QUANTITY != null && quantity > CartItem.MAX_QUANTITY) {
                return Message.warn((String)"shop.cart.maxCartItemQuantity", (Object[])new Object[]{CartItem.MAX_QUANTITY});
            }
            if (product.getStock() != null && quantity > product.getAvailableStock()) {
                return Message.warn((String)"shop.cart.productLowStock", (Object[])new Object[0]);
            }
            CartItem cartItem = new CartItem();
            cartItem.setQuantity(quantity);
            cartItem.setProduct(product);
            cartItem.setCart(cart);
            this.IIlIIIII.save((Object)cartItem);
            cart.getCartItems().add(cartItem);
        }
        if (member == null) {
            CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cartId", (String)cart.getId().toString(), (Integer)604800);
            CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cartKey", (String)cart.getKey(), (Integer)604800);
        }
        return Message.success((String)"shop.cart.addSuccess", (Object[])new Object[]{cart.getQuantity(), this.IIIllIlI(cart.getAmount(), true, false)});
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(ModelMap model) {
        model.addAttribute("cart", (Object)this.IIIlllll.getCurrent());
        return "/shop/cart/list";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> edit(Long id, Integer quantity) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (quantity == null || quantity < 1) {
            hashMap.put("message", IIIllIll);
            return hashMap;
        }
        Cart cart = this.IIIlllll.getCurrent();
        if (cart == null || cart.isEmpty()) {
            hashMap.put("message", Message.error((String)"shop.cart.notEmpty", (Object[])new Object[0]));
            return hashMap;
        }
        CartItem cartItem = (CartItem)this.IIlIIIII.find((Serializable)id);
        Set set = cart.getCartItems();
        if (cartItem == null || set == null || !set.contains(cartItem)) {
            hashMap.put("message", Message.error((String)"shop.cart.cartItemNotExsit", (Object[])new Object[0]));
            return hashMap;
        }
        if (CartItem.MAX_QUANTITY != null && quantity > CartItem.MAX_QUANTITY) {
            hashMap.put("message", Message.warn((String)"shop.cart.maxCartItemQuantity", (Object[])new Object[]{CartItem.MAX_QUANTITY}));
            return hashMap;
        }
        Product product = cartItem.getProduct();
        if (product.getStock() != null && quantity > product.getAvailableStock()) {
            hashMap.put("message", Message.warn((String)"shop.cart.productLowStock", (Object[])new Object[0]));
            return hashMap;
        }
        cartItem.setQuantity(quantity);
        this.IIlIIIII.update((Object)cartItem);
        hashMap.put("message", IIIlllII);
        hashMap.put("subtotal", cartItem.getSubtotal());
        hashMap.put("isLowStock", cartItem.getIsLowStock());
        hashMap.put("quantity", cart.getQuantity());
        hashMap.put("point", cart.getPoint());
        hashMap.put("amount", cart.getAmount());
        hashMap.put("promotions", cart.getPromotions());
        hashMap.put("giftItems", cart.getGiftItems());
        return hashMap;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> delete(Long id) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Cart cart = this.IIIlllll.getCurrent();
        if (cart == null || cart.isEmpty()) {
            hashMap.put("message", Message.error((String)"shop.cart.notEmpty", (Object[])new Object[0]));
            return hashMap;
        }
        CartItem cartItem = (CartItem)this.IIlIIIII.find((Serializable)id);
        Set set = cart.getCartItems();
        if (cartItem == null || set == null || !set.contains(cartItem)) {
            hashMap.put("message", Message.error((String)"shop.cart.cartItemNotExsit", (Object[])new Object[0]));
            return hashMap;
        }
        set.remove(cartItem);
        this.IIlIIIII.delete((Object)cartItem);
        hashMap.put("message", IIIlllII);
        hashMap.put("quantity", cart.getQuantity());
        hashMap.put("point", cart.getPoint());
        hashMap.put("amount", cart.getAmount());
        hashMap.put("promotions", cart.getPromotions());
        hashMap.put("isLowStock", cart.getIsLowStock());
        return hashMap;
    }

    @RequestMapping(value={"/clear"}, method={RequestMethod.POST})
    @ResponseBody
    public Message clear() {
        Cart cart = this.IIIlllll.getCurrent();
        this.IIIlllll.delete((Object)cart);
        return IIIlllII;
    }
}

