/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shopxx.Setting;
import net.shopxx.entity.Area;
import net.shopxx.service.AreaService;
import net.shopxx.service.CaptchaService;
import net.shopxx.service.RSAService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="shopCommonController")
@RequestMapping(value={"/common"})
public class CommonController {
    @Resource(name="rsaServiceImpl")
    private RSAService IIIllIlI;
    @Resource(name="areaServiceImpl")
    private AreaService IIIllIll;
    @Resource(name="captchaServiceImpl")
    private CaptchaService IIIlllII;

    @RequestMapping(value={"/resource_not_found"})
    public String resourceNotFound() {
        return "/shop/common/resource_not_found";
    }

    @RequestMapping(value={"/error"})
    public String error() {
        return "/shop/common/error";
    }

    @RequestMapping(value={"/site_close"})
    public String siteClose() {
        Setting setting = SettingUtils.get();
        if (setting.getIsSiteEnabled().booleanValue()) {
            return "redirect:/";
        }
        return "/shop/common/site_close";
    }

    @RequestMapping(value={"/public_key"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> publicKey(HttpServletRequest request) {
        RSAPublicKey rSAPublicKey = this.IIIllIlI.generateKey(request);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("modulus", Base64.encodeBase64String((byte[])rSAPublicKey.getModulus().toByteArray()));
        hashMap.put("exponent", Base64.encodeBase64String((byte[])rSAPublicKey.getPublicExponent().toByteArray()));
        return hashMap;
    }

    @RequestMapping(value={"/area"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> area(Long parentId) {
        List list = new ArrayList();
        Area area = (Area)this.IIIllIll.find((Serializable)parentId);
        list = area != null ? new ArrayList(area.getChildren()) : this.IIIllIll.findRoots();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        for (Area area2 : list) {
            hashMap.put(area2.getId(), area2.getName());
        }
        return hashMap;
    }

    @RequestMapping(value={"/captcha"}, method={RequestMethod.GET})
    public void image(String captchaId, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isEmpty((String)captchaId)) {
            captchaId = request.getSession().getId();
        }
        String string = new StringBuffer().append("yB").append("-").append("der").append("ewoP").reverse().toString();
        String string2 = new StringBuffer().append("ten").append(".").append("xxp").append("ohs").reverse().toString();
        response.addHeader(string, string2);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        ServletOutputStream servletOutputStream = null;
        try {
            try {
                servletOutputStream = response.getOutputStream();
                BufferedImage bufferedImage = this.IIIlllII.buildImage(captchaId);
                ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)servletOutputStream);
                servletOutputStream.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                IOUtils.closeQuietly((OutputStream)servletOutputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)servletOutputStream);
        }
    }
}

