/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.ResourceNotFoundException;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Consultation;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.service.CaptchaService;
import net.shopxx.service.ConsultationService;
import net.shopxx.service.MemberService;
import net.shopxx.service.ProductService;
import net.shopxx.util.SettingUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shopConsultationController")
@RequestMapping(value={"/consultation"})
public class ConsultationController
extends BaseController {
    private static final int IIIlllIl = 10;
    @Resource(name="consultationServiceImpl")
    private ConsultationService IIIllllI;
    @Resource(name="productServiceImpl")
    private ProductService IIIlllll;
    @Resource(name="memberServiceImpl")
    private MemberService IIlIIIII;
    @Resource(name="captchaServiceImpl")
    private CaptchaService IIlIIIIl;

    @RequestMapping(value={"/add/{id}"}, method={RequestMethod.GET})
    public String add(@PathVariable Long id, ModelMap model) {
        Setting setting = SettingUtils.get();
        if (!setting.getIsConsultationEnabled().booleanValue()) {
            throw new ResourceNotFoundException();
        }
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("product", (Object)product);
        model.addAttribute("captchaId", (Object)UUID.randomUUID().toString());
        return "/shop/consultation/add";
    }

    @RequestMapping(value={"/content/{id}"}, method={RequestMethod.GET})
    public String content(@PathVariable Long id, Integer pageNumber, ModelMap model) {
        Setting setting = SettingUtils.get();
        if (!setting.getIsConsultationEnabled().booleanValue()) {
            throw new ResourceNotFoundException();
        }
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            throw new ResourceNotFoundException();
        }
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        model.addAttribute("product", (Object)product);
        model.addAttribute("page", (Object)this.IIIllllI.findPage(null, product, Boolean.valueOf(true), pageable));
        return "/shop/consultation/content";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Message save(String captchaId, String captcha, Long id, String content, HttpServletRequest request) {
        if (!this.IIlIIIIl.isValid(Setting.CaptchaType.consultation, captchaId, captcha)) {
            return Message.error((String)"shop.captcha.invalid", (Object[])new Object[0]);
        }
        Setting setting = SettingUtils.get();
        if (!setting.getIsConsultationEnabled().booleanValue()) {
            return Message.error((String)"shop.consultation.disabled", (Object[])new Object[0]);
        }
        if (!this.IIIllIlI(Consultation.class, "content", (Object)content, new Class[0])) {
            return IIIllIll;
        }
        Member member = this.IIlIIIII.getCurrent();
        if (setting.getConsultationAuthority() != Setting.ConsultationAuthority.anyone && member == null) {
            return Message.error((String)"shop.consultation.accessDenied", (Object[])new Object[0]);
        }
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            return IIIllIll;
        }
        Consultation consultation = new Consultation();
        consultation.setContent(content);
        consultation.setIp(request.getRemoteAddr());
        consultation.setMember(member);
        consultation.setProduct(product);
        if (setting.getIsConsultationCheck().booleanValue()) {
            consultation.setIsShow(Boolean.valueOf(false));
            this.IIIllllI.save((Object)consultation);
            return Message.success((String)"shop.consultation.check", (Object[])new Object[0]);
        }
        consultation.setIsShow(Boolean.valueOf(true));
        this.IIIllllI.save((Object)consultation);
        return Message.success((String)"shop.consultation.success", (Object[])new Object[0]);
    }
}

