/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shopxx.Message;
import net.shopxx.Principal;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Cart;
import net.shopxx.entity.Member;
import net.shopxx.service.CaptchaService;
import net.shopxx.service.CartService;
import net.shopxx.service.MemberService;
import net.shopxx.service.RSAService;
import net.shopxx.util.CookieUtils;
import net.shopxx.util.SettingUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shopLoginController")
@RequestMapping(value={"/login"})
public class LoginController
extends BaseController {
    @Resource(name="captchaServiceImpl")
    private CaptchaService IIIlllIl;
    @Resource(name="rsaServiceImpl")
    private RSAService IIIllllI;
    @Resource(name="memberServiceImpl")
    private MemberService IIIlllll;
    @Resource(name="cartServiceImpl")
    private CartService IIlIIIII;

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean check() {
        return this.IIIlllll.isAuthenticated();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String index(String redirectUrl, HttpServletRequest request, ModelMap model) {
        Setting setting = SettingUtils.get();
        if (!(redirectUrl == null || redirectUrl.equalsIgnoreCase(setting.getSiteUrl()) || redirectUrl.startsWith(String.valueOf(request.getContextPath()) + "/") || redirectUrl.startsWith(String.valueOf(setting.getSiteUrl()) + "/"))) {
            redirectUrl = null;
        }
        model.addAttribute("redirectUrl", (Object)redirectUrl);
        model.addAttribute("captchaId", (Object)UUID.randomUUID().toString());
        return "/shop/login/index";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    @ResponseBody
    public Message submit(String captchaId, String captcha, String username, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Object object;
        Cloneable cloneable;
        Member member;
        List list;
        String string = this.IIIllllI.decryptParameter("enPassword", request);
        this.IIIllllI.removePrivateKey(request);
        if (!this.IIIlllIl.isValid(Setting.CaptchaType.memberLogin, captchaId, captcha)) {
            return Message.error((String)"shop.captcha.invalid", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)string)) {
            return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
        }
        Setting setting = SettingUtils.get();
        if (setting.getIsEmailLogin().booleanValue() && username.contains("@")) {
            list = this.IIIlllll.findListByEmail(username);
            if (list.isEmpty()) {
                member = null;
            } else {
                if (list.size() != 1) return Message.error((String)"shop.login.unsupportedAccount", (Object[])new Object[0]);
                member = (Member)list.get(0);
            }
        } else {
            member = this.IIIlllll.findByUsername(username);
        }
        if (member == null) {
            return Message.error((String)"shop.login.unknownAccount", (Object[])new Object[0]);
        }
        if (!member.getIsEnabled().booleanValue()) {
            return Message.error((String)"shop.login.disabledAccount", (Object[])new Object[0]);
        }
        if (member.getIsLocked().booleanValue()) {
            if (ArrayUtils.contains((Object[])setting.getAccountLockTypes(), (Object)Setting.AccountLockType.member)) {
                int n = setting.getAccountLockTime();
                if (n == 0) {
                    return Message.error((String)"shop.login.lockedAccount", (Object[])new Object[0]);
                }
                cloneable = member.getLockedDate();
                object = DateUtils.addMinutes((Date)cloneable, (int)n);
                if (!new Date().after((Date)object)) return Message.error((String)"shop.login.lockedAccount", (Object[])new Object[0]);
                member.setLoginFailureCount(Integer.valueOf(0));
                member.setIsLocked(Boolean.valueOf(false));
                member.setLockedDate(null);
                this.IIIlllll.update((Object)member);
            } else {
                member.setLoginFailureCount(Integer.valueOf(0));
                member.setIsLocked(Boolean.valueOf(false));
                member.setLockedDate(null);
                this.IIIlllll.update((Object)member);
            }
        }
        if (!DigestUtils.md5Hex((String)string).equals(member.getPassword())) {
            int n = member.getLoginFailureCount() + 1;
            if (n >= setting.getAccountLockCount()) {
                member.setIsLocked(Boolean.valueOf(true));
                member.setLockedDate(new Date());
            }
            member.setLoginFailureCount(Integer.valueOf(n));
            this.IIIlllll.update((Object)member);
            if (!ArrayUtils.contains((Object[])setting.getAccountLockTypes(), (Object)Setting.AccountLockType.member)) return Message.error((String)"shop.login.incorrectCredentials", (Object[])new Object[0]);
            return Message.error((String)"shop.login.accountLockCount", (Object[])new Object[]{setting.getAccountLockCount()});
        }
        member.setLoginIp(request.getRemoteAddr());
        member.setLoginDate(new Date());
        member.setLoginFailureCount(Integer.valueOf(0));
        this.IIIlllll.update((Object)member);
        list = this.IIlIIIII.getCurrent();
        if (list != null && list.getMember() == null) {
            this.IIlIIIII.merge(member, (Cart)list);
            CookieUtils.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cartId");
            CookieUtils.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cartKey");
        }
        cloneable = new HashMap();
        object = session.getAttributeNames();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            cloneable.put(string2, session.getAttribute(string2));
        }
        session.invalidate();
        session = request.getSession();
        for (Map.Entry entry : cloneable.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
        session.setAttribute(Member.PRINCIPAL_ATTRIBUTE_NAME, (Object)new Principal(member.getId(), username));
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"username", (String)member.getUsername());
        return IIIlllII;
    }
}

