/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Member;
import net.shopxx.entity.SafeKey;
import net.shopxx.service.CaptchaService;
import net.shopxx.service.MailService;
import net.shopxx.service.MemberService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shopPasswordController")
@RequestMapping(value={"/password"})
public class PasswordController
extends BaseController {
    @Resource(name="captchaServiceImpl")
    private CaptchaService IIIlllIl;
    @Resource(name="memberServiceImpl")
    private MemberService IIIllllI;
    @Resource(name="mailServiceImpl")
    private MailService IIIlllll;

    @RequestMapping(value={"/find"}, method={RequestMethod.GET})
    public String find(Model model) {
        model.addAttribute("captchaId", (Object)UUID.randomUUID().toString());
        return "/shop/password/find";
    }

    @RequestMapping(value={"/find"}, method={RequestMethod.POST})
    @ResponseBody
    public Message find(String captchaId, String captcha, String username, String email) {
        if (!this.IIIlllIl.isValid(Setting.CaptchaType.findPassword, captchaId, captcha)) {
            return Message.error((String)"shop.captcha.invalid", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)email)) {
            return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
        }
        Member member = this.IIIllllI.findByUsername(username);
        if (member == null) {
            return Message.error((String)"shop.password.memberNotExist", (Object[])new Object[0]);
        }
        if (!member.getEmail().equalsIgnoreCase(email)) {
            return Message.error((String)"shop.password.invalidEmail", (Object[])new Object[0]);
        }
        Setting setting = SettingUtils.get();
        SafeKey safeKey = new SafeKey();
        safeKey.setValue(String.valueOf(UUID.randomUUID().toString()) + DigestUtils.md5Hex((String)RandomStringUtils.randomAlphabetic((int)30)));
        safeKey.setExpire(setting.getSafeKeyExpiryTime() != 0 ? DateUtils.addMinutes((Date)new Date(), (int)setting.getSafeKeyExpiryTime()) : null);
        member.setSafeKey(safeKey);
        this.IIIllllI.update((Object)member);
        this.IIIlllll.sendFindPasswordMail(member.getEmail(), member.getUsername(), safeKey);
        return Message.success((String)"shop.password.mailSuccess", (Object[])new Object[0]);
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.GET})
    public String reset(String username, String key, Model model) {
        Member member = this.IIIllllI.findByUsername(username);
        if (member == null) {
            return "/shop/common/error";
        }
        SafeKey safeKey = member.getSafeKey();
        if (safeKey == null || safeKey.getValue() == null || !safeKey.getValue().equals(key)) {
            return "/shop/common/error";
        }
        if (safeKey.hasExpired()) {
            model.addAttribute("erroInfo", (Object)Message.warn((String)"shop.password.hasExpired", (Object[])new Object[0]));
            return "/shop/common/error";
        }
        model.addAttribute("captchaId", (Object)UUID.randomUUID().toString());
        model.addAttribute("member", (Object)member);
        model.addAttribute("key", (Object)key);
        return "/shop/password/reset";
    }

    @RequestMapping(value={"reset"}, method={RequestMethod.POST})
    @ResponseBody
    public Message reset(String captchaId, String captcha, String username, String newPassword, String key) {
        if (!this.IIIlllIl.isValid(Setting.CaptchaType.resetPassword, captchaId, captcha)) {
            return Message.error((String)"shop.captcha.invalid", (Object[])new Object[0]);
        }
        Member member = this.IIIllllI.findByUsername(username);
        if (member == null) {
            return IIIllIll;
        }
        if (!this.IIIllIlI(Member.class, "password", (Object)newPassword, new Class[]{BaseEntity.Save.class})) {
            return Message.warn((String)"shop.password.invalidPassword", (Object[])new Object[0]);
        }
        Setting setting = SettingUtils.get();
        if (newPassword.length() < setting.getPasswordMinLength() || newPassword.length() > setting.getPasswordMaxLength()) {
            return Message.warn((String)"shop.password.invalidPassword", (Object[])new Object[0]);
        }
        SafeKey safeKey = member.getSafeKey();
        if (safeKey == null || safeKey.getValue() == null || !safeKey.getValue().equals(key)) {
            return IIIllIll;
        }
        if (safeKey.hasExpired()) {
            return Message.error((String)"shop.password.hasExpired", (Object[])new Object[0]);
        }
        member.setPassword(DigestUtils.md5Hex((String)newPassword));
        safeKey.setExpire(new Date());
        safeKey.setValue(null);
        this.IIIllllI.update((Object)member);
        return Message.success((String)"shop.password.resetSuccess", (Object[])new Object[0]);
    }
}

