/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order;
import net.shopxx.entity.Payment;
import net.shopxx.entity.PaymentMethod;
import net.shopxx.entity.Sn;
import net.shopxx.plugin.PaymentPlugin;
import net.shopxx.service.MemberService;
import net.shopxx.service.OrderService;
import net.shopxx.service.PaymentService;
import net.shopxx.service.PluginService;
import net.shopxx.service.SnService;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller(value="shopPaymentController")
@RequestMapping(value={"/payment"})
public class PaymentController
extends BaseController {
    @Resource(name="orderServiceImpl")
    private OrderService IIIlllIl;
    @Resource(name="memberServiceImpl")
    private MemberService IIIllllI;
    @Resource(name="pluginServiceImpl")
    private PluginService IIIlllll;
    @Resource(name="paymentServiceImpl")
    private PaymentService IIlIIIII;
    @Resource(name="snServiceImpl")
    private SnService IIlIIIIl;

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    public String submit(String sn, String paymentPluginId, HttpServletRequest request, ModelMap model) {
        Order order = this.IIIlllIl.findBySn(sn);
        if (order == null) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        if (member == null || order.getMember() != member || order.isExpired()) {
            return "/shop/common/error";
        }
        if (order.getPaymentMethod() == null || order.getPaymentMethod().getType() == PaymentMethod.Type.offline) {
            return "/shop/common/error";
        }
        if (order.getPaymentStatus() != Order.PaymentStatus.unpaid && order.getPaymentStatus() != Order.PaymentStatus.partialPayment) {
            return "/shop/common/error";
        }
        if (order.getAmountPayable().compareTo(new BigDecimal(0)) <= 0) {
            return "/shop/common/error";
        }
        PaymentPlugin paymentPlugin = this.IIIlllll.getPaymentPlugin(paymentPluginId);
        if (paymentPlugin == null || !paymentPlugin.getIsEnabled()) {
            return "/shop/common/error";
        }
        BigDecimal bigDecimal = paymentPlugin.getFee(order.getAmountPayable());
        BigDecimal bigDecimal2 = order.getAmountPayable().add(bigDecimal);
        Payment payment = new Payment();
        payment.setSn(this.IIlIIIIl.generate(Sn.Type.payment));
        payment.setType(Payment.Type.online);
        payment.setStatus(Payment.Status.wait);
        payment.setPaymentMethod(String.valueOf(order.getPaymentMethodName()) + "-" + paymentPlugin.getPaymentName());
        payment.setFee(bigDecimal);
        payment.setAmount(bigDecimal2);
        payment.setPaymentPluginId(paymentPluginId);
        payment.setExpire(paymentPlugin.getTimeout() != null ? DateUtils.addMinutes((Date)new Date(), (int)paymentPlugin.getTimeout()) : null);
        payment.setMember(null);
        payment.setOrder(order);
        this.IIlIIIII.save((Object)payment);
        model.addAttribute("url", (Object)paymentPlugin.getUrl());
        model.addAttribute("method", (Object)paymentPlugin.getMethod());
        model.addAttribute("parameterMap", (Object)paymentPlugin.getParameterMap(payment.getSn(), bigDecimal2, order.getProductName(), request));
        return "shop/payment/submit";
    }

    @RequestMapping(value={"/return/{sn}"})
    public String returns(@PathVariable String sn, HttpServletRequest request, ModelMap model) {
        Payment payment = this.IIlIIIII.findBySn(sn);
        if (payment == null) {
            return "/shop/common/error";
        }
        if (payment.getStatus() == Payment.Status.wait) {
            PaymentPlugin paymentPlugin = this.IIIlllll.getPaymentPlugin(payment.getPaymentPluginId());
            if (paymentPlugin != null && paymentPlugin.verify(sn, request)) {
                BigDecimal bigDecimal = paymentPlugin.getAmount(sn, request);
                if (bigDecimal.compareTo(payment.getAmount()) >= 0) {
                    Order order = payment.getOrder();
                    if (order != null) {
                        if (bigDecimal.compareTo(order.getAmountPayable()) >= 0) {
                            this.IIIlllIl.payment(order, payment, null);
                        }
                    } else {
                        Member member = payment.getMember();
                        if (member != null) {
                            BigDecimal bigDecimal2 = payment.getAmount().subtract(payment.getFee());
                            this.IIIllllI.update(member, null, bigDecimal2, this.IIIllIlI("shop.payment.paymentName", new Object[]{paymentPlugin.getPaymentName()}), null);
                        }
                    }
                }
                payment.setStatus(Payment.Status.success);
                payment.setAmount(bigDecimal);
                payment.setPaymentDate(new Date());
            } else {
                payment.setStatus(Payment.Status.failure);
                payment.setPaymentDate(new Date());
            }
            this.IIlIIIII.update((Object)payment);
        }
        model.addAttribute("payment", (Object)payment);
        return "shop/payment/return";
    }

    @RequestMapping(value={"/notify/{sn}"})
    public String notify(@PathVariable String sn, HttpServletRequest request, ModelMap model) {
        PaymentPlugin paymentPlugin;
        Payment payment = this.IIlIIIII.findBySn(sn);
        if (payment != null && (paymentPlugin = this.IIIlllll.getPaymentPlugin(payment.getPaymentPluginId())) != null) {
            if (payment.getStatus() == Payment.Status.wait && paymentPlugin.verify(sn, request)) {
                BigDecimal bigDecimal = paymentPlugin.getAmount(sn, request);
                if (bigDecimal.compareTo(payment.getAmount()) >= 0) {
                    Order order = payment.getOrder();
                    if (order != null) {
                        if (bigDecimal.compareTo(order.getAmountPayable()) >= 0) {
                            this.IIIlllIl.payment(order, payment, null);
                        }
                    } else {
                        Member member = payment.getMember();
                        if (member != null) {
                            BigDecimal bigDecimal2 = payment.getAmount().subtract(payment.getFee());
                            this.IIIllllI.update(member, null, bigDecimal2, this.IIIllIlI("shop.payment.paymentName", new Object[]{paymentPlugin.getPaymentName()}), null);
                        }
                    }
                }
                payment.setStatus(Payment.Status.success);
                payment.setAmount(bigDecimal);
                payment.setPaymentDate(new Date());
                this.IIlIIIII.update((Object)payment);
            }
            model.addAttribute("notifyContext", (Object)paymentPlugin.getNotifyContext(sn, request));
        }
        return "shop/payment/notify";
    }
}

