/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Pageable;
import net.shopxx.ResourceNotFoundException;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Attribute;
import net.shopxx.entity.Brand;
import net.shopxx.entity.Product;
import net.shopxx.entity.ProductCategory;
import net.shopxx.entity.Promotion;
import net.shopxx.service.BrandService;
import net.shopxx.service.ProductCategoryService;
import net.shopxx.service.ProductService;
import net.shopxx.service.PromotionService;
import net.shopxx.service.SearchService;
import net.shopxx.service.TagService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="shopProductController")
@RequestMapping(value={"/product"})
public class ProductController
extends BaseController {
    @Resource(name="productServiceImpl")
    private ProductService IIIlllIl;
    @Resource(name="productCategoryServiceImpl")
    private ProductCategoryService IIIllllI;
    @Resource(name="brandServiceImpl")
    private BrandService IIIlllll;
    @Resource(name="promotionServiceImpl")
    private PromotionService IIlIIIII;
    @Resource(name="tagServiceImpl")
    private TagService IIlIIIIl;
    @Resource(name="searchServiceImpl")
    private SearchService IIlIIIlI;

    @RequestMapping(value={"/history"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Product> history(Long[] ids) {
        return this.IIIlllIl.findList((Serializable[])ids);
    }

    @RequestMapping(value={"/list/{productCategoryId}"}, method={RequestMethod.GET})
    public String list(@PathVariable Long productCategoryId, Long brandId, Long promotionId, Long[] tagIds, BigDecimal startPrice, BigDecimal endPrice, Product.OrderType orderType, Integer pageNumber, Integer pageSize, HttpServletRequest request, ModelMap model) {
        Set set;
        ProductCategory productCategory = (ProductCategory)this.IIIllllI.find((Serializable)productCategoryId);
        if (productCategory == null) {
            throw new ResourceNotFoundException();
        }
        Brand brand = (Brand)this.IIIlllll.find((Serializable)brandId);
        Promotion promotion = (Promotion)this.IIlIIIII.find((Serializable)promotionId);
        List list = this.IIlIIIIl.findList((Serializable[])tagIds);
        HashMap<Attribute, String> hashMap = new HashMap<Attribute, String>();
        if (productCategory != null) {
            set = productCategory.getAttributes();
            for (Attribute attribute : set) {
                String string = request.getParameter("attribute_" + attribute.getId());
                if (!StringUtils.isNotEmpty((String)string)) continue;
                hashMap.put(attribute, string);
            }
        }
        set = new Pageable(pageNumber, pageSize);
        model.addAttribute("orderTypes", (Object)Product.OrderType.values());
        model.addAttribute("productCategory", (Object)productCategory);
        model.addAttribute("brand", (Object)brand);
        model.addAttribute("promotion", (Object)promotion);
        model.addAttribute("tags", (Object)list);
        model.addAttribute("attributeValue", hashMap);
        model.addAttribute("startPrice", (Object)startPrice);
        model.addAttribute("endPrice", (Object)endPrice);
        model.addAttribute("orderType", (Object)orderType);
        model.addAttribute("pageNumber", (Object)pageNumber);
        model.addAttribute("pageSize", (Object)pageSize);
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(productCategory, brand, promotion, list, hashMap, startPrice, endPrice, Boolean.valueOf(true), Boolean.valueOf(true), null, Boolean.valueOf(false), null, null, orderType, (Pageable)set));
        return "/shop/product/list";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Long brandId, Long promotionId, Long[] tagIds, BigDecimal startPrice, BigDecimal endPrice, Product.OrderType orderType, Integer pageNumber, Integer pageSize, HttpServletRequest request, ModelMap model) {
        Brand brand = (Brand)this.IIIlllll.find((Serializable)brandId);
        Promotion promotion = (Promotion)this.IIlIIIII.find((Serializable)promotionId);
        List list = this.IIlIIIIl.findList((Serializable[])tagIds);
        Pageable pageable = new Pageable(pageNumber, pageSize);
        model.addAttribute("orderTypes", (Object)Product.OrderType.values());
        model.addAttribute("brand", (Object)brand);
        model.addAttribute("promotion", (Object)promotion);
        model.addAttribute("tags", (Object)list);
        model.addAttribute("startPrice", (Object)startPrice);
        model.addAttribute("endPrice", (Object)endPrice);
        model.addAttribute("orderType", (Object)orderType);
        model.addAttribute("pageNumber", (Object)pageNumber);
        model.addAttribute("pageSize", (Object)pageSize);
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(null, brand, promotion, list, null, startPrice, endPrice, Boolean.valueOf(true), Boolean.valueOf(true), null, Boolean.valueOf(false), null, null, orderType, pageable));
        return "/shop/product/list";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(String keyword, BigDecimal startPrice, BigDecimal endPrice, Product.OrderType orderType, Integer pageNumber, Integer pageSize, ModelMap model) {
        if (StringUtils.isEmpty((String)keyword)) {
            return "/shop/common/error";
        }
        Pageable pageable = new Pageable(pageNumber, pageSize);
        model.addAttribute("orderTypes", (Object)Product.OrderType.values());
        model.addAttribute("productKeyword", (Object)keyword);
        model.addAttribute("startPrice", (Object)startPrice);
        model.addAttribute("endPrice", (Object)endPrice);
        model.addAttribute("orderType", (Object)orderType);
        model.addAttribute("page", (Object)this.IIlIIIlI.search(keyword, startPrice, endPrice, orderType, pageable));
        return "shop/product/search";
    }

    @RequestMapping(value={"/hits/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Long hits(@PathVariable Long id) {
        return this.IIIlllIl.viewHits(id);
    }
}

