/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.entity.ProductNotify;
import net.shopxx.service.MemberService;
import net.shopxx.service.ProductNotifyService;
import net.shopxx.service.ProductService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="shopProductNotifyController")
@RequestMapping(value={"/product_notify"})
public class ProductNotifyController
extends BaseController {
    @Resource(name="productNotifyServiceImpl")
    private ProductNotifyService IIIlllIl;
    @Resource(name="memberServiceImpl")
    private MemberService IIIllllI;
    @Resource(name="productServiceImpl")
    private ProductService IIIlllll;

    @RequestMapping(value={"/email"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> email() {
        Member member = this.IIIllllI.getCurrent();
        String string = member != null ? member.getEmail() : null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("email", string);
        return hashMap;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> save(String email, Long productId) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!this.IIIllIlI(ProductNotify.class, "email", (Object)email, new Class[0])) {
            hashMap.put("message", IIIllIll);
            return hashMap;
        }
        Product product = (Product)this.IIIlllll.find((Serializable)productId);
        if (product == null) {
            hashMap.put("message", Message.warn((String)"shop.productNotify.productNotExist", (Object[])new Object[0]));
            return hashMap;
        }
        if (!product.getIsMarketable().booleanValue()) {
            hashMap.put("message", Message.warn((String)"shop.productNotify.productNotMarketable", (Object[])new Object[0]));
            return hashMap;
        }
        if (!product.getIsOutOfStock().booleanValue()) {
            hashMap.put("message", Message.warn((String)"shop.productNotify.productInStock", (Object[])new Object[0]));
        }
        if (this.IIIlllIl.exists(product, email)) {
            hashMap.put("message", Message.warn((String)"shop.productNotify.exist", (Object[])new Object[0]));
        } else {
            ProductNotify productNotify = new ProductNotify();
            productNotify.setEmail(email);
            productNotify.setHasSent(Boolean.valueOf(false));
            productNotify.setMember(this.IIIllllI.getCurrent());
            productNotify.setProduct(product);
            this.IIIlllIl.save((Object)productNotify);
            hashMap.put("message", IIIlllII);
        }
        return hashMap;
    }
}

