/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shopxx.CommonAttributes;
import net.shopxx.Message;
import net.shopxx.Principal;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Area;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Cart;
import net.shopxx.entity.Member;
import net.shopxx.entity.MemberAttribute;
import net.shopxx.service.AreaService;
import net.shopxx.service.CaptchaService;
import net.shopxx.service.CartService;
import net.shopxx.service.MemberAttributeService;
import net.shopxx.service.MemberRankService;
import net.shopxx.service.MemberService;
import net.shopxx.service.RSAService;
import net.shopxx.util.CookieUtils;
import net.shopxx.util.SettingUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shopRegisterController")
@RequestMapping(value={"/register"})
public class RegisterController
extends BaseController {
    @Resource(name="captchaServiceImpl")
    private CaptchaService IIIlllIl;
    @Resource(name="rsaServiceImpl")
    private RSAService IIIllllI;
    @Resource(name="memberServiceImpl")
    private MemberService IIIlllll;
    @Resource(name="memberRankServiceImpl")
    private MemberRankService IIlIIIII;
    @Resource(name="memberAttributeServiceImpl")
    private MemberAttributeService IIlIIIIl;
    @Resource(name="areaServiceImpl")
    private AreaService IIlIIIlI;
    @Resource(name="cartServiceImpl")
    private CartService IIlIIIll;

    @RequestMapping(value={"/check_username"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkUsername(String username) {
        if (StringUtils.isEmpty((String)username)) {
            return false;
        }
        return !this.IIIlllll.usernameDisabled(username) && !this.IIIlllll.usernameExists(username);
    }

    @RequestMapping(value={"/check_email"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkEmail(String email) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        return !this.IIIlllll.emailExists(email);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        model.addAttribute("genders", (Object)Member.Gender.values());
        model.addAttribute("captchaId", (Object)UUID.randomUUID().toString());
        return "/shop/register/index";
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    @ResponseBody
    public Message submit(String captchaId, String captcha, String username, String email, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Object object2;
        MemberAttribute memberAttribute22;
        String string = this.IIIllllI.decryptParameter("enPassword", request);
        this.IIIllllI.removePrivateKey(request);
        if (!this.IIIlllIl.isValid(Setting.CaptchaType.memberRegister, captchaId, captcha)) {
            return Message.error((String)"shop.captcha.invalid", (Object[])new Object[0]);
        }
        Setting setting = SettingUtils.get();
        if (!setting.getIsRegisterEnabled().booleanValue()) {
            return Message.error((String)"shop.register.disabled", (Object[])new Object[0]);
        }
        if (!(this.IIIllIlI(Member.class, "username", (Object)username, new Class[]{BaseEntity.Save.class}) && this.IIIllIlI(Member.class, "password", (Object)string, new Class[]{BaseEntity.Save.class}) && this.IIIllIlI(Member.class, "email", (Object)email, new Class[]{BaseEntity.Save.class}))) {
            return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
        }
        if (username.length() < setting.getUsernameMinLength() || username.length() > setting.getUsernameMaxLength()) {
            return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
        }
        if (string.length() < setting.getPasswordMinLength() || string.length() > setting.getPasswordMaxLength()) {
            return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
        }
        if (this.IIIlllll.usernameDisabled(username) || this.IIIlllll.usernameExists(username)) {
            return Message.error((String)"shop.register.disabledExist", (Object[])new Object[0]);
        }
        if (!setting.getIsDuplicateEmail().booleanValue() && this.IIIlllll.emailExists(email)) {
            return Message.error((String)"shop.register.emailExist", (Object[])new Object[0]);
        }
        Member member = new Member();
        List list = this.IIlIIIIl.findList();
        for (MemberAttribute memberAttribute22 : list) {
            Object object;
            object2 = request.getParameter("memberAttribute_" + memberAttribute22.getId());
            if (memberAttribute22.getType() == MemberAttribute.Type.name || memberAttribute22.getType() == MemberAttribute.Type.address || memberAttribute22.getType() == MemberAttribute.Type.zipCode || memberAttribute22.getType() == MemberAttribute.Type.phone || memberAttribute22.getType() == MemberAttribute.Type.mobile || memberAttribute22.getType() == MemberAttribute.Type.text || memberAttribute22.getType() == MemberAttribute.Type.select) {
                if (memberAttribute22.getIsRequired().booleanValue() && StringUtils.isEmpty((String)object2)) {
                    return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
                }
                member.setAttributeValue(memberAttribute22, object2);
                continue;
            }
            if (memberAttribute22.getType() == MemberAttribute.Type.gender) {
                Member.Gender parseException;
                Member.Gender gender = parseException = StringUtils.isNotEmpty((String)object2) ? Member.Gender.valueOf((String)object2) : null;
                if (memberAttribute22.getIsRequired().booleanValue() && parseException == null) {
                    return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
                }
                member.setGender(parseException);
                continue;
            }
            if (memberAttribute22.getType() == MemberAttribute.Type.birth) {
                try {
                    Date date;
                    Date date2 = date = StringUtils.isNotEmpty((String)object2) ? DateUtils.parseDate((String)object2, (String[])CommonAttributes.DATE_PATTERNS) : null;
                    if (memberAttribute22.getIsRequired().booleanValue() && date == null) {
                        return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
                    }
                    member.setBirth(date);
                    continue;
                }
                catch (ParseException parseException) {
                    return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
                }
            }
            if (memberAttribute22.getType() == MemberAttribute.Type.area) {
                Area area;
                Area area2 = area = StringUtils.isNotEmpty((String)object2) ? (Area)this.IIlIIIlI.find((Serializable)Long.valueOf((String)object2)) : null;
                if (area != null) {
                    member.setArea(area);
                    continue;
                }
                if (!memberAttribute22.getIsRequired().booleanValue()) continue;
                return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
            }
            if (memberAttribute22.getType() != MemberAttribute.Type.checkbox) continue;
            String[] stringArray = request.getParameterValues("memberAttribute_" + memberAttribute22.getId());
            Object object3 = object = stringArray != null ? Arrays.asList(stringArray) : null;
            if (memberAttribute22.getIsRequired().booleanValue() && (object == null || object.isEmpty())) {
                return Message.error((String)"shop.common.invalid", (Object[])new Object[0]);
            }
            member.setAttributeValue(memberAttribute22, object);
        }
        member.setUsername(username.toLowerCase());
        member.setPassword(DigestUtils.md5Hex((String)string));
        member.setEmail(email);
        member.setPoint(setting.getRegisterPoint());
        member.setAmount(new BigDecimal(0));
        member.setBalance(new BigDecimal(0));
        member.setIsEnabled(Boolean.valueOf(true));
        member.setIsLocked(Boolean.valueOf(false));
        member.setLoginFailureCount(Integer.valueOf(0));
        member.setLockedDate(null);
        member.setRegisterIp(request.getRemoteAddr());
        member.setLoginIp(request.getRemoteAddr());
        member.setLoginDate(new Date());
        member.setSafeKey(null);
        member.setMemberRank(this.IIlIIIII.findDefault());
        member.setFavoriteProducts(null);
        this.IIIlllll.save((Object)member);
        memberAttribute22 = this.IIlIIIll.getCurrent();
        if (memberAttribute22 != null && memberAttribute22.getMember() == null) {
            this.IIlIIIll.merge(member, (Cart)memberAttribute22);
            CookieUtils.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cartId");
            CookieUtils.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cartKey");
        }
        HashMap hashMap = new HashMap();
        object2 = session.getAttributeNames();
        while (object2.hasMoreElements()) {
            String string2 = (String)object2.nextElement();
            hashMap.put(string2, session.getAttribute(string2));
        }
        session.invalidate();
        session = request.getSession();
        for (Map.Entry entry : hashMap.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
        session.setAttribute(Member.PRINCIPAL_ATTRIBUTE_NAME, (Object)new Principal(member.getId(), member.getUsername()));
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"username", (String)member.getUsername());
        return Message.success((String)"shop.register.success", (Object[])new Object[0]);
    }
}

