/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.ResourceNotFoundException;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.entity.Review;
import net.shopxx.service.CaptchaService;
import net.shopxx.service.MemberService;
import net.shopxx.service.ProductService;
import net.shopxx.service.ReviewService;
import net.shopxx.util.SettingUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shopReviewController")
@RequestMapping(value={"/review"})
public class ReviewController
extends BaseController {
    private static final int IIIlllIl = 10;
    @Resource(name="reviewServiceImpl")
    private ReviewService IIIllllI;
    @Resource(name="productServiceImpl")
    private ProductService IIIlllll;
    @Resource(name="memberServiceImpl")
    private MemberService IIlIIIII;
    @Resource(name="captchaServiceImpl")
    private CaptchaService IIlIIIIl;

    @RequestMapping(value={"/add/{id}"}, method={RequestMethod.GET})
    public String add(@PathVariable Long id, ModelMap model) {
        Setting setting = SettingUtils.get();
        if (!setting.getIsReviewEnabled().booleanValue()) {
            throw new ResourceNotFoundException();
        }
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("product", (Object)product);
        model.addAttribute("captchaId", (Object)UUID.randomUUID().toString());
        return "/shop/review/add";
    }

    @RequestMapping(value={"/content/{id}"}, method={RequestMethod.GET})
    public String content(@PathVariable Long id, Integer pageNumber, ModelMap model) {
        Setting setting = SettingUtils.get();
        if (!setting.getIsReviewEnabled().booleanValue()) {
            throw new ResourceNotFoundException();
        }
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            throw new ResourceNotFoundException();
        }
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        model.addAttribute("product", (Object)product);
        model.addAttribute("page", (Object)this.IIIllllI.findPage(null, product, null, Boolean.valueOf(true), pageable));
        return "/shop/review/content";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Message save(String captchaId, String captcha, Long id, Integer score, String content, HttpServletRequest request) {
        if (!this.IIlIIIIl.isValid(Setting.CaptchaType.review, captchaId, captcha)) {
            return Message.error((String)"shop.captcha.invalid", (Object[])new Object[0]);
        }
        Setting setting = SettingUtils.get();
        if (!setting.getIsReviewEnabled().booleanValue()) {
            return Message.error((String)"shop.review.disabled", (Object[])new Object[0]);
        }
        if (!this.IIIllIlI(Review.class, "score", (Object)score, new Class[0]) || !this.IIIllIlI(Review.class, "content", (Object)content, new Class[0])) {
            return IIIllIll;
        }
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            return IIIllIll;
        }
        Member member = this.IIlIIIII.getCurrent();
        if (setting.getReviewAuthority() != Setting.ReviewAuthority.anyone && member == null) {
            return Message.error((String)"shop.review.accessDenied", (Object[])new Object[0]);
        }
        if (setting.getReviewAuthority() == Setting.ReviewAuthority.purchased) {
            if (!this.IIIlllll.isPurchased(member, product)) {
                return Message.error((String)"shop.review.noPurchased", (Object[])new Object[0]);
            }
            if (this.IIIllllI.isReviewed(member, product)) {
                return Message.error((String)"shop.review.reviewed", (Object[])new Object[0]);
            }
        }
        Review review = new Review();
        review.setScore(score);
        review.setContent(content);
        review.setIp(request.getRemoteAddr());
        review.setMember(member);
        review.setProduct(product);
        if (setting.getIsReviewCheck().booleanValue()) {
            review.setIsShow(Boolean.valueOf(false));
            this.IIIllllI.save((Object)review);
            return Message.success((String)"shop.review.check", (Object[])new Object[0]);
        }
        review.setIsShow(Boolean.valueOf(true));
        this.IIIllllI.save((Object)review);
        return Message.success((String)"shop.review.success", (Object[])new Object[0]);
    }
}

