/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop.member;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Pageable;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Member;
import net.shopxx.entity.Payment;
import net.shopxx.entity.Sn;
import net.shopxx.plugin.PaymentPlugin;
import net.shopxx.service.DepositService;
import net.shopxx.service.MemberService;
import net.shopxx.service.PaymentService;
import net.shopxx.service.PluginService;
import net.shopxx.service.SnService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller(value="shopMemberDepositController")
@RequestMapping(value={"/member/deposit"})
public class DepositController
extends BaseController {
    private static final int IIIlllIl = 10;
    @Resource(name="memberServiceImpl")
    private MemberService IIIllllI;
    @Resource(name="depositServiceImpl")
    private DepositService IIIlllll;
    @Resource(name="pluginServiceImpl")
    private PluginService IIlIIIII;
    @Resource(name="paymentServiceImpl")
    private PaymentService IIlIIIIl;
    @Resource(name="snServiceImpl")
    private SnService IIlIIIlI;

    @RequestMapping(value={"/recharge"}, method={RequestMethod.GET})
    public String recharge(ModelMap model) {
        List list = this.IIlIIIII.getPaymentPlugins(true);
        if (!list.isEmpty()) {
            model.addAttribute("defaultPaymentPlugin", list.get(0));
            model.addAttribute("paymentPlugins", (Object)list);
        }
        return "shop/member/deposit/recharge";
    }

    @RequestMapping(value={"/recharge"}, method={RequestMethod.POST})
    public String recharge(BigDecimal amount, String paymentPluginId, HttpServletRequest request, ModelMap model) {
        PaymentPlugin paymentPlugin = this.IIlIIIII.getPaymentPlugin(paymentPluginId);
        if (paymentPlugin == null || !paymentPlugin.getIsEnabled()) {
            return "/shop/common/error";
        }
        Setting setting = SettingUtils.get();
        if (amount == null || amount.compareTo(new BigDecimal(0)) <= 0 || amount.precision() > 15 || amount.scale() > setting.getPriceScale()) {
            return "/shop/common/error";
        }
        BigDecimal bigDecimal = paymentPlugin.getFee(amount);
        amount = amount.add(bigDecimal);
        Payment payment = new Payment();
        payment.setSn(this.IIlIIIlI.generate(Sn.Type.payment));
        payment.setType(Payment.Type.online);
        payment.setStatus(Payment.Status.wait);
        payment.setPaymentMethod(paymentPlugin.getPaymentName());
        payment.setFee(bigDecimal);
        payment.setAmount(amount);
        payment.setPaymentPluginId(paymentPluginId);
        payment.setExpire(paymentPlugin.getTimeout() != null ? DateUtils.addMinutes((Date)new Date(), (int)paymentPlugin.getTimeout()) : null);
        payment.setMember(this.IIIllllI.getCurrent());
        this.IIlIIIIl.save((Object)payment);
        model.addAttribute("url", (Object)paymentPlugin.getUrl());
        model.addAttribute("method", (Object)paymentPlugin.getMethod());
        model.addAttribute("parameterMap", (Object)paymentPlugin.getParameterMap(payment.getSn(), amount, this.IIIllIlI("shop.member.deposit.recharge", new Object[0]), request));
        return "shop/payment/submit";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Integer pageNumber, ModelMap model) {
        Member member = this.IIIllllI.getCurrent();
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        model.addAttribute("page", (Object)this.IIIlllll.findPage(member, pageable));
        return "shop/member/deposit/list";
    }
}

