/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop.member;

import java.io.Serializable;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.service.MemberService;
import net.shopxx.service.ProductService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shopMemberFavoriteController")
@RequestMapping(value={"/member/favorite"})
public class FavoriteController
extends BaseController {
    private static final int IIIlllIl = 10;
    @Resource(name="memberServiceImpl")
    private MemberService IIIllllI;
    @Resource(name="productServiceImpl")
    private ProductService IIIlllll;

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Message add(Long id) {
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            return IIIllIll;
        }
        Member member = this.IIIllllI.getCurrent();
        if (member.getFavoriteProducts().contains(product)) {
            return Message.warn((String)"shop.member.favorite.exist", (Object[])new Object[0]);
        }
        if (Member.MAX_FAVORITE_COUNT != null && member.getFavoriteProducts().size() >= Member.MAX_FAVORITE_COUNT) {
            return Message.warn((String)"shop.member.favorite.addCountNotAllowed", (Object[])new Object[]{Member.MAX_FAVORITE_COUNT});
        }
        member.getFavoriteProducts().add(product);
        this.IIIllllI.update((Object)member);
        return Message.success((String)"shop.member.favorite.success", (Object[])new Object[0]);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Integer pageNumber, ModelMap model) {
        Member member = this.IIIllllI.getCurrent();
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        model.addAttribute("page", (Object)this.IIIlllll.findPage(member, pageable));
        return "shop/member/favorite/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long id) {
        Product product = (Product)this.IIIlllll.find((Serializable)id);
        if (product == null) {
            return IIIllIll;
        }
        Member member = this.IIIllllI.getCurrent();
        if (!member.getFavoriteProducts().contains(product)) {
            return IIIllIll;
        }
        member.getFavoriteProducts().remove(product);
        this.IIIllllI.update((Object)member);
        return IIIlllII;
    }
}

