/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop.member;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Member;
import net.shopxx.service.MemberService;
import net.shopxx.service.MessageService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="shopMemberMessageController")
@RequestMapping(value={"/member/message"})
public class MessageController
extends BaseController {
    private static final int IIIlllll = 10;
    @Resource(name="messageServiceImpl")
    MessageService IIIlllIl;
    @Resource(name="memberServiceImpl")
    MemberService IIIllllI;

    @RequestMapping(value={"/check_username"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkUsername(String username) {
        return !StringUtils.equalsIgnoreCase((String)username, (String)this.IIIllllI.getCurrentUsername()) && this.IIIllllI.usernameExists(username);
    }

    @RequestMapping(value={"/send"}, method={RequestMethod.GET})
    public String send(Long draftMessageId, Model model) {
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)draftMessageId);
        if (message != null && message.getIsDraft().booleanValue() && message.getSender() == this.IIIllllI.getCurrent()) {
            model.addAttribute("draftMessage", (Object)message);
        }
        return "/shop/member/message/send";
    }

    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    public String send(Long draftMessageId, String username, String title, String content, @RequestParam(defaultValue="false") Boolean isDraft, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI(net.shopxx.entity.Message.class, "content", (Object)content, new Class[0])) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)draftMessageId);
        if (message != null && message.getIsDraft().booleanValue() && message.getSender() == member) {
            this.IIIlllIl.delete((Object)message);
        }
        Member member2 = null;
        if (StringUtils.isNotEmpty((String)username) && ((member2 = this.IIIllllI.findByUsername(username)) == null || member2 == member)) {
            return "/shop/common/error";
        }
        net.shopxx.entity.Message message2 = new net.shopxx.entity.Message();
        message2.setTitle(title);
        message2.setContent(content);
        message2.setIp(request.getRemoteAddr());
        message2.setIsDraft(isDraft);
        message2.setSenderRead(Boolean.valueOf(true));
        message2.setReceiverRead(Boolean.valueOf(false));
        message2.setSenderDelete(Boolean.valueOf(false));
        message2.setReceiverDelete(Boolean.valueOf(false));
        message2.setSender(member);
        message2.setReceiver(member2);
        this.IIIlllIl.save((Object)message2);
        if (isDraft.booleanValue()) {
            this.IIIllIlI(redirectAttributes, Message.success((String)"shop.member.message.saveDraftSuccess", (Object[])new Object[0]));
            return "redirect:draft.jhtml";
        }
        this.IIIllIlI(redirectAttributes, Message.success((String)"shop.member.message.sendSuccess", (Object[])new Object[0]));
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(Long id, Model model) {
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)id);
        if (message == null || message.getIsDraft().booleanValue() || message.getForMessage() != null) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        if (message.getSender() != member && message.getReceiver() != member || message.getReceiver() == member && message.getReceiverDelete() != false || message.getSender() == member && message.getSenderDelete().booleanValue()) {
            return "/shop/common/error";
        }
        if (member == message.getReceiver()) {
            message.setReceiverRead(Boolean.valueOf(true));
        } else {
            message.setSenderRead(Boolean.valueOf(true));
        }
        this.IIIlllIl.update((Object)message);
        model.addAttribute("memberMessage", (Object)message);
        return "/shop/member/message/view";
    }

    @RequestMapping(value={"/reply"}, method={RequestMethod.POST})
    public String reply(Long id, String content, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI(net.shopxx.entity.Message.class, "content", (Object)content, new Class[0])) {
            return "/shop/common/error";
        }
        net.shopxx.entity.Message message = (net.shopxx.entity.Message)this.IIIlllIl.find((Serializable)id);
        if (message == null || message.getIsDraft().booleanValue() || message.getForMessage() != null) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        if (message.getSender() != member && message.getReceiver() != member || message.getReceiver() == member && message.getReceiverDelete() != false || message.getSender() == member && message.getSenderDelete().booleanValue()) {
            return "/shop/common/error";
        }
        net.shopxx.entity.Message message2 = new net.shopxx.entity.Message();
        message2.setTitle("reply: " + message.getTitle());
        message2.setContent(content);
        message2.setIp(request.getRemoteAddr());
        message2.setIsDraft(Boolean.valueOf(false));
        message2.setSenderRead(Boolean.valueOf(true));
        message2.setReceiverRead(Boolean.valueOf(false));
        message2.setSenderDelete(Boolean.valueOf(false));
        message2.setReceiverDelete(Boolean.valueOf(false));
        message2.setSender(member);
        message2.setReceiver(member == message.getReceiver() ? message.getSender() : message.getReceiver());
        if (member == message.getReceiver() && !message.getSenderDelete().booleanValue() || member == message.getSender() && !message.getReceiverDelete().booleanValue()) {
            message2.setForMessage(message);
        }
        this.IIIlllIl.save((Object)message2);
        if (member.equals((Object)message.getSender())) {
            message.setSenderRead(Boolean.valueOf(true));
            message.setReceiverRead(Boolean.valueOf(false));
        } else {
            message.setSenderRead(Boolean.valueOf(false));
            message.setReceiverRead(Boolean.valueOf(true));
        }
        this.IIIlllIl.update((Object)message);
        if (member == message.getReceiver() && !message.getSenderDelete().booleanValue() || member == message.getSender() && !message.getReceiverDelete().booleanValue()) {
            this.IIIllIlI(redirectAttributes, IIIlllII);
            return "redirect:view.jhtml?id=" + message.getId();
        }
        this.IIIllIlI(redirectAttributes, Message.success((String)"shop.member.message.replySuccess", (Object[])new Object[0]));
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Integer pageNumber, Model model) {
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        Member member = this.IIIllllI.getCurrent();
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(member, pageable));
        return "/shop/member/message/list";
    }

    @RequestMapping(value={"/draft"}, method={RequestMethod.GET})
    public String draft(Integer pageNumber, Model model) {
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        Member member = this.IIIllllI.getCurrent();
        model.addAttribute("page", (Object)this.IIIlllIl.findDraftPage(member, pageable));
        return "/shop/member/message/draft";
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long id) {
        Member member = this.IIIllllI.getCurrent();
        this.IIIlllIl.delete(id, member);
        return IIIlllII;
    }
}

