/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop.member;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Area;
import net.shopxx.entity.Cart;
import net.shopxx.entity.Coupon;
import net.shopxx.entity.CouponCode;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order;
import net.shopxx.entity.PaymentMethod;
import net.shopxx.entity.Receiver;
import net.shopxx.entity.Shipping;
import net.shopxx.entity.ShippingMethod;
import net.shopxx.plugin.PaymentPlugin;
import net.shopxx.service.AreaService;
import net.shopxx.service.CartService;
import net.shopxx.service.CouponCodeService;
import net.shopxx.service.MemberService;
import net.shopxx.service.OrderService;
import net.shopxx.service.PaymentMethodService;
import net.shopxx.service.PluginService;
import net.shopxx.service.ReceiverService;
import net.shopxx.service.ShippingMethodService;
import net.shopxx.service.ShippingService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="shopMemberOrderController")
@RequestMapping(value={"/member/order"})
public class OrderController
extends BaseController {
    private static final int IIIlllIl = 10;
    @Resource(name="memberServiceImpl")
    private MemberService IIIllllI;
    @Resource(name="areaServiceImpl")
    private AreaService IIIlllll;
    @Resource(name="receiverServiceImpl")
    private ReceiverService IIlIIIII;
    @Resource(name="cartServiceImpl")
    private CartService IIlIIIIl;
    @Resource(name="paymentMethodServiceImpl")
    private PaymentMethodService IIlIIIlI;
    @Resource(name="shippingMethodServiceImpl")
    private ShippingMethodService IIlIIIll;
    @Resource(name="couponCodeServiceImpl")
    private CouponCodeService IIlIIlII;
    @Resource(name="orderServiceImpl")
    private OrderService IIlIIlIl;
    @Resource(name="shippingServiceImpl")
    private ShippingService IIlIIllI;
    @Resource(name="pluginServiceImpl")
    private PluginService IIlIIlll;

    @RequestMapping(value={"/save_receiver"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> saveReceiver(Receiver receiver, Long areaId) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        receiver.setArea((Area)this.IIIlllll.find((Serializable)areaId));
        if (!this.IIIllIlI((Object)receiver, new Class[0])) {
            hashMap.put("message", IIIllIll);
            return hashMap;
        }
        Member member = this.IIIllllI.getCurrent();
        if (Receiver.MAX_RECEIVER_COUNT != null && member.getReceivers().size() >= Receiver.MAX_RECEIVER_COUNT) {
            hashMap.put("message", Message.error((String)"shop.order.addReceiverCountNotAllowed", (Object[])new Object[]{Receiver.MAX_RECEIVER_COUNT}));
            return hashMap;
        }
        receiver.setMember(member);
        this.IIlIIIII.save((Object)receiver);
        hashMap.put("message", IIIlllII);
        hashMap.put("receiver", receiver);
        return hashMap;
    }

    @RequestMapping(value={"/check_lock"}, method={RequestMethod.POST})
    @ResponseBody
    public Message checkLock(String sn) {
        Order order = this.IIlIIlIl.findBySn(sn);
        if (!(order == null || order.getMember() != this.IIIllllI.getCurrent() || order.isExpired() || order.getPaymentMethod() == null || order.getPaymentMethod().getType() != PaymentMethod.Type.online || order.getPaymentStatus() != Order.PaymentStatus.unpaid && order.getPaymentStatus() != Order.PaymentStatus.partialPayment)) {
            if (order.isLocked(null)) {
                return Message.warn((String)"shop.order.locked", (Object[])new Object[0]);
            }
            order.setLockExpire(DateUtils.addSeconds((Date)new Date(), (int)60));
            order.setOperator(null);
            this.IIlIIlIl.update((Object)order);
            return IIIlllII;
        }
        return IIIllIll;
    }

    @RequestMapping(value={"/check_payment"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean checkPayment(String sn) {
        Order order = this.IIlIIlIl.findBySn(sn);
        return order != null && order.getMember() == this.IIIllllI.getCurrent() && order.getPaymentStatus() == Order.PaymentStatus.paid;
    }

    @RequestMapping(value={"/coupon_info"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> couponInfo(String code) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Cart cart = this.IIlIIIIl.getCurrent();
        if (cart == null || cart.isEmpty()) {
            hashMap.put("message", Message.warn((String)"shop.order.cartNotEmpty", (Object[])new Object[0]));
            return hashMap;
        }
        if (!cart.isCouponAllowed()) {
            hashMap.put("message", Message.warn((String)"shop.order.couponNotAllowed", (Object[])new Object[0]));
            return hashMap;
        }
        CouponCode couponCode = this.IIlIIlII.findByCode(code);
        if (couponCode != null && couponCode.getCoupon() != null) {
            Coupon coupon = couponCode.getCoupon();
            if (!coupon.getIsEnabled().booleanValue()) {
                hashMap.put("message", Message.warn((String)"shop.order.couponDisabled", (Object[])new Object[0]));
                return hashMap;
            }
            if (!coupon.hasBegun()) {
                hashMap.put("message", Message.warn((String)"shop.order.couponNotBegin", (Object[])new Object[0]));
                return hashMap;
            }
            if (coupon.hasExpired()) {
                hashMap.put("message", Message.warn((String)"shop.order.couponHasExpired", (Object[])new Object[0]));
                return hashMap;
            }
            if (!cart.isValid(coupon)) {
                hashMap.put("message", Message.warn((String)"shop.order.couponInvalid", (Object[])new Object[0]));
                return hashMap;
            }
            if (couponCode.getIsUsed().booleanValue()) {
                hashMap.put("message", Message.warn((String)"shop.order.couponCodeUsed", (Object[])new Object[0]));
                return hashMap;
            }
            hashMap.put("message", IIIlllII);
            hashMap.put("couponName", coupon.getName());
            return hashMap;
        }
        hashMap.put("message", Message.warn((String)"shop.order.couponCodeNotExist", (Object[])new Object[0]));
        return hashMap;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String info(ModelMap model) {
        Cart cart = this.IIlIIIIl.getCurrent();
        if (cart == null || cart.isEmpty()) {
            return "redirect:/cart/list.jhtml";
        }
        if (!this.IIIllIlI((Object)cart, new Class[0])) {
            return "/shop/common/error";
        }
        Order order = this.IIlIIlIl.build(cart, null, null, null, null, false, null, false, null);
        model.addAttribute("order", (Object)order);
        model.addAttribute("cartToken", (Object)cart.getToken());
        model.addAttribute("paymentMethods", (Object)this.IIlIIIlI.findAll());
        model.addAttribute("shippingMethods", (Object)this.IIlIIIll.findAll());
        return "/shop/member/order/info";
    }

    @RequestMapping(value={"/calculate"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> calculate(Long paymentMethodId, Long shippingMethodId, String code, @RequestParam(defaultValue="false") Boolean isInvoice, String invoiceTitle, @RequestParam(defaultValue="false") Boolean useBalance, String memo) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Cart cart = this.IIlIIIIl.getCurrent();
        if (cart == null || cart.isEmpty()) {
            hashMap.put("message", Message.error((String)"shop.order.cartNotEmpty", (Object[])new Object[0]));
            return hashMap;
        }
        PaymentMethod paymentMethod = (PaymentMethod)this.IIlIIIlI.find((Serializable)paymentMethodId);
        ShippingMethod shippingMethod = (ShippingMethod)this.IIlIIIll.find((Serializable)shippingMethodId);
        CouponCode couponCode = this.IIlIIlII.findByCode(code);
        Order order = this.IIlIIlIl.build(cart, null, paymentMethod, shippingMethod, couponCode, isInvoice.booleanValue(), invoiceTitle, useBalance.booleanValue(), memo);
        hashMap.put("message", IIIlllII);
        hashMap.put("quantity", order.getQuantity());
        hashMap.put("price", order.getPrice());
        hashMap.put("freight", order.getFreight());
        hashMap.put("tax", order.getTax());
        hashMap.put("amountPayable", order.getAmountPayable());
        return hashMap;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Message create(String cartToken, Long receiverId, Long paymentMethodId, Long shippingMethodId, String code, @RequestParam(defaultValue="false") Boolean isInvoice, String invoiceTitle, @RequestParam(defaultValue="false") Boolean useBalance, String memo) {
        Cart cart = this.IIlIIIIl.getCurrent();
        if (cart == null || cart.isEmpty()) {
            return Message.warn((String)"shop.order.cartNotEmpty", (Object[])new Object[0]);
        }
        if (!StringUtils.equals((String)cart.getToken(), (String)cartToken)) {
            return Message.warn((String)"shop.order.cartHasChanged", (Object[])new Object[0]);
        }
        if (cart.getIsLowStock()) {
            return Message.warn((String)"shop.order.cartLowStock", (Object[])new Object[0]);
        }
        Receiver receiver = (Receiver)this.IIlIIIII.find((Serializable)receiverId);
        if (receiver == null) {
            return Message.error((String)"shop.order.receiverNotExsit", (Object[])new Object[0]);
        }
        PaymentMethod paymentMethod = (PaymentMethod)this.IIlIIIlI.find((Serializable)paymentMethodId);
        if (paymentMethod == null) {
            return Message.error((String)"shop.order.paymentMethodNotExsit", (Object[])new Object[0]);
        }
        ShippingMethod shippingMethod = (ShippingMethod)this.IIlIIIll.find((Serializable)shippingMethodId);
        if (shippingMethod == null) {
            return Message.error((String)"shop.order.shippingMethodNotExsit", (Object[])new Object[0]);
        }
        if (!paymentMethod.getShippingMethods().contains(shippingMethod)) {
            return Message.error((String)"shop.order.deliveryUnsupported", (Object[])new Object[0]);
        }
        CouponCode couponCode = this.IIlIIlII.findByCode(code);
        Order order = this.IIlIIlIl.create(cart, receiver, paymentMethod, shippingMethod, couponCode, isInvoice.booleanValue(), invoiceTitle, useBalance.booleanValue(), memo, null);
        return Message.success((String)order.getSn(), (Object[])new Object[0]);
    }

    @RequestMapping(value={"/payment"}, method={RequestMethod.GET})
    public String payment(String sn, ModelMap model) {
        List list;
        Order order = this.IIlIIlIl.findBySn(sn);
        if (order == null || order.getMember() != this.IIIllllI.getCurrent() || order.isExpired() || order.getPaymentMethod() == null) {
            return "/shop/common/error";
        }
        if (order.getPaymentMethod().getType() == PaymentMethod.Type.online && !(list = this.IIlIIlll.getPaymentPlugins(true)).isEmpty()) {
            PaymentPlugin paymentPlugin = (PaymentPlugin)list.get(0);
            order.setFee(paymentPlugin.getFee(order.getAmountPayable()));
            model.addAttribute("defaultPaymentPlugin", (Object)paymentPlugin);
            model.addAttribute("paymentPlugins", (Object)list);
        }
        model.addAttribute("order", (Object)order);
        return "/shop/member/order/payment";
    }

    @RequestMapping(value={"/payment_plugin_select"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> paymentPluginSelect(String sn, String paymentPluginId) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Order order = this.IIlIIlIl.findBySn(sn);
        PaymentPlugin paymentPlugin = this.IIlIIlll.getPaymentPlugin(paymentPluginId);
        if (order == null || order.getMember() != this.IIIllllI.getCurrent() || order.isExpired() || order.isLocked(null) || order.getPaymentMethod() == null || order.getPaymentMethod().getType() == PaymentMethod.Type.offline || paymentPlugin == null || !paymentPlugin.getIsEnabled()) {
            hashMap.put("message", IIIllIll);
            return hashMap;
        }
        order.setFee(paymentPlugin.getFee(order.getAmountPayable()));
        hashMap.put("message", IIIlllII);
        hashMap.put("fee", order.getFee());
        hashMap.put("amountPayable", order.getAmountPayable());
        return hashMap;
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Integer pageNumber, ModelMap model) {
        Member member = this.IIIllllI.getCurrent();
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        model.addAttribute("page", (Object)this.IIlIIlIl.findPage(member, pageable));
        return "shop/member/order/list";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(String sn, ModelMap model) {
        Order order = this.IIlIIlIl.findBySn(sn);
        if (order == null) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        if (!member.getOrders().contains(order)) {
            return "/shop/common/error";
        }
        model.addAttribute("order", (Object)order);
        return "shop/member/order/view";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    @ResponseBody
    public Message cancel(String sn) {
        Order order = this.IIlIIlIl.findBySn(sn);
        if (order != null && order.getMember() == this.IIIllllI.getCurrent() && !order.isExpired() && order.getOrderStatus() == Order.OrderStatus.unconfirmed && order.getPaymentStatus() == Order.PaymentStatus.unpaid) {
            if (order.isLocked(null)) {
                return Message.warn((String)"shop.member.order.locked", (Object[])new Object[0]);
            }
            this.IIlIIlIl.cancel(order, null);
            return IIIlllII;
        }
        return IIIllIll;
    }

    @RequestMapping(value={"/delivery_query"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> deliveryQuery(String sn) {
        Map<String, Object> map = new HashMap<String, Object>();
        Shipping shipping = this.IIlIIllI.findBySn(sn);
        Setting setting = SettingUtils.get();
        if (shipping != null && shipping.getOrder() != null && shipping.getOrder().getMember() == this.IIIllllI.getCurrent() && StringUtils.isNotEmpty((String)setting.getKuaidi100Key()) && StringUtils.isNotEmpty((String)shipping.getDeliveryCorpCode()) && StringUtils.isNotEmpty((String)shipping.getTrackingNo())) {
            map = this.IIlIIllI.query(shipping);
        }
        return map;
    }
}

