/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop.member;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.CommonAttributes;
import net.shopxx.Setting;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Area;
import net.shopxx.entity.Member;
import net.shopxx.entity.MemberAttribute;
import net.shopxx.service.AreaService;
import net.shopxx.service.MemberAttributeService;
import net.shopxx.service.MemberService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="shopMemberProfileController")
@RequestMapping(value={"/member/profile"})
public class ProfileController
extends BaseController {
    @Resource(name="memberServiceImpl")
    private MemberService IIIlllIl;
    @Resource(name="memberAttributeServiceImpl")
    private MemberAttributeService IIIllllI;
    @Resource(name="areaServiceImpl")
    private AreaService IIIlllll;

    @RequestMapping(value={"/check_email"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkEmail(String email) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        Member member = this.IIIlllIl.getCurrent();
        return this.IIIlllIl.emailUnique(member.getEmail(), email);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(ModelMap model) {
        model.addAttribute("genders", (Object)Member.Gender.values());
        model.addAttribute("memberAttributes", (Object)this.IIIllllI.findList());
        return "shop/member/profile/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(String email, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (!this.IIIllIlI(Member.class, "email", (Object)email, new Class[0])) {
            return "/shop/common/error";
        }
        Setting setting = SettingUtils.get();
        Member member = this.IIIlllIl.getCurrent();
        if (!setting.getIsDuplicateEmail().booleanValue() && !this.IIIlllIl.emailUnique(member.getEmail(), email)) {
            return "/shop/common/error";
        }
        member.setEmail(email);
        List list = this.IIIllllI.findList();
        for (MemberAttribute memberAttribute : list) {
            List<String> list2;
            String[] stringArray;
            String string = request.getParameter("memberAttribute_" + memberAttribute.getId());
            if (memberAttribute.getType() == MemberAttribute.Type.name || memberAttribute.getType() == MemberAttribute.Type.address || memberAttribute.getType() == MemberAttribute.Type.zipCode || memberAttribute.getType() == MemberAttribute.Type.phone || memberAttribute.getType() == MemberAttribute.Type.mobile || memberAttribute.getType() == MemberAttribute.Type.text || memberAttribute.getType() == MemberAttribute.Type.select) {
                if (memberAttribute.getIsRequired().booleanValue() && StringUtils.isEmpty((String)string)) {
                    return "/shop/common/error";
                }
                member.setAttributeValue(memberAttribute, (Object)string);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.gender) {
                String[] stringArray2 = stringArray = StringUtils.isNotEmpty((String)string) ? Member.Gender.valueOf((String)string) : null;
                if (memberAttribute.getIsRequired().booleanValue() && stringArray == null) {
                    return "/shop/common/error";
                }
                member.setGender((Member.Gender)stringArray);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.birth) {
                block14: {
                    try {
                        String[] stringArray3 = stringArray = StringUtils.isNotEmpty((String)string) ? DateUtils.parseDate((String)string, (String[])CommonAttributes.DATE_PATTERNS) : null;
                        if (!memberAttribute.getIsRequired().booleanValue() || stringArray != null) break block14;
                        return "/shop/common/error";
                    }
                    catch (ParseException parseException) {
                        return "/shop/common/error";
                    }
                }
                member.setBirth((Date)stringArray);
                continue;
            }
            if (memberAttribute.getType() == MemberAttribute.Type.area) {
                String[] stringArray4 = stringArray = StringUtils.isNotEmpty((String)string) ? (String[])this.IIIlllll.find((Serializable)Long.valueOf(string)) : null;
                if (stringArray != null) {
                    member.setArea((Area)stringArray);
                    continue;
                }
                if (!memberAttribute.getIsRequired().booleanValue()) continue;
                return "/shop/common/error";
            }
            if (memberAttribute.getType() != MemberAttribute.Type.checkbox) continue;
            stringArray = request.getParameterValues("memberAttribute_" + memberAttribute.getId());
            List<String> list3 = list2 = stringArray != null ? Arrays.asList(stringArray) : null;
            if (memberAttribute.getIsRequired().booleanValue() && (list2 == null || list2.isEmpty())) {
                return "/shop/common/error";
            }
            member.setAttributeValue(memberAttribute, list2);
        }
        this.IIIlllIl.update((Object)member);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:edit.jhtml";
    }
}

