/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.shop.member;

import java.io.Serializable;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.shop.BaseController;
import net.shopxx.entity.Area;
import net.shopxx.entity.Member;
import net.shopxx.entity.Receiver;
import net.shopxx.service.AreaService;
import net.shopxx.service.MemberService;
import net.shopxx.service.ReceiverService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="shopMemberReceiverController")
@RequestMapping(value={"/member/receiver"})
public class ReceiverController
extends BaseController {
    private static final int IIIlllIl = 10;
    @Resource(name="memberServiceImpl")
    private MemberService IIIllllI;
    @Resource(name="areaServiceImpl")
    private AreaService IIIlllll;
    @Resource(name="receiverServiceImpl")
    private ReceiverService IIlIIIII;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Integer pageNumber, ModelMap model) {
        Member member = this.IIIllllI.getCurrent();
        Pageable pageable = new Pageable(pageNumber, Integer.valueOf(10));
        model.addAttribute("page", (Object)this.IIlIIIII.findPage(member, pageable));
        return "shop/member/receiver/list";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(RedirectAttributes redirectAttributes) {
        Member member = this.IIIllllI.getCurrent();
        if (Receiver.MAX_RECEIVER_COUNT != null && member.getReceivers().size() >= Receiver.MAX_RECEIVER_COUNT) {
            this.IIIllIlI(redirectAttributes, Message.warn((String)"shop.member.receiver.addCountNotAllowed", (Object[])new Object[]{Receiver.MAX_RECEIVER_COUNT}));
            return "redirect:list.jhtml";
        }
        return "shop/member/receiver/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Receiver receiver, Long areaId, RedirectAttributes redirectAttributes) {
        receiver.setArea((Area)this.IIIlllll.find((Serializable)areaId));
        if (!this.IIIllIlI((Object)receiver, new Class[0])) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        if (Receiver.MAX_RECEIVER_COUNT != null && member.getReceivers().size() >= Receiver.MAX_RECEIVER_COUNT) {
            return "/shop/common/error";
        }
        receiver.setMember(member);
        this.IIlIIIII.save((Object)receiver);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model, RedirectAttributes redirectAttributes) {
        Receiver receiver = (Receiver)this.IIlIIIII.find((Serializable)id);
        if (receiver == null) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        if (receiver.getMember() != member) {
            return "/shop/common/error";
        }
        model.addAttribute("receiver", (Object)receiver);
        return "shop/member/receiver/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Receiver receiver, Long id, Long areaId, RedirectAttributes redirectAttributes) {
        receiver.setArea((Area)this.IIIlllll.find((Serializable)areaId));
        if (!this.IIIllIlI((Object)receiver, new Class[0])) {
            return "/shop/common/error";
        }
        Receiver receiver2 = (Receiver)this.IIlIIIII.find((Serializable)id);
        if (receiver2 == null) {
            return "/shop/common/error";
        }
        Member member = this.IIIllllI.getCurrent();
        if (receiver2.getMember() != member) {
            return "/shop/common/error";
        }
        this.IIlIIIII.update((Object)receiver, new String[]{"member"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long id) {
        Receiver receiver = (Receiver)this.IIlIIIII.find((Serializable)id);
        if (receiver == null) {
            return IIIllIll;
        }
        Member member = this.IIIllllI.getCurrent();
        if (receiver.getMember() != member) {
            return IIIllIll;
        }
        this.IIlIIIII.delete((Serializable)id);
        return IIIlllII;
    }
}

