/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import net.shopxx.dao.ArticleCategoryDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.ArticleCategory;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="articleCategoryDaoImpl")
public class ArticleCategoryDaoImpl
extends BaseDaoImpl<ArticleCategory, Long>
implements ArticleCategoryDao {
    public List<ArticleCategory> findRoots(Integer count) {
        String string = "select articleCategory from ArticleCategory articleCategory where articleCategory.parent is null order by articleCategory.order asc";
        TypedQuery typedQuery = this.IIIllIlI.createQuery(string, ArticleCategory.class).setFlushMode(FlushModeType.COMMIT);
        if (count != null) {
            typedQuery.setMaxResults(count.intValue());
        }
        return typedQuery.getResultList();
    }

    public List<ArticleCategory> findParents(ArticleCategory articleCategory, Integer count) {
        if (articleCategory == null || articleCategory.getParent() == null) {
            return Collections.emptyList();
        }
        String string = "select articleCategory from ArticleCategory articleCategory where articleCategory.id in (:ids) order by articleCategory.grade asc";
        TypedQuery typedQuery = this.IIIllIlI.createQuery(string, ArticleCategory.class).setFlushMode(FlushModeType.COMMIT).setParameter("ids", (Object)articleCategory.getTreePaths());
        if (count != null) {
            typedQuery.setMaxResults(count.intValue());
        }
        return typedQuery.getResultList();
    }

    public List<ArticleCategory> findChildren(ArticleCategory articleCategory, Integer count) {
        TypedQuery typedQuery;
        if (articleCategory != null) {
            String string = "select articleCategory from ArticleCategory articleCategory where articleCategory.treePath like :treePath order by articleCategory.order asc";
            typedQuery = this.IIIllIlI.createQuery(string, ArticleCategory.class).setFlushMode(FlushModeType.COMMIT).setParameter("treePath", (Object)("%," + articleCategory.getId() + "," + "%"));
        } else {
            String string = "select articleCategory from ArticleCategory articleCategory order by articleCategory.order asc";
            typedQuery = this.IIIllIlI.createQuery(string, ArticleCategory.class).setFlushMode(FlushModeType.COMMIT);
        }
        if (count != null) {
            typedQuery.setMaxResults(count.intValue());
        }
        return this.IIIllIlI(typedQuery.getResultList(), articleCategory);
    }

    public void persist(ArticleCategory articleCategory) {
        Assert.notNull((Object)articleCategory);
        this.IIIllIlI(articleCategory);
        super.persist((Object)articleCategory);
    }

    public ArticleCategory merge(ArticleCategory articleCategory) {
        Assert.notNull((Object)articleCategory);
        this.IIIllIlI(articleCategory);
        for (ArticleCategory articleCategory2 : this.findChildren(articleCategory, null)) {
            this.IIIllIlI(articleCategory2);
        }
        return (ArticleCategory)super.merge((Object)articleCategory);
    }

    private List<ArticleCategory> IIIllIlI(List<ArticleCategory> list, ArticleCategory articleCategory) {
        ArrayList<ArticleCategory> arrayList = new ArrayList<ArticleCategory>();
        if (list != null) {
            for (ArticleCategory articleCategory2 : list) {
                if (articleCategory2.getParent() != articleCategory) continue;
                arrayList.add(articleCategory2);
                arrayList.addAll(this.IIIllIlI(list, articleCategory2));
            }
        }
        return arrayList;
    }

    private void IIIllIlI(ArticleCategory articleCategory) {
        if (articleCategory == null) {
            return;
        }
        ArticleCategory articleCategory2 = articleCategory.getParent();
        if (articleCategory2 != null) {
            articleCategory.setTreePath(String.valueOf(articleCategory2.getTreePath()) + articleCategory2.getId() + ",");
        } else {
            articleCategory.setTreePath(",");
        }
        articleCategory.setGrade(Integer.valueOf(articleCategory.getTreePaths().size()));
    }
}

