/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.ArticleDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.Article;
import net.shopxx.entity.ArticleCategory;
import net.shopxx.entity.Tag;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="articleDaoImpl")
public class ArticleDaoImpl
extends BaseDaoImpl<Article, Long>
implements ArticleDao {
    public List<Article> findList(ArticleCategory articleCategory, List<Tag> tags, Integer count, List<Filter> filters, List<Order> orders) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Article.class);
        Root root = criteriaQuery.from(Article.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isPublication"), (Object)true));
        if (articleCategory != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("articleCategory"), (Object)articleCategory), (Expression)criteriaBuilder.like((Expression)root.get("articleCategory").get("treePath"), "%," + articleCategory.getId() + "," + "%")));
        }
        if (tags != null && !tags.isEmpty()) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.join("tags").in(tags));
            criteriaQuery.distinct(true);
        }
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc((Expression)root.get("isTop"))});
        return super.IIIllIlI(criteriaQuery, null, count, filters, orders);
    }

    public List<Article> findList(ArticleCategory articleCategory, Date beginDate, Date endDate, Integer first, Integer count) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Article.class);
        Root root = criteriaQuery.from(Article.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isPublication"), (Object)true));
        if (articleCategory != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("articleCategory"), (Object)articleCategory), (Expression)criteriaBuilder.like((Expression)root.get("articleCategory").get("treePath"), "%," + articleCategory.getId() + "," + "%")));
        }
        if (beginDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get("createDate"), (Comparable)endDate));
        }
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc((Expression)root.get("isTop"))});
        return super.IIIllIlI(criteriaQuery, first, count, null, null);
    }

    public Page<Article> findPage(ArticleCategory articleCategory, List<Tag> tags, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Article.class);
        Root root = criteriaQuery.from(Article.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isPublication"), (Object)true));
        if (articleCategory != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("articleCategory"), (Object)articleCategory), (Expression)criteriaBuilder.like((Expression)root.get("articleCategory").get("treePath"), "%," + articleCategory.getId() + "," + "%")));
        }
        if (tags != null && !tags.isEmpty()) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.join("tags").in(tags));
            criteriaQuery.distinct(true);
        }
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc((Expression)root.get("isTop"))});
        return super.IIIllIlI(criteriaQuery, pageable);
    }
}

