/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Filter;
import net.shopxx.Filter$Operator;
import net.shopxx.Order;
import net.shopxx.Order$Direction;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.BaseDao;
import net.shopxx.entity.OrderEntity;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDaoImpl<T, ID extends Serializable>
implements BaseDao<T, ID> {
    private Class<T> IIIllIll;
    private static volatile long IIIlllII = 0L;
    @PersistenceContext
    protected EntityManager IIIllIlI;

    public BaseDaoImpl() {
        Type type = this.getClass().getGenericSuperclass();
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        this.IIIllIll = (Class)typeArray[0];
    }

    public T find(ID id) {
        if (id != null) {
            return (T)this.IIIllIlI.find(this.IIIllIll, id);
        }
        return null;
    }

    public List<T> findList(Integer first, Integer count, List<Filter> filters, List<Order> orders) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.IIIllIll);
        criteriaQuery.select((Selection)criteriaQuery.from(this.IIIllIll));
        return this.IIIllIlI(criteriaQuery, first, count, filters, orders);
    }

    public Page<T> findPage(Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.IIIllIll);
        criteriaQuery.select((Selection)criteriaQuery.from(this.IIIllIll));
        return this.IIIllIlI(criteriaQuery, pageable);
    }

    public long count(Filter ... filters) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.IIIllIll);
        criteriaQuery.select((Selection)criteriaQuery.from(this.IIIllIll));
        return this.IIIllIlI(criteriaQuery, filters != null ? Arrays.asList(filters) : null);
    }

    public void persist(T entity) {
        Assert.notNull(entity);
        this.IIIllIlI.persist(entity);
    }

    public T merge(T entity) {
        Assert.notNull(entity);
        return (T)this.IIIllIlI.merge(entity);
    }

    public void remove(T entity) {
        if (entity != null) {
            this.IIIllIlI.remove(entity);
        }
    }

    public void refresh(T entity) {
        Assert.notNull(entity);
        this.IIIllIlI.refresh(entity);
    }

    public ID getIdentifier(T entity) {
        Assert.notNull(entity);
        return (ID)((Serializable)this.IIIllIlI.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity));
    }

    public boolean isManaged(T entity) {
        return this.IIIllIlI.contains(entity);
    }

    public void detach(T entity) {
        this.IIIllIlI.detach(entity);
    }

    public void lock(T entity, LockModeType lockModeType) {
        if (entity != null && lockModeType != null) {
            this.IIIllIlI.lock(entity, lockModeType);
        }
    }

    public void clear() {
        this.IIIllIlI.clear();
    }

    public void flush() {
        this.IIIllIlI.flush();
    }

    protected List<T> IIIllIlI(CriteriaQuery<T> criteriaQuery, Integer n, Integer n2, List<Filter> list, List<Order> list2) {
        Assert.notNull(criteriaQuery);
        Assert.notNull((Object)criteriaQuery.getSelection());
        Assert.notEmpty((Collection)criteriaQuery.getRoots());
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        Root root = this.IIIllIlI(criteriaQuery);
        this.IIIllIll(criteriaQuery, list);
        this.IIIlllII(criteriaQuery, list2);
        if (criteriaQuery.getOrderList().isEmpty()) {
            if (OrderEntity.class.isAssignableFrom(this.IIIllIll)) {
                criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.asc((Expression)root.get("order"))});
            } else {
                criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc((Expression)root.get("createDate"))});
            }
        }
        TypedQuery typedQuery = this.IIIllIlI.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
        if (n != null) {
            typedQuery.setFirstResult(n.intValue());
        }
        if (n2 != null) {
            typedQuery.setMaxResults(n2.intValue());
        }
        return typedQuery.getResultList();
    }

    protected Page<T> IIIllIlI(CriteriaQuery<T> criteriaQuery, Pageable pageable) {
        long l;
        int n;
        Assert.notNull(criteriaQuery);
        Assert.notNull((Object)criteriaQuery.getSelection());
        Assert.notEmpty((Collection)criteriaQuery.getRoots());
        if (pageable == null) {
            pageable = new Pageable();
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        Root root = this.IIIllIlI(criteriaQuery);
        this.IIIllIll(criteriaQuery, pageable);
        this.IIIlllII(criteriaQuery, pageable);
        if (criteriaQuery.getOrderList().isEmpty()) {
            if (OrderEntity.class.isAssignableFrom(this.IIIllIll)) {
                criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.asc((Expression)root.get("order"))});
            } else {
                criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc((Expression)root.get("createDate"))});
            }
        }
        if ((n = (int)Math.ceil((double)(l = this.IIIllIlI(criteriaQuery, null).longValue()) / (double)pageable.getPageSize())) < pageable.getPageNumber()) {
            pageable.setPageNumber(n);
        }
        TypedQuery typedQuery = this.IIIllIlI.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
        typedQuery.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize());
        typedQuery.setMaxResults(pageable.getPageSize());
        return new Page(typedQuery.getResultList(), l, pageable);
    }

    protected Long IIIllIlI(CriteriaQuery<T> criteriaQuery, List<Filter> list) {
        Root root2;
        Assert.notNull(criteriaQuery);
        Assert.notNull((Object)criteriaQuery.getSelection());
        Assert.notEmpty((Collection)criteriaQuery.getRoots());
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        this.IIIllIll(criteriaQuery, list);
        CriteriaQuery criteriaQuery2 = criteriaBuilder.createQuery(Long.class);
        for (Root root2 : criteriaQuery.getRoots()) {
            Root root3 = criteriaQuery2.from(root2.getJavaType());
            root3.alias(this.IIIllIlI((Selection)root2));
            this.IIIllIlI((From)root2, (From)root3);
        }
        root2 = this.IIIllIlI(criteriaQuery2, criteriaQuery.getResultType());
        criteriaQuery2.select((Selection)criteriaBuilder.count((Expression)root2));
        if (criteriaQuery.getGroupList() != null) {
            criteriaQuery2.groupBy(criteriaQuery.getGroupList());
        }
        if (criteriaQuery.getGroupRestriction() != null) {
            criteriaQuery2.having((Expression)criteriaQuery.getGroupRestriction());
        }
        if (criteriaQuery.getRestriction() != null) {
            criteriaQuery2.where((Expression)criteriaQuery.getRestriction());
        }
        return (Long)this.IIIllIlI.createQuery(criteriaQuery2).setFlushMode(FlushModeType.COMMIT).getSingleResult();
    }

    private synchronized String IIIllIlI(Selection<?> selection) {
        if (selection != null) {
            String string = selection.getAlias();
            if (string == null) {
                if (IIIlllII >= 1000L) {
                    IIIlllII = 0L;
                }
                string = "shopxxGeneratedAlias" + IIIlllII++;
                selection.alias(string);
            }
            return string;
        }
        return null;
    }

    private Root<T> IIIllIlI(CriteriaQuery<T> criteriaQuery) {
        if (criteriaQuery != null) {
            return this.IIIllIlI(criteriaQuery, criteriaQuery.getResultType());
        }
        return null;
    }

    private Root<T> IIIllIlI(CriteriaQuery<?> criteriaQuery, Class<T> clazz) {
        if (criteriaQuery != null && criteriaQuery.getRoots() != null && clazz != null) {
            for (Root root : criteriaQuery.getRoots()) {
                if (!clazz.equals(root.getJavaType())) continue;
                return (Root)root.as(clazz);
            }
        }
        return null;
    }

    private void IIIllIlI(From<?, ?> from, From<?, ?> from2) {
        Join join;
        for (Join join2 : from.getJoins()) {
            join = from2.join(join2.getAttribute().getName(), join2.getJoinType());
            join.alias(this.IIIllIlI((Selection)join2));
            this.IIIllIlI((From)join2, (From)join);
        }
        for (Join join2 : from.getFetches()) {
            join = from2.fetch(join2.getAttribute().getName());
            this.IIIllIlI((Fetch)join2, (Fetch)join);
        }
    }

    private void IIIllIlI(Fetch<?, ?> fetch, Fetch<?, ?> fetch2) {
        for (Fetch fetch3 : fetch.getFetches()) {
            Fetch fetch4 = fetch2.fetch(fetch3.getAttribute().getName());
            this.IIIllIlI(fetch3, fetch4);
        }
    }

    private void IIIllIll(CriteriaQuery<T> criteriaQuery, List<Filter> list) {
        if (criteriaQuery == null || list == null || list.isEmpty()) {
            return;
        }
        Root root = this.IIIllIlI(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        Predicate predicate = criteriaQuery.getRestriction() != null ? criteriaQuery.getRestriction() : criteriaBuilder.conjunction();
        for (Filter filter : list) {
            if (filter == null || StringUtils.isEmpty((String)filter.getProperty())) continue;
            if (filter.getOperator() == Filter$Operator.eq && filter.getValue() != null) {
                if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                    continue;
                }
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get(filter.getProperty()), filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.ne && filter.getValue() != null) {
                if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.notEqual(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                    continue;
                }
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.notEqual((Expression)root.get(filter.getProperty()), filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.gt && filter.getValue() != null) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.gt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.lt && filter.getValue() != null) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.ge && filter.getValue() != null) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.ge((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.le && filter.getValue() != null) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.le((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.like && filter.getValue() != null && filter.getValue() instanceof String) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.like((Expression)root.get(filter.getProperty()), (String)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.in && filter.getValue() != null) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.get(filter.getProperty()).in(new Object[]{filter.getValue()}));
                continue;
            }
            if (filter.getOperator() == Filter$Operator.isNull) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.get(filter.getProperty()).isNull());
                continue;
            }
            if (filter.getOperator() != Filter$Operator.isNotNull) continue;
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.get(filter.getProperty()).isNotNull());
        }
        criteriaQuery.where((Expression)predicate);
    }

    private void IIIllIll(CriteriaQuery<T> criteriaQuery, Pageable pageable) {
        Predicate predicate;
        if (criteriaQuery == null || pageable == null) {
            return;
        }
        Root root = this.IIIllIlI(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        Predicate predicate2 = predicate = criteriaQuery.getRestriction() != null ? criteriaQuery.getRestriction() : criteriaBuilder.conjunction();
        if (StringUtils.isNotEmpty((String)pageable.getSearchProperty()) && StringUtils.isNotEmpty((String)pageable.getSearchValue())) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.like((Expression)root.get(pageable.getSearchProperty()), "%" + pageable.getSearchValue() + "%"));
        }
        if (pageable.getFilters() != null) {
            for (Filter filter : pageable.getFilters()) {
                if (filter == null || StringUtils.isEmpty((String)filter.getProperty())) continue;
                if (filter.getOperator() == Filter$Operator.eq && filter.getValue() != null) {
                    if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                        continue;
                    }
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get(filter.getProperty()), filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.ne && filter.getValue() != null) {
                    if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.notEqual(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                        continue;
                    }
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.notEqual((Expression)root.get(filter.getProperty()), filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.gt && filter.getValue() != null) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.gt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.lt && filter.getValue() != null) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.ge && filter.getValue() != null) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.ge((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.le && filter.getValue() != null) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.le((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.like && filter.getValue() != null && filter.getValue() instanceof String) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.like((Expression)root.get(filter.getProperty()), (String)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.in && filter.getValue() != null) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.get(filter.getProperty()).in(new Object[]{filter.getValue()}));
                    continue;
                }
                if (filter.getOperator() == Filter$Operator.isNull) {
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.get(filter.getProperty()).isNull());
                    continue;
                }
                if (filter.getOperator() != Filter$Operator.isNotNull) continue;
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.get(filter.getProperty()).isNotNull());
            }
        }
        criteriaQuery.where((Expression)predicate);
    }

    private void IIIlllII(CriteriaQuery<T> criteriaQuery, List<Order> list) {
        if (criteriaQuery == null || list == null || list.isEmpty()) {
            return;
        }
        Root root = this.IIIllIlI(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        ArrayList<javax.persistence.criteria.Order> arrayList = new ArrayList<javax.persistence.criteria.Order>();
        if (!criteriaQuery.getOrderList().isEmpty()) {
            arrayList.addAll(criteriaQuery.getOrderList());
        }
        for (Order order : list) {
            if (order.getDirection() == Order$Direction.asc) {
                arrayList.add(criteriaBuilder.asc((Expression)root.get(order.getProperty())));
                continue;
            }
            if (order.getDirection() != Order$Direction.desc) continue;
            arrayList.add(criteriaBuilder.desc((Expression)root.get(order.getProperty())));
        }
        criteriaQuery.orderBy(arrayList);
    }

    private void IIIlllII(CriteriaQuery<T> criteriaQuery, Pageable pageable) {
        if (criteriaQuery == null || pageable == null) {
            return;
        }
        Root root = this.IIIllIlI(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        ArrayList<javax.persistence.criteria.Order> arrayList = new ArrayList<javax.persistence.criteria.Order>();
        if (!criteriaQuery.getOrderList().isEmpty()) {
            arrayList.addAll(criteriaQuery.getOrderList());
        }
        if (StringUtils.isNotEmpty((String)pageable.getOrderProperty()) && pageable.getOrderDirection() != null) {
            if (pageable.getOrderDirection() == Order$Direction.asc) {
                arrayList.add(criteriaBuilder.asc((Expression)root.get(pageable.getOrderProperty())));
            } else if (pageable.getOrderDirection() == Order$Direction.desc) {
                arrayList.add(criteriaBuilder.desc((Expression)root.get(pageable.getOrderProperty())));
            }
        }
        if (pageable.getOrders() != null) {
            for (Order order : pageable.getOrders()) {
                if (order.getDirection() == Order$Direction.asc) {
                    arrayList.add(criteriaBuilder.asc((Expression)root.get(order.getProperty())));
                    continue;
                }
                if (order.getDirection() != Order$Direction.desc) continue;
                arrayList.add(criteriaBuilder.desc((Expression)root.get(order.getProperty())));
            }
        }
        criteriaQuery.orderBy(arrayList);
    }
}

