/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.CouponCodeDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.Coupon;
import net.shopxx.entity.CouponCode;
import net.shopxx.entity.Member;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="couponCodeDaoImpl")
public class CouponCodeDaoImpl
extends BaseDaoImpl<CouponCode, Long>
implements CouponCodeDao {
    public boolean codeExists(String code) {
        if (code == null) {
            return false;
        }
        String string = "select count(*) from CouponCode couponCode where lower(couponCode.code) = lower(:code)";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("code", (Object)code).getSingleResult();
        return l > 0L;
    }

    public CouponCode findByCode(String code) {
        if (code == null) {
            return null;
        }
        try {
            String string = "select couponCode from CouponCode couponCode where lower(couponCode.code) = lower(:code)";
            return (CouponCode)this.IIIllIlI.createQuery(string, CouponCode.class).setFlushMode(FlushModeType.COMMIT).setParameter("code", (Object)code).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public CouponCode build(Coupon coupon, Member member) {
        Assert.notNull((Object)coupon);
        CouponCode couponCode = new CouponCode();
        String string = UUID.randomUUID().toString().toUpperCase();
        couponCode.setCode(String.valueOf(coupon.getPrefix()) + string.substring(0, 8) + string.substring(9, 13) + string.substring(14, 18) + string.substring(19, 23) + string.substring(24));
        couponCode.setIsUsed(Boolean.valueOf(false));
        couponCode.setCoupon(coupon);
        couponCode.setMember(member);
        super.persist((Object)couponCode);
        return couponCode;
    }

    public List<CouponCode> build(Coupon coupon, Member member, Integer count) {
        Assert.notNull((Object)coupon);
        Assert.notNull((Object)count);
        ArrayList<CouponCode> arrayList = new ArrayList<CouponCode>();
        int n = 0;
        while (n < count) {
            CouponCode couponCode = this.build(coupon, member);
            arrayList.add(couponCode);
            if (n % 20 == 0) {
                super.flush();
                super.clear();
            }
            ++n;
        }
        return arrayList;
    }

    public Page<CouponCode> findPage(Member member, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(CouponCode.class);
        Root root = criteriaQuery.from(CouponCode.class);
        criteriaQuery.select((Selection)root);
        if (member != null) {
            criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public Long count(Coupon coupon, Member member, Boolean hasBegun, Boolean hasExpired, Boolean isUsed) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(CouponCode.class);
        Root root = criteriaQuery.from(CouponCode.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        Path path = root.get("coupon");
        if (coupon != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)path, (Object)coupon));
        }
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        if (hasBegun != null) {
            predicate = hasBegun != false ? criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)path.get("beginDate").isNull(), (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)path.get("beginDate"), (Comparable)new Date()))) : criteriaBuilder.and(new Predicate[]{predicate, path.get("beginDate").isNotNull(), criteriaBuilder.greaterThan((Expression)path.get("beginDate"), (Comparable)new Date())});
        }
        if (hasExpired != null) {
            predicate = hasExpired != false ? criteriaBuilder.and(new Predicate[]{predicate, path.get("endDate").isNotNull(), criteriaBuilder.lessThan((Expression)path.get("endDate"), (Comparable)new Date())}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)path.get("endDate").isNull(), (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)path.get("endDate"), (Comparable)new Date())));
        }
        if (isUsed != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isUsed"), (Object)isUsed));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null);
    }
}

