/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.MemberDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="memberDaoImpl")
public class MemberDaoImpl
extends BaseDaoImpl<Member, Long>
implements MemberDao {
    public boolean usernameExists(String username) {
        if (username == null) {
            return false;
        }
        String string = "select count(*) from Member members where lower(members.username) = lower(:username)";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("username", (Object)username).getSingleResult();
        return l > 0L;
    }

    public boolean emailExists(String email) {
        if (email == null) {
            return false;
        }
        String string = "select count(*) from Member members where lower(members.email) = lower(:email)";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("email", (Object)email).getSingleResult();
        return l > 0L;
    }

    public Member findByUsername(String username) {
        if (username == null) {
            return null;
        }
        try {
            String string = "select members from Member members where lower(members.username) = lower(:username)";
            return (Member)this.IIIllIlI.createQuery(string, Member.class).setFlushMode(FlushModeType.COMMIT).setParameter("username", (Object)username).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public List<Member> findListByEmail(String email) {
        if (email == null) {
            return Collections.emptyList();
        }
        String string = "select members from Member members where lower(members.email) = lower(:email)";
        return this.IIIllIlI.createQuery(string, Member.class).setFlushMode(FlushModeType.COMMIT).setParameter("email", (Object)email).getResultList();
    }

    public Page<Object> findPurchasePage(Date beginDate, Date endDate, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Object.class);
        Root root = criteriaQuery.from(Member.class);
        Join join = root.join("orders");
        criteriaQuery.multiselect(new Selection[]{root, criteriaBuilder.sum((Expression)join.get("amountPaid"))});
        Predicate predicate = criteriaBuilder.conjunction();
        if (beginDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)join.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)join.get("createDate"), (Comparable)endDate));
        }
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)join.get("orderStatus"), (Object)Order.OrderStatus.completed));
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)join.get("paymentStatus"), (Object)Order.PaymentStatus.paid));
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.groupBy(new Expression[]{root.get("id")});
        CriteriaQuery criteriaQuery2 = criteriaBuilder.createQuery(Long.class);
        Root root2 = criteriaQuery2.from(Member.class);
        Join join2 = root2.join("orders");
        criteriaQuery2.select((Selection)criteriaBuilder.countDistinct((Expression)root2));
        Predicate predicate2 = criteriaBuilder.conjunction();
        if (beginDate != null) {
            predicate2 = criteriaBuilder.and((Expression)predicate2, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)join2.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate2 = criteriaBuilder.and((Expression)predicate2, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)join2.get("createDate"), (Comparable)endDate));
        }
        predicate2 = criteriaBuilder.and((Expression)predicate2, (Expression)criteriaBuilder.equal((Expression)join2.get("orderStatus"), (Object)Order.OrderStatus.completed));
        criteriaQuery2.where((Expression)predicate2);
        Long l = (Long)this.IIIllIlI.createQuery(criteriaQuery2).setFlushMode(FlushModeType.COMMIT).getSingleResult();
        int n = (int)Math.ceil((double)l.longValue() / (double)pageable.getPageSize());
        if (n < pageable.getPageNumber()) {
            pageable.setPageNumber(n);
        }
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc(criteriaBuilder.sum((Expression)join.get("amountPaid")))});
        TypedQuery typedQuery = this.IIIllIlI.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
        typedQuery.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize());
        typedQuery.setMaxResults(pageable.getPageSize());
        return new Page(typedQuery.getResultList(), l.longValue(), pageable);
    }
}

