/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.math.BigDecimal;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import net.shopxx.dao.MemberRankDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.MemberRank;
import net.shopxx.entity.Product;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="memberRankDaoImpl")
public class MemberRankDaoImpl
extends BaseDaoImpl<MemberRank, Long>
implements MemberRankDao {
    public boolean nameExists(String name) {
        if (name == null) {
            return false;
        }
        String string = "select count(*) from MemberRank memberRank where lower(memberRank.name) = lower(:name)";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("name", (Object)name).getSingleResult();
        return l > 0L;
    }

    public boolean amountExists(BigDecimal amount) {
        if (amount == null) {
            return false;
        }
        String string = "select count(*) from MemberRank memberRank where memberRank.amount = :amount";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("amount", (Object)amount).getSingleResult();
        return l > 0L;
    }

    public MemberRank findDefault() {
        try {
            String string = "select memberRank from MemberRank memberRank where memberRank.isDefault = true";
            return (MemberRank)this.IIIllIlI.createQuery(string, MemberRank.class).setFlushMode(FlushModeType.COMMIT).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public MemberRank findByAmount(BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        String string = "select memberRank from MemberRank memberRank where memberRank.isSpecial = false and memberRank.amount <= :amount order by memberRank.amount desc";
        return (MemberRank)this.IIIllIlI.createQuery(string, MemberRank.class).setFlushMode(FlushModeType.COMMIT).setParameter("amount", (Object)amount).setMaxResults(1).getSingleResult();
    }

    public void persist(MemberRank memberRank) {
        Assert.notNull((Object)memberRank);
        if (memberRank.getIsDefault().booleanValue()) {
            String string = "update MemberRank memberRank set memberRank.isDefault = false where memberRank.isDefault = true";
            this.IIIllIlI.createQuery(string).setFlushMode(FlushModeType.COMMIT).executeUpdate();
        }
        super.persist((Object)memberRank);
    }

    public MemberRank merge(MemberRank memberRank) {
        Assert.notNull((Object)memberRank);
        if (memberRank.getIsDefault().booleanValue()) {
            String string = "update MemberRank memberRank set memberRank.isDefault = false where memberRank.isDefault = true and memberRank != :memberRank";
            this.IIIllIlI.createQuery(string).setFlushMode(FlushModeType.COMMIT).setParameter("memberRank", (Object)memberRank).executeUpdate();
        }
        return (MemberRank)super.merge((Object)memberRank);
    }

    public void remove(MemberRank memberRank) {
        if (memberRank != null && !memberRank.getIsDefault().booleanValue()) {
            String string = "select product from Product product join product.memberPrice memberPrice where index(memberPrice) = :memberRank";
            List list = this.IIIllIlI.createQuery(string, Product.class).setFlushMode(FlushModeType.COMMIT).setParameter("memberRank", (Object)memberRank).getResultList();
            int n = 0;
            while (n < list.size()) {
                Product product = (Product)list.get(n);
                product.getMemberPrice().remove(memberRank);
                if (n % 20 == 0) {
                    super.flush();
                    super.clear();
                }
                ++n;
            }
            super.remove((Object)((MemberRank)super.merge((Object)memberRank)));
        }
    }
}

