/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.OrderDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order;
import net.shopxx.entity.OrderItem;
import net.shopxx.entity.Product;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="orderDaoImpl")
public class OrderDaoImpl
extends BaseDaoImpl<net.shopxx.entity.Order, Long>
implements OrderDao {
    public net.shopxx.entity.Order findBySn(String sn) {
        if (sn == null) {
            return null;
        }
        String string = "select orders from Order orders where lower(orders.sn) = lower(:sn)";
        try {
            return (net.shopxx.entity.Order)this.IIIllIlI.createQuery(string, net.shopxx.entity.Order.class).setFlushMode(FlushModeType.COMMIT).setParameter("sn", (Object)sn).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public List<net.shopxx.entity.Order> findList(Member member, Integer count, List<Filter> filters, List<Order> orders) {
        if (member == null) {
            return Collections.emptyList();
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(net.shopxx.entity.Order.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        return super.IIIllIlI(criteriaQuery, null, count, filters, orders);
    }

    public Page<net.shopxx.entity.Order> findPage(Member member, Pageable pageable) {
        if (member == null) {
            return new Page(Collections.emptyList(), 0L, pageable);
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(net.shopxx.entity.Order.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public Page<net.shopxx.entity.Order> findPage(Order.OrderStatus orderStatus, Order.PaymentStatus paymentStatus, Order.ShippingStatus shippingStatus, Boolean hasExpired, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(net.shopxx.entity.Order.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (orderStatus != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("orderStatus"), (Object)orderStatus));
        }
        if (paymentStatus != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("paymentStatus"), (Object)paymentStatus));
        }
        if (shippingStatus != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("shippingStatus"), (Object)shippingStatus));
        }
        if (hasExpired != null) {
            predicate = hasExpired != false ? criteriaBuilder.and(new Predicate[]{predicate, root.get("expire").isNotNull(), criteriaBuilder.lessThan((Expression)root.get("expire"), (Comparable)new Date())}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)root.get("expire").isNull(), (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("expire"), (Comparable)new Date())));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public Long count(Order.OrderStatus orderStatus, Order.PaymentStatus paymentStatus, Order.ShippingStatus shippingStatus, Boolean hasExpired) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(net.shopxx.entity.Order.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (orderStatus != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("orderStatus"), (Object)orderStatus));
        }
        if (paymentStatus != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("paymentStatus"), (Object)paymentStatus));
        }
        if (shippingStatus != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("shippingStatus"), (Object)shippingStatus));
        }
        if (hasExpired != null) {
            predicate = hasExpired != false ? criteriaBuilder.and(new Predicate[]{predicate, root.get("expire").isNotNull(), criteriaBuilder.lessThan((Expression)root.get("expire"), (Comparable)new Date())}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)root.get("expire").isNull(), (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("expire"), (Comparable)new Date())));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null);
    }

    public Long waitingPaymentCount(Member member) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(net.shopxx.entity.Order.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.notEqual((Expression)root.get("orderStatus"), (Object)Order.OrderStatus.completed), criteriaBuilder.notEqual((Expression)root.get("orderStatus"), (Object)Order.OrderStatus.cancelled)});
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("paymentStatus"), (Object)Order.PaymentStatus.unpaid), (Expression)criteriaBuilder.equal((Expression)root.get("paymentStatus"), (Object)Order.PaymentStatus.partialPayment)));
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)root.get("expire").isNull(), (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("expire"), (Comparable)new Date())));
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null);
    }

    public Long waitingShippingCount(Member member) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(net.shopxx.entity.Order.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.notEqual((Expression)root.get("orderStatus"), (Object)Order.OrderStatus.completed), criteriaBuilder.notEqual((Expression)root.get("orderStatus"), (Object)Order.OrderStatus.cancelled), criteriaBuilder.equal((Expression)root.get("paymentStatus"), (Object)Order.PaymentStatus.paid), criteriaBuilder.equal((Expression)root.get("shippingStatus"), (Object)Order.ShippingStatus.unshipped)});
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)root.get("expire").isNull(), (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("expire"), (Comparable)new Date())));
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null);
    }

    public BigDecimal getSalesAmount(Date beginDate, Date endDate) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(BigDecimal.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)criteriaBuilder.sum((Expression)root.get("amountPaid")));
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("orderStatus"), (Object)Order.OrderStatus.completed));
        if (beginDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get("createDate"), (Comparable)endDate));
        }
        criteriaQuery.where((Expression)predicate);
        return (BigDecimal)this.IIIllIlI.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getSingleResult();
    }

    public Integer getSalesVolume(Date beginDate, Date endDate) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Integer.class);
        Root root = criteriaQuery.from(net.shopxx.entity.Order.class);
        criteriaQuery.select((Selection)criteriaBuilder.sum((Expression)root.join("orderItems").get("shippedQuantity")));
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("orderStatus"), (Object)Order.OrderStatus.completed));
        if (beginDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get("createDate"), (Comparable)endDate));
        }
        criteriaQuery.where((Expression)predicate);
        return (Integer)this.IIIllIlI.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getSingleResult();
    }

    public void releaseStock() {
        String string = "select orders from Order orders where orders.isAllocatedStock = :isAllocatedStock and orders.expire is not null and orders.expire <= :now";
        List list = this.IIIllIlI.createQuery(string, net.shopxx.entity.Order.class).setParameter("isAllocatedStock", (Object)true).setParameter("now", (Object)new Date()).getResultList();
        if (list != null) {
            for (net.shopxx.entity.Order order : list) {
                if (order == null || order.getOrderItems() == null) continue;
                for (OrderItem orderItem : order.getOrderItems()) {
                    Product product;
                    if (orderItem == null || (product = orderItem.getProduct()) == null) continue;
                    this.IIIllIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                    product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() - (orderItem.getQuantity() - orderItem.getShippedQuantity())));
                }
                order.setIsAllocatedStock(Boolean.valueOf(false));
            }
        }
    }
}

