/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import net.shopxx.dao.ProductCategoryDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.ProductCategory;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="productCategoryDaoImpl")
public class ProductCategoryDaoImpl
extends BaseDaoImpl<ProductCategory, Long>
implements ProductCategoryDao {
    public List<ProductCategory> findRoots(Integer count) {
        String string = "select productCategory from ProductCategory productCategory where productCategory.parent is null order by productCategory.order asc";
        TypedQuery typedQuery = this.IIIllIlI.createQuery(string, ProductCategory.class).setFlushMode(FlushModeType.COMMIT);
        if (count != null) {
            typedQuery.setMaxResults(count.intValue());
        }
        return typedQuery.getResultList();
    }

    public List<ProductCategory> findParents(ProductCategory productCategory, Integer count) {
        if (productCategory == null || productCategory.getParent() == null) {
            return Collections.emptyList();
        }
        String string = "select productCategory from ProductCategory productCategory where productCategory.id in (:ids) order by productCategory.grade asc";
        TypedQuery typedQuery = this.IIIllIlI.createQuery(string, ProductCategory.class).setFlushMode(FlushModeType.COMMIT).setParameter("ids", (Object)productCategory.getTreePaths());
        if (count != null) {
            typedQuery.setMaxResults(count.intValue());
        }
        return typedQuery.getResultList();
    }

    public List<ProductCategory> findChildren(ProductCategory productCategory, Integer count) {
        TypedQuery typedQuery;
        if (productCategory != null) {
            String string = "select productCategory from ProductCategory productCategory where productCategory.treePath like :treePath order by productCategory.order asc";
            typedQuery = this.IIIllIlI.createQuery(string, ProductCategory.class).setFlushMode(FlushModeType.COMMIT).setParameter("treePath", (Object)("%," + productCategory.getId() + "," + "%"));
        } else {
            String string = "select productCategory from ProductCategory productCategory order by productCategory.order asc";
            typedQuery = this.IIIllIlI.createQuery(string, ProductCategory.class).setFlushMode(FlushModeType.COMMIT);
        }
        if (count != null) {
            typedQuery.setMaxResults(count.intValue());
        }
        return this.IIIllIlI(typedQuery.getResultList(), productCategory);
    }

    public void persist(ProductCategory productCategory) {
        Assert.notNull((Object)productCategory);
        this.IIIllIlI(productCategory);
        super.persist((Object)productCategory);
    }

    public ProductCategory merge(ProductCategory productCategory) {
        Assert.notNull((Object)productCategory);
        this.IIIllIlI(productCategory);
        for (ProductCategory productCategory2 : this.findChildren(productCategory, null)) {
            this.IIIllIlI(productCategory2);
        }
        return (ProductCategory)super.merge((Object)productCategory);
    }

    public void remove(ProductCategory productCategory) {
        if (productCategory != null) {
            StringBuffer stringBuffer = new StringBuffer("update Product product set ");
            int n = 0;
            while (n < 20) {
                String string = "attributeValue" + n;
                if (n == 0) {
                    stringBuffer.append("product." + string + " = null");
                } else {
                    stringBuffer.append(", product." + string + " = null");
                }
                ++n;
            }
            stringBuffer.append(" where product.productCategory = :productCategory");
            this.IIIllIlI.createQuery(stringBuffer.toString()).setFlushMode(FlushModeType.COMMIT).setParameter("productCategory", (Object)productCategory).executeUpdate();
            super.remove((Object)productCategory);
        }
    }

    private List<ProductCategory> IIIllIlI(List<ProductCategory> list, ProductCategory productCategory) {
        ArrayList<ProductCategory> arrayList = new ArrayList<ProductCategory>();
        if (list != null) {
            for (ProductCategory productCategory2 : list) {
                if (productCategory2.getParent() != productCategory) continue;
                arrayList.add(productCategory2);
                arrayList.addAll(this.IIIllIlI(list, productCategory2));
            }
        }
        return arrayList;
    }

    private void IIIllIlI(ProductCategory productCategory) {
        if (productCategory == null) {
            return;
        }
        ProductCategory productCategory2 = productCategory.getParent();
        if (productCategory2 != null) {
            productCategory.setTreePath(String.valueOf(productCategory2.getTreePath()) + productCategory2.getId() + ",");
        } else {
            productCategory.setTreePath(",");
        }
        productCategory.setGrade(Integer.valueOf(productCategory.getTreePaths().size()));
    }
}

