/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.Setting;
import net.shopxx.dao.GoodsDao;
import net.shopxx.dao.ProductDao;
import net.shopxx.dao.SnDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.dao.impl.ProductDaoImpl$1;
import net.shopxx.entity.Attribute;
import net.shopxx.entity.Brand;
import net.shopxx.entity.Goods;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order;
import net.shopxx.entity.Product;
import net.shopxx.entity.ProductCategory;
import net.shopxx.entity.Promotion;
import net.shopxx.entity.Sn;
import net.shopxx.entity.SpecificationValue;
import net.shopxx.entity.Tag;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="productDaoImpl")
public class ProductDaoImpl
extends BaseDaoImpl<Product, Long>
implements ProductDao {
    private static final Pattern IIIllIll = Pattern.compile("\\d*");
    @Resource(name="goodsDaoImpl")
    private GoodsDao IIIlllII;
    @Resource(name="snDaoImpl")
    private SnDao IIIlllIl;

    public boolean snExists(String sn) {
        if (sn == null) {
            return false;
        }
        String string = "select count(*) from Product product where lower(product.sn) = lower(:sn)";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("sn", (Object)sn).getSingleResult();
        return l > 0L;
    }

    public Product findBySn(String sn) {
        if (sn == null) {
            return null;
        }
        String string = "select product from Product product where lower(product.sn) = lower(:sn)";
        try {
            return (Product)this.IIIllIlI.createQuery(string, Product.class).setFlushMode(FlushModeType.COMMIT).setParameter("sn", (Object)sn).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public List<Product> search(String keyword, Boolean isGift, Integer count) {
        if (StringUtils.isEmpty((String)keyword)) {
            return Collections.emptyList();
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Product.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = IIIllIll.matcher(keyword).matches() ? criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or(new Predicate[]{criteriaBuilder.equal((Expression)root.get("id"), (Object)Long.valueOf(keyword)), criteriaBuilder.like((Expression)root.get("sn"), "%" + keyword + "%"), criteriaBuilder.like((Expression)root.get("fullName"), "%" + keyword + "%")})) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.like((Expression)root.get("sn"), "%" + keyword + "%"), (Expression)criteriaBuilder.like((Expression)root.get("fullName"), "%" + keyword + "%")));
        if (isGift != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isGift"), (Object)isGift));
        }
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc((Expression)root.get("isTop"))});
        return super.IIIllIlI(criteriaQuery, null, count, null, null);
    }

    public List<Product> findList(ProductCategory productCategory, Brand brand, Promotion promotion, List<Tag> tags, Map<Attribute, String> attributeValue, BigDecimal startPrice, BigDecimal endPrice, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert, Product.OrderType orderType, Integer count, List<Filter> filters, List<Order> orders) {
        String string;
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Product.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (productCategory != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("productCategory"), (Object)productCategory), (Expression)criteriaBuilder.like((Expression)root.get("productCategory").get("treePath"), "%," + productCategory.getId() + "," + "%")));
        }
        if (brand != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("brand"), (Object)brand));
        }
        if (promotion != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or(new Predicate[]{criteriaBuilder.equal((Expression)root.join("promotions", JoinType.LEFT), (Object)promotion), criteriaBuilder.equal((Expression)root.join("productCategory", JoinType.LEFT).join("promotions", JoinType.LEFT), (Object)promotion), criteriaBuilder.equal((Expression)root.join("brand", JoinType.LEFT).join("promotions", JoinType.LEFT), (Object)promotion)}));
        }
        if (attributeValue != null) {
            for (Map.Entry<Attribute, String> object2 : attributeValue.entrySet()) {
                string = "attributeValue" + object2.getKey().getPropertyIndex();
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get(string), (Object)object2.getValue()));
            }
        }
        if (startPrice != null && endPrice != null && ((BigDecimal)startPrice).compareTo((BigDecimal)endPrice) > 0) {
            BigDecimal bigDecimal = startPrice;
            startPrice = endPrice;
            endPrice = bigDecimal;
        }
        if (startPrice != null && ((BigDecimal)startPrice).compareTo(new BigDecimal(0)) >= 0) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.ge((Expression)root.get("price"), (Number)startPrice));
        }
        if (endPrice != null && ((BigDecimal)endPrice).compareTo(new BigDecimal(0)) >= 0) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.le((Expression)root.get("price"), (Number)endPrice));
        }
        if (tags != null && !tags.isEmpty()) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.join("tags").in(tags));
            criteriaQuery.distinct(true);
        }
        if (isMarketable != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isMarketable"), (Object)isMarketable));
        }
        if (isList != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isList"), (Object)isList));
        }
        if (isTop != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isTop"), (Object)isTop));
        }
        if (isGift != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isGift"), (Object)isGift));
        }
        Path path = root.get("stock");
        Path path2 = root.get("allocatedStock");
        if (isOutOfStock != null) {
            predicate = isOutOfStock != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, (Expression)path2)}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, (Expression)path2)));
        }
        if (isStockAlert != null) {
            string = SettingUtils.get();
            predicate = isStockAlert != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, criteriaBuilder.sum((Expression)path2, (Number)string.getStockAlertCount()))}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, criteriaBuilder.sum((Expression)path2, (Number)string.getStockAlertCount()))));
        }
        criteriaQuery.where((Expression)predicate);
        if (orderType == Product.OrderType.priceAsc) {
            orders.add(Order.asc((String)"price"));
            orders.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.priceDesc) {
            orders.add(Order.desc((String)"price"));
            orders.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.salesDesc) {
            orders.add(Order.desc((String)"sales"));
            orders.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.scoreDesc) {
            orders.add(Order.desc((String)"score"));
            orders.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.dateDesc) {
            orders.add(Order.desc((String)"createDate"));
        } else {
            orders.add(Order.desc((String)"isTop"));
            orders.add(Order.desc((String)"modifyDate"));
        }
        return super.IIIllIlI(criteriaQuery, null, count, filters, orders);
    }

    public List<Product> findList(ProductCategory productCategory, Date beginDate, Date endDate, Integer first, Integer count) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Product.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isMarketable"), (Object)true));
        if (productCategory != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("productCategory"), (Object)productCategory), (Expression)criteriaBuilder.like((Expression)root.get("productCategory").get("treePath"), "%," + productCategory.getId() + "," + "%")));
        }
        if (beginDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get("createDate"), (Comparable)endDate));
        }
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc((Expression)root.get("isTop"))});
        return super.IIIllIlI(criteriaQuery, first, count, null, null);
    }

    public List<Product> findList(Goods goods, Set<Product> excludes) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Product.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (goods != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("goods"), (Object)goods));
        }
        if (excludes != null && !excludes.isEmpty()) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.not((Expression)root.in(excludes)));
        }
        criteriaQuery.where((Expression)predicate);
        return this.IIIllIlI.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
    }

    public Page<Product> findPage(ProductCategory productCategory, Brand brand, Promotion promotion, List<Tag> tags, Map<Attribute, String> attributeValue, BigDecimal startPrice, BigDecimal endPrice, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert, Product.OrderType orderType, Pageable pageable) {
        Object object;
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Product.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (productCategory != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("productCategory"), (Object)productCategory), (Expression)criteriaBuilder.like((Expression)root.get("productCategory").get("treePath"), "%," + productCategory.getId() + "," + "%")));
        }
        if (brand != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("brand"), (Object)brand));
        }
        if (promotion != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or(new Predicate[]{criteriaBuilder.equal((Expression)root.join("promotions", JoinType.LEFT), (Object)promotion), criteriaBuilder.equal((Expression)root.join("productCategory", JoinType.LEFT).join("promotions", JoinType.LEFT), (Object)promotion), criteriaBuilder.equal((Expression)root.join("brand", JoinType.LEFT).join("promotions", JoinType.LEFT), (Object)promotion)}));
        }
        if (tags != null && !tags.isEmpty()) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)root.join("tags").in(tags));
            criteriaQuery.distinct(true);
        }
        if (attributeValue != null) {
            for (Map.Entry<Attribute, String> object22 : attributeValue.entrySet()) {
                object = "attributeValue" + object22.getKey().getPropertyIndex();
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get((String)object), (Object)object22.getValue()));
            }
        }
        if (startPrice != null && endPrice != null && ((BigDecimal)startPrice).compareTo((BigDecimal)endPrice) > 0) {
            BigDecimal bigDecimal = startPrice;
            startPrice = endPrice;
            endPrice = bigDecimal;
        }
        if (startPrice != null && ((BigDecimal)startPrice).compareTo(new BigDecimal(0)) >= 0) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.ge((Expression)root.get("price"), (Number)startPrice));
        }
        if (endPrice != null && ((BigDecimal)endPrice).compareTo(new BigDecimal(0)) >= 0) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.le((Expression)root.get("price"), (Number)endPrice));
        }
        if (isMarketable != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isMarketable"), (Object)isMarketable));
        }
        if (isList != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isList"), (Object)isList));
        }
        if (isTop != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isTop"), (Object)isTop));
        }
        if (isGift != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isGift"), (Object)isGift));
        }
        Path path = root.get("stock");
        Path path2 = root.get("allocatedStock");
        if (isOutOfStock != null) {
            predicate = isOutOfStock != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, (Expression)path2)}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, (Expression)path2)));
        }
        if (isStockAlert != null) {
            object = SettingUtils.get();
            predicate = isStockAlert != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, criteriaBuilder.sum((Expression)path2, (Number)object.getStockAlertCount()))}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, criteriaBuilder.sum((Expression)path2, (Number)object.getStockAlertCount()))));
        }
        criteriaQuery.where((Expression)predicate);
        object = pageable.getOrders();
        if (orderType == Product.OrderType.priceAsc) {
            object.add(Order.asc((String)"price"));
            object.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.priceDesc) {
            object.add(Order.desc((String)"price"));
            object.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.salesDesc) {
            object.add(Order.desc((String)"sales"));
            object.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.scoreDesc) {
            object.add(Order.desc((String)"score"));
            object.add(Order.desc((String)"createDate"));
        } else if (orderType == Product.OrderType.dateDesc) {
            object.add(Order.desc((String)"createDate"));
        } else {
            object.add(Order.desc((String)"isTop"));
            object.add(Order.desc((String)"modifyDate"));
        }
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public Page<Product> findPage(Member member, Pageable pageable) {
        if (member == null) {
            return new Page(Collections.emptyList(), 0L, pageable);
        }
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Product.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.join("favoriteMembers"), (Object)member));
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public Page<Object> findSalesPage(Date beginDate, Date endDate, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Object.class);
        Root root = criteriaQuery.from(Product.class);
        Join join = root.join("orderItems");
        Join join2 = join.join("order");
        criteriaQuery.multiselect(new Selection[]{root, criteriaBuilder.sum((Expression)join.get("quantity")), criteriaBuilder.sum(criteriaBuilder.prod((Expression)join.get("quantity"), (Expression)join.get("price")))});
        Predicate predicate = criteriaBuilder.conjunction();
        if (beginDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)join.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)join.get("createDate"), (Comparable)endDate));
        }
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)join2.get("orderStatus"), (Object)Order.OrderStatus.completed));
        predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)join2.get("paymentStatus"), (Object)Order.PaymentStatus.paid));
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.groupBy(new Expression[]{root.get("id")});
        CriteriaQuery criteriaQuery2 = criteriaBuilder.createQuery(Long.class);
        Root root2 = criteriaQuery2.from(Product.class);
        Join join3 = root2.join("orderItems");
        Join join4 = join3.join("order");
        Predicate predicate2 = criteriaBuilder.conjunction();
        if (beginDate != null) {
            predicate2 = criteriaBuilder.and((Expression)predicate2, (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)join3.get("createDate"), (Comparable)beginDate));
        }
        if (endDate != null) {
            predicate2 = criteriaBuilder.and((Expression)predicate2, (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)join3.get("createDate"), (Comparable)endDate));
        }
        predicate2 = criteriaBuilder.and((Expression)predicate2, (Expression)criteriaBuilder.equal((Expression)join4.get("orderStatus"), (Object)Order.OrderStatus.completed));
        criteriaQuery2.select((Selection)criteriaBuilder.countDistinct((Expression)root2));
        criteriaQuery2.where((Expression)predicate2);
        Long l = (Long)this.IIIllIlI.createQuery(criteriaQuery2).setFlushMode(FlushModeType.COMMIT).getSingleResult();
        int n = (int)Math.ceil((double)l.longValue() / (double)pageable.getPageSize());
        if (n < pageable.getPageNumber()) {
            pageable.setPageNumber(n);
        }
        criteriaQuery.orderBy(new javax.persistence.criteria.Order[]{criteriaBuilder.desc(criteriaBuilder.sum(criteriaBuilder.prod((Expression)join.get("quantity"), (Expression)join.get("price"))))});
        TypedQuery typedQuery = this.IIIllIlI.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
        typedQuery.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize());
        typedQuery.setMaxResults(pageable.getPageSize());
        return new Page(typedQuery.getResultList(), l.longValue(), pageable);
    }

    public Long count(Member favoriteMember, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Product.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (favoriteMember != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.join("favoriteMembers"), (Object)favoriteMember));
        }
        if (isMarketable != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isMarketable"), (Object)isMarketable));
        }
        if (isList != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isList"), (Object)isList));
        }
        if (isTop != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isTop"), (Object)isTop));
        }
        if (isGift != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isGift"), (Object)isGift));
        }
        Path path = root.get("stock");
        Path path2 = root.get("allocatedStock");
        if (isOutOfStock != null) {
            predicate = isOutOfStock != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, (Expression)path2)}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, (Expression)path2)));
        }
        if (isStockAlert != null) {
            Setting setting = SettingUtils.get();
            predicate = isStockAlert != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, criteriaBuilder.sum((Expression)path2, (Number)setting.getStockAlertCount()))}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, criteriaBuilder.sum((Expression)path2, (Number)setting.getStockAlertCount()))));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null);
    }

    public boolean isPurchased(Member member, Product product) {
        if (member == null || product == null) {
            return false;
        }
        String string = "select count(*) from OrderItem orderItem where orderItem.product = :product and orderItem.order.member = :member and orderItem.order.orderStatus = :orderStatus";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("product", (Object)product).setParameter("member", (Object)member).setParameter("orderStatus", (Object)Order.OrderStatus.completed).getSingleResult();
        return l > 0L;
    }

    public void persist(Product product) {
        Assert.notNull((Object)product);
        this.IIIllIlI(product);
        super.persist((Object)product);
    }

    public Product merge(Product product) {
        String string;
        Assert.notNull((Object)product);
        if (!product.getIsGift().booleanValue()) {
            string = "delete from GiftItem giftItem where giftItem.gift = :product";
            this.IIIllIlI.createQuery(string).setFlushMode(FlushModeType.COMMIT).setParameter("product", (Object)product).executeUpdate();
        }
        if (!product.getIsMarketable().booleanValue() || product.getIsGift().booleanValue()) {
            string = "delete from CartItem cartItem where cartItem.product = :product";
            this.IIIllIlI.createQuery(string).setFlushMode(FlushModeType.COMMIT).setParameter("product", (Object)product).executeUpdate();
        }
        this.IIIllIlI(product);
        return (Product)super.merge((Object)product);
    }

    public void remove(Product product) {
        Goods goods;
        if (product != null && (goods = product.getGoods()) != null && goods.getProducts() != null) {
            goods.getProducts().remove(product);
            if (goods.getProducts().isEmpty()) {
                this.IIIlllII.remove((Object)goods);
            }
        }
        super.remove((Object)product);
    }

    private void IIIllIlI(Product product) {
        CharSequence charSequence;
        if (product == null) {
            return;
        }
        if (StringUtils.isEmpty((String)product.getSn())) {
            while (this.snExists((String)(charSequence = this.IIIlllIl.generate(Sn.Type.product)))) {
            }
            product.setSn((String)charSequence);
        }
        charSequence = new StringBuffer(product.getName());
        if (product.getSpecificationValues() != null && !product.getSpecificationValues().isEmpty()) {
            ArrayList arrayList = new ArrayList(product.getSpecificationValues());
            Collections.sort(arrayList, new ProductDaoImpl$1(this));
            ((StringBuffer)charSequence).append("[");
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n != 0) {
                    ((StringBuffer)charSequence).append(" ");
                }
                ((StringBuffer)charSequence).append(((SpecificationValue)iterator.next()).getName());
                ++n;
            }
            ((StringBuffer)charSequence).append("]");
        }
        product.setFullName(((StringBuffer)charSequence).toString());
    }
}

