/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import javax.persistence.FlushModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.ProductNotifyDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.entity.ProductNotify;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="productNotifyDaoImpl")
public class ProductNotifyDaoImpl
extends BaseDaoImpl<ProductNotify, Long>
implements ProductNotifyDao {
    public boolean exists(Product product, String email) {
        String string = "select count(*) from ProductNotify productNotify where productNotify.product = :product and lower(productNotify.email) = lower(:email) and productNotify.hasSent = false";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("product", (Object)product).setParameter("email", (Object)email).getSingleResult();
        return l > 0L;
    }

    public Page<ProductNotify> findPage(Member member, Boolean isMarketable, Boolean isOutOfStock, Boolean hasSent, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(ProductNotify.class);
        Root root = criteriaQuery.from(ProductNotify.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        if (isMarketable != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("product").get("isMarketable"), (Object)isMarketable));
        }
        if (isOutOfStock != null) {
            Path path = root.get("product").get("stock");
            Path path2 = root.get("product").get("allocatedStock");
            predicate = isOutOfStock != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, (Expression)path2)}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, (Expression)path2)));
        }
        if (hasSent != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("hasSent"), (Object)hasSent));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public Long count(Member member, Boolean isMarketable, Boolean isOutOfStock, Boolean hasSent) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(ProductNotify.class);
        Root root = criteriaQuery.from(ProductNotify.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        if (isMarketable != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("product").get("isMarketable"), (Object)isMarketable));
        }
        if (isOutOfStock != null) {
            Path path = root.get("product").get("stock");
            Path path2 = root.get("product").get("allocatedStock");
            predicate = isOutOfStock != false ? criteriaBuilder.and(new Predicate[]{predicate, criteriaBuilder.isNotNull((Expression)path), criteriaBuilder.lessThanOrEqualTo((Expression)path, (Expression)path2)}) : criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)path), (Expression)criteriaBuilder.greaterThan((Expression)path, (Expression)path2)));
        }
        if (hasSent != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("hasSent"), (Object)hasSent));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null);
    }
}

