/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.ReceiverDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.Member;
import net.shopxx.entity.Receiver;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="receiverDaoImpl")
public class ReceiverDaoImpl
extends BaseDaoImpl<Receiver, Long>
implements ReceiverDao {
    public Receiver findDefault(Member member) {
        if (member == null) {
            return null;
        }
        try {
            String string = "select receiver from Receiver receiver where receiver.member = :member and receiver.isDefault = true";
            return (Receiver)this.IIIllIlI.createQuery(string, Receiver.class).setFlushMode(FlushModeType.COMMIT).setParameter("member", (Object)member).getSingleResult();
        }
        catch (NoResultException noResultException) {
            try {
                String string = "select receiver from Receiver receiver where receiver.member = :member order by receiver.modifyDate desc";
                return (Receiver)this.IIIllIlI.createQuery(string, Receiver.class).setFlushMode(FlushModeType.COMMIT).setParameter("member", (Object)member).setMaxResults(1).getSingleResult();
            }
            catch (NoResultException noResultException2) {
                return null;
            }
        }
    }

    public Page<Receiver> findPage(Member member, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Receiver.class);
        Root root = criteriaQuery.from(Receiver.class);
        criteriaQuery.select((Selection)root);
        if (member != null) {
            criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public void persist(Receiver receiver) {
        Assert.notNull((Object)receiver);
        Assert.notNull((Object)receiver.getMember());
        if (receiver.getIsDefault().booleanValue()) {
            String string = "update Receiver receiver set receiver.isDefault = false where receiver.member = :member and receiver.isDefault = true";
            this.IIIllIlI.createQuery(string).setFlushMode(FlushModeType.COMMIT).setParameter("member", (Object)receiver.getMember()).executeUpdate();
        }
        super.persist((Object)receiver);
    }

    public Receiver merge(Receiver receiver) {
        Assert.notNull((Object)receiver);
        Assert.notNull((Object)receiver.getMember());
        if (receiver.getIsDefault().booleanValue()) {
            String string = "update Receiver receiver set receiver.isDefault = false where receiver.member = :member and receiver.isDefault = true and receiver != :receiver";
            this.IIIllIlI.createQuery(string).setFlushMode(FlushModeType.COMMIT).setParameter("member", (Object)receiver.getMember()).setParameter("receiver", (Object)receiver).executeUpdate();
        }
        return (Receiver)super.merge((Object)receiver);
    }
}

