/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.dao.impl;

import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.ReviewDao;
import net.shopxx.dao.impl.BaseDaoImpl;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.entity.Review;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="reviewDaoImpl")
public class ReviewDaoImpl
extends BaseDaoImpl<Review, Long>
implements ReviewDao {
    public List<Review> findList(Member member, Product product, Review.Type type, Boolean isShow, Integer count, List<Filter> filters, List<Order> orders) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Review.class);
        Root root = criteriaQuery.from(Review.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        if (product != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("product"), (Object)product));
        }
        if (type == Review.Type.positive) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.ge((Expression)root.get("score"), (Number)4));
        } else if (type == Review.Type.moderate) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("score"), (Object)3));
        } else if (type == Review.Type.negative) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.le((Expression)root.get("score"), (Number)2));
        }
        if (isShow != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isShow"), (Object)isShow));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null, count, filters, orders);
    }

    public Page<Review> findPage(Member member, Product product, Review.Type type, Boolean isShow, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Review.class);
        Root root = criteriaQuery.from(Review.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        if (product != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("product"), (Object)product));
        }
        if (type == Review.Type.positive) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.ge((Expression)root.get("score"), (Number)4));
        } else if (type == Review.Type.moderate) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("score"), (Object)3));
        } else if (type == Review.Type.negative) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.le((Expression)root.get("score"), (Number)2));
        }
        if (isShow != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isShow"), (Object)isShow));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, pageable);
    }

    public Long count(Member member, Product product, Review.Type type, Boolean isShow) {
        CriteriaBuilder criteriaBuilder = this.IIIllIlI.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Review.class);
        Root root = criteriaQuery.from(Review.class);
        criteriaQuery.select((Selection)root);
        Predicate predicate = criteriaBuilder.conjunction();
        if (member != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("member"), (Object)member));
        }
        if (product != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("product"), (Object)product));
        }
        if (type == Review.Type.positive) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.ge((Expression)root.get("score"), (Number)4));
        } else if (type == Review.Type.moderate) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("score"), (Object)3));
        } else if (type == Review.Type.negative) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.le((Expression)root.get("score"), (Number)2));
        }
        if (isShow != null) {
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("isShow"), (Object)isShow));
        }
        criteriaQuery.where((Expression)predicate);
        return super.IIIllIlI(criteriaQuery, null);
    }

    public boolean isReviewed(Member member, Product product) {
        if (member == null || product == null) {
            return false;
        }
        String string = "select count(*) from Review review where review.member = :member and review.product = :product";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("member", (Object)member).setParameter("product", (Object)product).getSingleResult();
        return l > 0L;
    }

    public long calculateTotalScore(Product product) {
        if (product == null) {
            return 0L;
        }
        String string = "select sum(review.score) from Review review where review.product = :product and review.isShow = :isShow";
        Long l = (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("product", (Object)product).setParameter("isShow", (Object)true).getSingleResult();
        return l != null ? l : 0L;
    }

    public long calculateScoreCount(Product product) {
        if (product == null) {
            return 0L;
        }
        String string = "select count(*) from Review review where review.product = :product and review.isShow = :isShow";
        return (Long)this.IIIllIlI.createQuery(string, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("product", (Object)product).setParameter("isShow", (Object)true).getSingleResult();
    }
}

