/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import net.shopxx.entity.DeliveryCenter;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order;
import net.shopxx.entity.OrderEntity;
import net.shopxx.entity.Receiver;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="xx_area")
public class Area
extends OrderEntity {
    private static final long serialVersionUID = -2158109459123036967L;
    private static final String IIIllIlI = ",";
    private String IIIllIll;
    private String IIIlllII;
    private String IIIlllIl;
    private Area IIIllllI;
    private Set<Area> IIIlllll = new HashSet();
    private Set<Member> IIlIIIII = new HashSet();
    private Set<Receiver> IIlIIIIl = new HashSet();
    private Set<Order> IIlIIIlI = new HashSet();
    private Set<DeliveryCenter> IIlIIIll = new HashSet();

    @NotEmpty
    @Length(max=100)
    @Column(nullable=false, length=100)
    public String getName() {
        return this.IIIllIll;
    }

    public void setName(String name) {
        this.IIIllIll = name;
    }

    @Column(nullable=false, length=500)
    public String getFullName() {
        return this.IIIlllII;
    }

    public void setFullName(String fullName) {
        this.IIIlllII = fullName;
    }

    @Column(nullable=false, updatable=false)
    public String getTreePath() {
        return this.IIIlllIl;
    }

    public void setTreePath(String treePath) {
        this.IIIlllIl = treePath;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Area getParent() {
        return this.IIIllllI;
    }

    public void setParent(Area parent) {
        this.IIIllllI = parent;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="order asc")
    public Set<Area> getChildren() {
        return this.IIIlllll;
    }

    public void setChildren(Set<Area> children) {
        this.IIIlllll = children;
    }

    @OneToMany(mappedBy="area", fetch=FetchType.LAZY)
    public Set<Member> getMembers() {
        return this.IIlIIIII;
    }

    public void setMembers(Set<Member> members) {
        this.IIlIIIII = members;
    }

    @OneToMany(mappedBy="area", fetch=FetchType.LAZY)
    public Set<Receiver> getReceivers() {
        return this.IIlIIIIl;
    }

    public void setReceivers(Set<Receiver> receivers) {
        this.IIlIIIIl = receivers;
    }

    @OneToMany(mappedBy="area", fetch=FetchType.LAZY)
    public Set<Order> getOrders() {
        return this.IIlIIIlI;
    }

    public void setOrders(Set<Order> orders) {
        this.IIlIIIlI = orders;
    }

    @OneToMany(mappedBy="area", fetch=FetchType.LAZY)
    public Set<DeliveryCenter> getDeliveryCenters() {
        return this.IIlIIIll;
    }

    public void setDeliveryCenters(Set<DeliveryCenter> deliveryCenters) {
        this.IIlIIIll = deliveryCenters;
    }

    @PrePersist
    public void prePersist() {
        Area area = this.getParent();
        if (area != null) {
            this.setFullName(String.valueOf(area.getFullName()) + this.getName());
            this.setTreePath(String.valueOf(area.getTreePath()) + area.getId() + IIIllIlI);
        } else {
            this.setFullName(this.getName());
            this.setTreePath(IIIllIlI);
        }
    }

    @PreUpdate
    public void preUpdate() {
        Area area = this.getParent();
        if (area != null) {
            this.setFullName(String.valueOf(area.getFullName()) + this.getName());
        } else {
            this.setFullName(this.getName());
        }
    }

    @PreRemove
    public void preRemove() {
        DeliveryCenter deliveryCenter;
        Object object;
        Set set;
        Object object2;
        Set set2 = this.getMembers();
        if (set2 != null) {
            object2 = set2.iterator();
            while (object2.hasNext()) {
                set = (Member)object2.next();
                set.setArea(null);
            }
        }
        if ((set = this.getReceivers()) != null) {
            object = set.iterator();
            while (object.hasNext()) {
                object2 = (Receiver)object.next();
                object2.setArea(null);
            }
        }
        if ((object2 = this.getOrders()) != null) {
            deliveryCenter = object2.iterator();
            while (deliveryCenter.hasNext()) {
                object = (Order)deliveryCenter.next();
                object.setArea(null);
            }
        }
        if ((object = this.getDeliveryCenters()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                deliveryCenter = (DeliveryCenter)iterator.next();
                deliveryCenter.setArea(null);
            }
        }
    }

    public String toString() {
        return this.getFullName();
    }
}

