/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import net.shopxx.entity.ArticleCategory;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Tag;
import net.shopxx.util.FreemarkerUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.io.SAXReader;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.springframework.core.io.ClassPathResource;
import org.wltea.analyzer.lucene.IKAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Indexed
@Entity
@Table(name="xx_article")
public class Article
extends BaseEntity {
    private static final long serialVersionUID = 1475773294701585482L;
    public static final String HITS_CACHE_NAME = "articleHits";
    public static final int HITS_CACHE_INTERVAL = 600000;
    private static final int IIIllIlI = 800;
    private static final String IIIllIll = "<hr class=\"pageBreak\" />";
    private static final Pattern IIIlllII = Pattern.compile("[,;\\.!?\uff0c\uff1b\u3002\uff01\uff1f]");
    private static String IIIlllIl;
    private String IIIllllI;
    private String IIIlllll;
    private String IIlIIIII;
    private String IIlIIIIl;
    private String IIlIIIlI;
    private String IIlIIIll;
    private Boolean IIlIIlII;
    private Boolean IIlIIlIl;
    private Long IIlIIllI;
    private Integer IIlIIlll;
    private ArticleCategory IIlIlIII;
    private Set<Tag> IIlIlIIl = new HashSet();

    static {
        try {
            File file = new ClassPathResource("/shopxx.xml").getFile();
            org.dom4j.Document document = new SAXReader().read(file);
            org.dom4j.Element element = (org.dom4j.Element)document.selectSingleNode("/shopxx/template[@id='articleContent']");
            IIIlllIl = element.attributeValue("staticPath");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Field(store=Store.YES, index=Index.TOKENIZED, analyzer=@Analyzer(impl=IKAnalyzer.class))
    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getTitle() {
        return this.IIIllllI;
    }

    public void setTitle(String title) {
        this.IIIllllI = title;
    }

    @Field(store=Store.YES, index=Index.NO)
    @Length(max=200)
    public String getAuthor() {
        return this.IIIlllll;
    }

    public void setAuthor(String author) {
        this.IIIlllll = author;
    }

    @Field(store=Store.YES, index=Index.TOKENIZED, analyzer=@Analyzer(impl=IKAnalyzer.class))
    @Lob
    public String getContent() {
        if (this.IIlIIlll != null) {
            String[] stringArray = this.getPageContents();
            if (this.IIlIIlll < 1) {
                this.IIlIIlll = 1;
            }
            if (this.IIlIIlll > stringArray.length) {
                this.IIlIIlll = stringArray.length;
            }
            return stringArray[this.IIlIIlll - 1];
        }
        return this.IIlIIIII;
    }

    public void setContent(String content) {
        this.IIlIIIII = content;
    }

    @Length(max=200)
    public String getSeoTitle() {
        return this.IIlIIIIl;
    }

    public void setSeoTitle(String seoTitle) {
        this.IIlIIIIl = seoTitle;
    }

    @Length(max=200)
    public String getSeoKeywords() {
        return this.IIlIIIlI;
    }

    public void setSeoKeywords(String seoKeywords) {
        if (seoKeywords != null) {
            seoKeywords = seoKeywords.replaceAll("[,\\s]*,[,\\s]*", ",").replaceAll("^,|,$", "");
        }
        this.IIlIIIlI = seoKeywords;
    }

    @Length(max=200)
    public String getSeoDescription() {
        return this.IIlIIIll;
    }

    public void setSeoDescription(String seoDescription) {
        this.IIlIIIll = seoDescription;
    }

    @Field(store=Store.YES, index=Index.UN_TOKENIZED)
    @NotNull
    @Column(nullable=false)
    public Boolean getIsPublication() {
        return this.IIlIIlII;
    }

    public void setIsPublication(Boolean isPublication) {
        this.IIlIIlII = isPublication;
    }

    @Field(store=Store.YES, index=Index.UN_TOKENIZED)
    @NotNull
    @Column(nullable=false)
    public Boolean getIsTop() {
        return this.IIlIIlIl;
    }

    public void setIsTop(Boolean isTop) {
        this.IIlIIlIl = isTop;
    }

    @Column(nullable=false)
    public Long getHits() {
        return this.IIlIIllI;
    }

    public void setHits(Long hits) {
        this.IIlIIllI = hits;
    }

    @Transient
    public Integer getPageNumber() {
        return this.IIlIIlll;
    }

    @Transient
    public void setPageNumber(Integer pageNumber) {
        this.IIlIIlll = pageNumber;
    }

    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false)
    public ArticleCategory getArticleCategory() {
        return this.IIlIlIII;
    }

    public void setArticleCategory(ArticleCategory articleCategory) {
        this.IIlIlIII = articleCategory;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_article_tag")
    @OrderBy(value="order asc")
    public Set<Tag> getTags() {
        return this.IIlIlIIl;
    }

    public void setTags(Set<Tag> tags) {
        this.IIlIlIIl = tags;
    }

    @Transient
    public String getPath() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", this.getId());
        hashMap.put("createDate", this.getCreateDate());
        hashMap.put("modifyDate", this.getModifyDate());
        hashMap.put("title", this.getTitle());
        hashMap.put("seoTitle", this.getSeoTitle());
        hashMap.put("seoKeywords", this.getSeoKeywords());
        hashMap.put("seoDescription", this.getSeoDescription());
        hashMap.put("pageNumber", this.getPageNumber());
        hashMap.put("articleCategory", this.getArticleCategory());
        return FreemarkerUtils.process((String)IIIlllIl, hashMap);
    }

    @Transient
    public String getText() {
        if (this.getContent() != null) {
            return Jsoup.parse((String)this.getContent()).text();
        }
        return null;
    }

    @Transient
    public String[] getPageContents() {
        if (StringUtils.isEmpty((String)this.IIlIIIII)) {
            return new String[]{""};
        }
        if (this.IIlIIIII.contains(IIIllIll)) {
            return this.IIlIIIII.split(IIIllIll);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Document document = Jsoup.parse((String)this.IIlIIIII);
        List list = document.body().childNodes();
        if (list != null) {
            String string2;
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : list) {
                Element element;
                if (string2 instanceof Element) {
                    element = (Element)string2;
                    stringBuffer.append(element.outerHtml());
                    if ((n += element.text().length()) < 800) continue;
                    arrayList.add(stringBuffer.toString());
                    n = 0;
                    stringBuffer.setLength(0);
                    continue;
                }
                if (!(string2 instanceof TextNode)) continue;
                element = (TextNode)string2;
                String string3 = element.text();
                String[] stringArray = IIIlllII.split(string3);
                Matcher matcher = IIIlllII.matcher(string3);
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string4 = stringArray2[n3];
                    if (matcher.find()) {
                        string4 = String.valueOf(string4) + matcher.group();
                    }
                    stringBuffer.append(string4);
                    if ((n += string4.length()) >= 800) {
                        arrayList.add(stringBuffer.toString());
                        n = 0;
                        stringBuffer.setLength(0);
                    }
                    ++n3;
                }
            }
            string2 = stringBuffer.toString();
            if (StringUtils.isNotEmpty((String)string2)) {
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Transient
    public int getTotalPages() {
        return this.getPageContents().length;
    }
}

