/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.shopxx.Setting;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Cart$1;
import net.shopxx.entity.CartItem;
import net.shopxx.entity.Coupon;
import net.shopxx.entity.GiftItem;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.entity.Promotion;
import net.shopxx.util.SettingUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="xx_cart")
public class Cart
extends BaseEntity {
    private static final long serialVersionUID = -6565967051825794561L;
    public static final int TIMEOUT = 604800;
    public static final Integer MAX_PRODUCT_COUNT = 100;
    public static final String ID_COOKIE_NAME = "cartId";
    public static final String KEY_COOKIE_NAME = "cartKey";
    private String IIIllIlI;
    private Member IIIllIll;
    private Set<CartItem> IIIlllII = new HashSet();

    @Column(name="cart_key", nullable=false, updatable=false)
    public String getKey() {
        return this.IIIllIlI;
    }

    public void setKey(String key) {
        this.IIIllIlI = key;
    }

    @OneToOne(fetch=FetchType.LAZY)
    public Member getMember() {
        return this.IIIllIll;
    }

    public void setMember(Member member) {
        this.IIIllIll = member;
    }

    @OneToMany(mappedBy="cart", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    public Set<CartItem> getCartItems() {
        return this.IIIlllII;
    }

    public void setCartItems(Set<CartItem> cartItems) {
        this.IIIlllII = cartItems;
    }

    @Transient
    public int getPoint() {
        int n = 0;
        if (this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                if (cartItem == null) continue;
                n = (int)((long)n + cartItem.getPoint());
            }
        }
        for (CartItem cartItem : this.getPromotions()) {
            n = cartItem.calculatePoint(Integer.valueOf(n));
        }
        return n;
    }

    @Transient
    public int getWeight() {
        int n = 0;
        if (this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                if (cartItem == null) continue;
                n += cartItem.getWeight();
            }
        }
        return n;
    }

    @Transient
    public int getQuantity() {
        int n = 0;
        if (this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                if (cartItem == null || cartItem.getQuantity() == null) continue;
                n += cartItem.getQuantity().intValue();
            }
        }
        return n;
    }

    @Transient
    public BigDecimal getPrice() {
        BigDecimal bigDecimal = new BigDecimal(0);
        if (this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                if (cartItem == null || cartItem.getSubtotal() == null) continue;
                bigDecimal = bigDecimal.add(cartItem.getSubtotal());
            }
        }
        return bigDecimal;
    }

    @Transient
    public BigDecimal getAmount() {
        Setting setting = SettingUtils.get();
        BigDecimal bigDecimal = this.getPrice();
        for (Promotion promotion : this.getPromotions()) {
            bigDecimal = promotion.calculatePrice(bigDecimal);
        }
        return setting.setScale(bigDecimal);
    }

    @Transient
    public BigDecimal getDiscount() {
        BigDecimal bigDecimal = this.getPrice().subtract(this.getAmount());
        return bigDecimal.compareTo(new BigDecimal(0)) > 0 ? bigDecimal : new BigDecimal(0);
    }

    @Transient
    public Set<GiftItem> getGiftItems() {
        HashSet<GiftItem> hashSet = new HashSet<GiftItem>();
        for (Promotion promotion : this.getPromotions()) {
            if (promotion.getGiftItems() == null) continue;
            for (GiftItem giftItem : promotion.getGiftItems()) {
                GiftItem giftItem2 = (GiftItem)CollectionUtils.find(hashSet, (Predicate)new Cart$1(this, giftItem));
                if (giftItem2 != null) {
                    giftItem2.setQuantity(Integer.valueOf(giftItem2.getQuantity() + giftItem.getQuantity()));
                    continue;
                }
                hashSet.add(giftItem);
            }
        }
        return hashSet;
    }

    @Transient
    public Set<Promotion> getPromotions() {
        CartItem cartItem2;
        HashSet hashSet = new HashSet();
        if (this.getCartItems() != null) {
            for (CartItem cartItem2 : this.getCartItems()) {
                if (cartItem2 == null || cartItem2.getProduct() == null) continue;
                hashSet.addAll(cartItem2.getProduct().getValidPromotions());
            }
        }
        cartItem2 = new TreeSet();
        for (Promotion promotion : hashSet) {
            if (!this.IIIllIlI(promotion)) continue;
            cartItem2.add(promotion);
        }
        return cartItem2;
    }

    @Transient
    private boolean IIIllIlI(Promotion promotion) {
        if (promotion == null || !promotion.hasBegun() || promotion.hasEnded()) {
            return false;
        }
        if (promotion.getMemberRanks() == null || this.getMember() == null || this.getMember().getMemberRank() == null || !promotion.getMemberRanks().contains(this.getMember().getMemberRank())) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        if (this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                Product product;
                if (cartItem == null || (product = cartItem.getProduct()) == null) continue;
                if (product.getPromotions() != null && product.getPromotions().contains(promotion)) {
                    bigDecimal = bigDecimal.add(cartItem.getSubtotal());
                    continue;
                }
                if (product.getProductCategory() != null && product.getProductCategory().getPromotions().contains(promotion)) {
                    bigDecimal = bigDecimal.add(cartItem.getSubtotal());
                    continue;
                }
                if (product.getBrand() == null || !product.getBrand().getPromotions().contains(promotion)) continue;
                bigDecimal = bigDecimal.add(cartItem.getSubtotal());
            }
        }
        return (promotion.getStartPrice() == null || promotion.getStartPrice().compareTo(bigDecimal) <= 0) && (promotion.getEndPrice() == null || promotion.getEndPrice().compareTo(bigDecimal) >= 0);
    }

    @Transient
    public boolean isValid(Coupon coupon) {
        if (coupon == null || !coupon.getIsEnabled().booleanValue() || !coupon.hasBegun() || coupon.hasExpired()) {
            return false;
        }
        return (coupon.getStartPrice() == null || coupon.getStartPrice().compareTo(this.getAmount()) <= 0) && (coupon.getEndPrice() == null || coupon.getEndPrice().compareTo(this.getAmount()) >= 0);
    }

    @Transient
    public CartItem getCartItem(Product product) {
        if (product != null && this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                if (cartItem == null || cartItem.getProduct() != product) continue;
                return cartItem;
            }
        }
        return null;
    }

    @Transient
    public boolean contains(Product product) {
        if (product != null && this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                if (cartItem == null || cartItem.getProduct() != product) continue;
                return true;
            }
        }
        return false;
    }

    @Transient
    public String getToken() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 37).append((Object)this.getKey());
        if (this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                hashCodeBuilder.append((Object)cartItem.getProduct()).append((Object)cartItem.getQuantity()).append((Object)cartItem.getUnitPrice());
            }
        }
        return DigestUtils.md5Hex((String)hashCodeBuilder.toString());
    }

    @Transient
    public boolean getIsLowStock() {
        if (this.getCartItems() != null) {
            for (CartItem cartItem : this.getCartItems()) {
                if (cartItem == null || !cartItem.getIsLowStock()) continue;
                return true;
            }
        }
        return false;
    }

    @Transient
    public boolean hasExpired() {
        return new Date().after(DateUtils.addSeconds((Date)this.getModifyDate(), (int)604800));
    }

    @Transient
    public boolean isCouponAllowed() {
        for (Promotion promotion : this.getPromotions()) {
            if (promotion == null || promotion.getIsCouponAllowed().booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Transient
    public boolean isEmpty() {
        return this.getCartItems() == null || this.getCartItems().isEmpty();
    }
}

