/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.math.BigDecimal;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.shopxx.Setting;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Cart;
import net.shopxx.entity.MemberRank;
import net.shopxx.entity.Product;
import net.shopxx.util.SettingUtils;

@Entity
@Table(name="xx_cart_item")
public class CartItem
extends BaseEntity {
    private static final long serialVersionUID = 2979296789363163144L;
    public static final Integer MAX_QUANTITY = 10000;
    private Integer IIIllIlI;
    private Product IIIllIll;
    private Cart IIIlllII;

    @Column(nullable=false)
    public Integer getQuantity() {
        return this.IIIllIlI;
    }

    public void setQuantity(Integer quantity) {
        this.IIIllIlI = quantity;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, updatable=false)
    public Product getProduct() {
        return this.IIIllIll;
    }

    public void setProduct(Product product) {
        this.IIIllIll = product;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false)
    public Cart getCart() {
        return this.IIIlllII;
    }

    public void setCart(Cart cart) {
        this.IIIlllII = cart;
    }

    @Transient
    public long getPoint() {
        if (this.getProduct() != null && this.getProduct().getPoint() != null && this.getQuantity() != null) {
            return this.getProduct().getPoint() * (long)this.getQuantity().intValue();
        }
        return 0L;
    }

    @Transient
    public int getWeight() {
        if (this.getProduct() != null && this.getProduct().getWeight() != null && this.getQuantity() != null) {
            return this.getProduct().getWeight() * this.getQuantity();
        }
        return 0;
    }

    @Transient
    public BigDecimal getUnitPrice() {
        if (this.getProduct() != null && this.getProduct().getPrice() != null) {
            Setting setting = SettingUtils.get();
            if (this.getCart() != null && this.getCart().getMember() != null && this.getCart().getMember().getMemberRank() != null) {
                MemberRank memberRank = this.getCart().getMember().getMemberRank();
                Map map = this.getProduct().getMemberPrice();
                if (map != null && !map.isEmpty() && map.containsKey(memberRank)) {
                    return setting.setScale((BigDecimal)map.get(memberRank));
                }
                if (memberRank.getScale() != null) {
                    return setting.setScale(this.getProduct().getPrice().multiply(new BigDecimal(memberRank.getScale())));
                }
            }
            return setting.setScale(this.getProduct().getPrice());
        }
        return new BigDecimal(0);
    }

    @Transient
    public BigDecimal getSubtotal() {
        if (this.getQuantity() != null) {
            return this.getUnitPrice().multiply(new BigDecimal(this.getQuantity()));
        }
        return new BigDecimal(0);
    }

    @Transient
    public boolean getIsLowStock() {
        return this.getQuantity() != null && this.getProduct() != null && this.getProduct().getStock() != null && this.getQuantity() > this.getProduct().getAvailableStock();
    }

    @Transient
    public void add(int quantity) {
        if (quantity > 0) {
            if (this.getQuantity() != null) {
                this.setQuantity(Integer.valueOf(this.getQuantity() + quantity));
            } else {
                this.setQuantity(Integer.valueOf(quantity));
            }
        }
    }
}

