/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.PreRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.shopxx.Setting;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Coupon$Operator;
import net.shopxx.entity.CouponCode;
import net.shopxx.entity.Order;
import net.shopxx.entity.Promotion;
import net.shopxx.util.SettingUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="xx_coupon")
public class Coupon
extends BaseEntity {
    private static final long serialVersionUID = -7907808728349149722L;
    private String IIIllIlI;
    private String IIIllIll;
    private Date IIIlllII;
    private Date IIIlllIl;
    private BigDecimal IIIllllI;
    private BigDecimal IIIlllll;
    private Boolean IIlIIIII;
    private Boolean IIlIIIIl;
    private Integer IIlIIIlI;
    private Coupon$Operator IIlIIIll;
    private BigDecimal IIlIIlII;
    private String IIlIIlIl;
    private Set<CouponCode> IIlIIllI = new HashSet();
    private Set<Promotion> IIlIIlll = new HashSet();
    private List<Order> IIlIlIII = new ArrayList();

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getName() {
        return this.IIIllIlI;
    }

    public void setName(String name) {
        this.IIIllIlI = name;
    }

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getPrefix() {
        return this.IIIllIll;
    }

    public void setPrefix(String prefix) {
        this.IIIllIll = prefix;
    }

    public Date getBeginDate() {
        return this.IIIlllII;
    }

    public void setBeginDate(Date beginDate) {
        this.IIIlllII = beginDate;
    }

    public Date getEndDate() {
        return this.IIIlllIl;
    }

    public void setEndDate(Date endDate) {
        this.IIIlllIl = endDate;
    }

    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(precision=21, scale=6)
    public BigDecimal getStartPrice() {
        return this.IIIllllI;
    }

    public void setStartPrice(BigDecimal startPrice) {
        this.IIIllllI = startPrice;
    }

    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(precision=21, scale=6)
    public BigDecimal getEndPrice() {
        return this.IIIlllll;
    }

    public void setEndPrice(BigDecimal endPrice) {
        this.IIIlllll = endPrice;
    }

    @NotNull
    @Column(nullable=false)
    public Boolean getIsEnabled() {
        return this.IIlIIIII;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.IIlIIIII = isEnabled;
    }

    @NotNull
    @Column(nullable=false)
    public Boolean getIsExchange() {
        return this.IIlIIIIl;
    }

    public void setIsExchange(Boolean isExchange) {
        this.IIlIIIIl = isExchange;
    }

    @Min(value=0L)
    public Integer getPoint() {
        return this.IIlIIIlI;
    }

    public void setPoint(Integer point) {
        this.IIlIIIlI = point;
    }

    @NotNull
    @Column(nullable=false)
    public Coupon$Operator getPriceOperator() {
        return this.IIlIIIll;
    }

    public void setPriceOperator(Coupon$Operator priceOperator) {
        this.IIlIIIll = priceOperator;
    }

    @Digits(integer=12, fraction=3)
    @Column(precision=21, scale=6)
    public BigDecimal getPriceValue() {
        return this.IIlIIlII;
    }

    public void setPriceValue(BigDecimal priceValue) {
        this.IIlIIlII = priceValue;
    }

    @Lob
    public String getIntroduction() {
        return this.IIlIIlIl;
    }

    public void setIntroduction(String introduction) {
        this.IIlIIlIl = introduction;
    }

    @OneToMany(mappedBy="coupon", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    public Set<CouponCode> getCouponCodes() {
        return this.IIlIIllI;
    }

    public void setCouponCodes(Set<CouponCode> couponCodes) {
        this.IIlIIllI = couponCodes;
    }

    @ManyToMany(mappedBy="coupons", fetch=FetchType.LAZY)
    public Set<Promotion> getPromotions() {
        return this.IIlIIlll;
    }

    public void setPromotions(Set<Promotion> promotions) {
        this.IIlIIlll = promotions;
    }

    @ManyToMany(mappedBy="coupons", fetch=FetchType.LAZY)
    public List<Order> getOrders() {
        return this.IIlIlIII;
    }

    public void setOrders(List<Order> orders) {
        this.IIlIlIII = orders;
    }

    @Transient
    public boolean hasBegun() {
        return this.getBeginDate() == null || new Date().after(this.getBeginDate());
    }

    @Transient
    public boolean hasExpired() {
        return this.getEndDate() != null && new Date().after(this.getEndDate());
    }

    @Transient
    public BigDecimal calculatePrice(BigDecimal price) {
        if (price != null && this.getPriceOperator() != null && this.getPriceValue() != null) {
            Setting setting = SettingUtils.get();
            BigDecimal bigDecimal = this.getPriceOperator() == Coupon$Operator.add ? price.add(this.getPriceValue()) : (this.getPriceOperator() == Coupon$Operator.subtract ? price.subtract(this.getPriceValue()) : (this.getPriceOperator() == Coupon$Operator.multiply ? price.multiply(this.getPriceValue()) : price.divide(this.getPriceValue())));
            bigDecimal = setting.setScale(bigDecimal);
            return bigDecimal.compareTo(new BigDecimal(0)) > 0 ? bigDecimal : new BigDecimal(0);
        }
        return price;
    }

    @PreRemove
    public void preRemove() {
        List list2;
        Set set = this.getPromotions();
        if (set != null) {
            for (List list2 : set) {
                list2.getCoupons().remove(this);
            }
        }
        if ((list2 = this.getOrders()) != null) {
            for (Order order : list2) {
                order.getCoupons().remove(this);
            }
        }
    }
}

