/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.shopxx.Setting;
import net.shopxx.entity.Admin;
import net.shopxx.entity.Area;
import net.shopxx.entity.BaseEntity;
import net.shopxx.entity.Coupon;
import net.shopxx.entity.CouponCode;
import net.shopxx.entity.Deposit;
import net.shopxx.entity.Member;
import net.shopxx.entity.Order$OrderStatus;
import net.shopxx.entity.Order$PaymentStatus;
import net.shopxx.entity.Order$ShippingStatus;
import net.shopxx.entity.OrderItem;
import net.shopxx.entity.OrderLog;
import net.shopxx.entity.Payment;
import net.shopxx.entity.PaymentMethod;
import net.shopxx.entity.Refunds;
import net.shopxx.entity.Returns;
import net.shopxx.entity.Shipping;
import net.shopxx.entity.ShippingMethod;
import net.shopxx.util.SettingUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="xx_order")
public class Order
extends BaseEntity {
    private static final long serialVersionUID = 8370942500343156156L;
    private static final String IIIllIlI = " ";
    private String IIIllIll;
    private Order$OrderStatus IIIlllII;
    private Order$PaymentStatus IIIlllIl;
    private Order$ShippingStatus IIIllllI;
    private BigDecimal IIIlllll;
    private BigDecimal IIlIIIII;
    private BigDecimal IIlIIIIl;
    private BigDecimal IIlIIIlI;
    private Integer IIlIIIll;
    private String IIlIIlII;
    private String IIlIIlIl;
    private String IIlIIllI;
    private String IIlIIlll;
    private String IIlIlIII;
    private Boolean IIlIlIIl;
    private String IIlIlIlI;
    private BigDecimal IIlIlIll;
    private String IIlIllII;
    private String IIlIllIl;
    private Date IIlIlllI;
    private Date IIlIllll;
    private Boolean IIllIIII;
    private String IIllIIIl;
    private String IIllIIlI;
    private Area IIllIIll;
    private PaymentMethod IIllIlII;
    private ShippingMethod IIllIlIl;
    private Admin IIllIllI;
    private Member IIllIlll;
    private CouponCode IIlllIII;
    private List<Coupon> IIlllIIl = new ArrayList();
    private List<OrderItem> IIlllIlI = new ArrayList();
    private Set<OrderLog> IIlllIll = new HashSet();
    private Set<Deposit> IIllllII = new HashSet();
    private Set<Payment> IIllllIl = new HashSet();
    private Set<Refunds> IIlllllI = new HashSet();
    private Set<Shipping> IIllllll = new HashSet();
    private Set<Returns> IlIIIIII = new HashSet();

    @Column(nullable=false, updatable=false, unique=true)
    public String getSn() {
        return this.IIIllIll;
    }

    public void setSn(String sn) {
        this.IIIllIll = sn;
    }

    @Column(nullable=false)
    public Order$OrderStatus getOrderStatus() {
        return this.IIIlllII;
    }

    public void setOrderStatus(Order$OrderStatus orderStatus) {
        this.IIIlllII = orderStatus;
    }

    @Column(nullable=false)
    public Order$PaymentStatus getPaymentStatus() {
        return this.IIIlllIl;
    }

    public void setPaymentStatus(Order$PaymentStatus paymentStatus) {
        this.IIIlllIl = paymentStatus;
    }

    @Column(nullable=false)
    public Order$ShippingStatus getShippingStatus() {
        return this.IIIllllI;
    }

    public void setShippingStatus(Order$ShippingStatus shippingStatus) {
        this.IIIllllI = shippingStatus;
    }

    @Column(nullable=false, precision=21, scale=6)
    public BigDecimal getFee() {
        return this.IIIlllll;
    }

    public void setFee(BigDecimal fee) {
        this.IIIlllll = fee;
    }

    @NotNull
    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(nullable=false, precision=21, scale=6)
    public BigDecimal getFreight() {
        return this.IIlIIIII;
    }

    public void setFreight(BigDecimal freight) {
        this.IIlIIIII = freight;
    }

    @NotNull
    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(nullable=false, precision=21, scale=6)
    public BigDecimal getDiscount() {
        return this.IIlIIIIl;
    }

    public void setDiscount(BigDecimal discount) {
        this.IIlIIIIl = discount;
    }

    @Column(nullable=false, precision=21, scale=6)
    public BigDecimal getAmountPaid() {
        return this.IIlIIIlI;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.IIlIIIlI = amountPaid;
    }

    @NotNull
    @Min(value=0L)
    @Column(nullable=false)
    public Integer getPoint() {
        return this.IIlIIIll;
    }

    public void setPoint(Integer point) {
        this.IIlIIIll = point;
    }

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getConsignee() {
        return this.IIlIIlII;
    }

    public void setConsignee(String consignee) {
        this.IIlIIlII = consignee;
    }

    @Column(nullable=false)
    public String getAreaName() {
        return this.IIlIIlIl;
    }

    public void setAreaName(String areaName) {
        this.IIlIIlIl = areaName;
    }

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getAddress() {
        return this.IIlIIllI;
    }

    public void setAddress(String address) {
        this.IIlIIllI = address;
    }

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getZipCode() {
        return this.IIlIIlll;
    }

    public void setZipCode(String zipCode) {
        this.IIlIIlll = zipCode;
    }

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getPhone() {
        return this.IIlIlIII;
    }

    public void setPhone(String phone) {
        this.IIlIlIII = phone;
    }

    @NotNull
    @Column(nullable=false)
    public Boolean getIsInvoice() {
        return this.IIlIlIIl;
    }

    public void setIsInvoice(Boolean isInvoice) {
        this.IIlIlIIl = isInvoice;
    }

    @Length(max=200)
    public String getInvoiceTitle() {
        return this.IIlIlIlI;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.IIlIlIlI = invoiceTitle;
    }

    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(nullable=false, precision=21, scale=6)
    public BigDecimal getTax() {
        return this.IIlIlIll;
    }

    public void setTax(BigDecimal tax) {
        this.IIlIlIll = tax;
    }

    @Length(max=200)
    public String getMemo() {
        return this.IIlIllII;
    }

    public void setMemo(String memo) {
        this.IIlIllII = memo;
    }

    @Column(updatable=false)
    public String getPromotion() {
        return this.IIlIllIl;
    }

    public void setPromotion(String promotion) {
        this.IIlIllIl = promotion;
    }

    public Date getExpire() {
        return this.IIlIlllI;
    }

    public void setExpire(Date expire) {
        this.IIlIlllI = expire;
    }

    public Date getLockExpire() {
        return this.IIlIllll;
    }

    public void setLockExpire(Date lockExpire) {
        this.IIlIllll = lockExpire;
    }

    @Column(nullable=false)
    public Boolean getIsAllocatedStock() {
        return this.IIllIIII;
    }

    public void setIsAllocatedStock(Boolean isAllocatedStock) {
        this.IIllIIII = isAllocatedStock;
    }

    @Column(nullable=false)
    public String getPaymentMethodName() {
        return this.IIllIIIl;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.IIllIIIl = paymentMethodName;
    }

    @Column(nullable=false)
    public String getShippingMethodName() {
        return this.IIllIIlI;
    }

    public void setShippingMethodName(String shippingMethodName) {
        this.IIllIIlI = shippingMethodName;
    }

    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    public Area getArea() {
        return this.IIllIIll;
    }

    public void setArea(Area area) {
        this.IIllIIll = area;
    }

    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    public PaymentMethod getPaymentMethod() {
        return this.IIllIlII;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.IIllIlII = paymentMethod;
    }

    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    public ShippingMethod getShippingMethod() {
        return this.IIllIlIl;
    }

    public void setShippingMethod(ShippingMethod shippingMethod) {
        this.IIllIlIl = shippingMethod;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Admin getOperator() {
        return this.IIllIllI;
    }

    public void setOperator(Admin operator) {
        this.IIllIllI = operator;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, updatable=false)
    public Member getMember() {
        return this.IIllIlll;
    }

    public void setMember(Member member) {
        this.IIllIlll = member;
    }

    @OneToOne(fetch=FetchType.LAZY)
    public CouponCode getCouponCode() {
        return this.IIlllIII;
    }

    public void setCouponCode(CouponCode couponCode) {
        this.IIlllIII = couponCode;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_order_coupon")
    public List<Coupon> getCoupons() {
        return this.IIlllIIl;
    }

    public void setCoupons(List<Coupon> coupons) {
        this.IIlllIIl = coupons;
    }

    @Valid
    @NotEmpty
    @OneToMany(mappedBy="order", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="isGift asc")
    public List<OrderItem> getOrderItems() {
        return this.IIlllIlI;
    }

    public void setOrderItems(List<OrderItem> orderItems) {
        this.IIlllIlI = orderItems;
    }

    @OneToMany(mappedBy="order", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="createDate asc")
    public Set<OrderLog> getOrderLogs() {
        return this.IIlllIll;
    }

    public void setOrderLogs(Set<OrderLog> orderLogs) {
        this.IIlllIll = orderLogs;
    }

    @OneToMany(mappedBy="order", fetch=FetchType.LAZY)
    public Set<Deposit> getDeposits() {
        return this.IIllllII;
    }

    public void setDeposits(Set<Deposit> deposits) {
        this.IIllllII = deposits;
    }

    @OneToMany(mappedBy="order", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="createDate asc")
    public Set<Payment> getPayments() {
        return this.IIllllIl;
    }

    public void setPayments(Set<Payment> payments) {
        this.IIllllIl = payments;
    }

    @OneToMany(mappedBy="order", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="createDate asc")
    public Set<Refunds> getRefunds() {
        return this.IIlllllI;
    }

    public void setRefunds(Set<Refunds> refunds) {
        this.IIlllllI = refunds;
    }

    @OneToMany(mappedBy="order", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="createDate asc")
    public Set<Shipping> getShippings() {
        return this.IIllllll;
    }

    public void setShippings(Set<Shipping> shippings) {
        this.IIllllll = shippings;
    }

    @OneToMany(mappedBy="order", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="createDate asc")
    public Set<Returns> getReturns() {
        return this.IlIIIIII;
    }

    public void setReturns(Set<Returns> returns) {
        this.IlIIIIII = returns;
    }

    @Transient
    public String getProductName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getOrderItems() != null) {
            for (OrderItem orderItem : this.getOrderItems()) {
                if (orderItem == null || orderItem.getFullName() == null) continue;
                stringBuffer.append(IIIllIlI).append(orderItem.getFullName());
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(0);
            }
        }
        return stringBuffer.toString();
    }

    @Transient
    public int getWeight() {
        int n = 0;
        if (this.getOrderItems() != null) {
            for (OrderItem orderItem : this.getOrderItems()) {
                if (orderItem == null) continue;
                n += orderItem.getTotalWeight();
            }
        }
        return n;
    }

    @Transient
    public int getQuantity() {
        int n = 0;
        if (this.getOrderItems() != null) {
            for (OrderItem orderItem : this.getOrderItems()) {
                if (orderItem == null || orderItem.getQuantity() == null) continue;
                n += orderItem.getQuantity().intValue();
            }
        }
        return n;
    }

    @Transient
    public int getShippedQuantity() {
        int n = 0;
        if (this.getOrderItems() != null) {
            for (OrderItem orderItem : this.getOrderItems()) {
                if (orderItem == null || orderItem.getShippedQuantity() == null) continue;
                n += orderItem.getShippedQuantity().intValue();
            }
        }
        return n;
    }

    @Transient
    public int getReturnQuantity() {
        int n = 0;
        if (this.getOrderItems() != null) {
            for (OrderItem orderItem : this.getOrderItems()) {
                if (orderItem == null || orderItem.getReturnQuantity() == null) continue;
                n += orderItem.getReturnQuantity().intValue();
            }
        }
        return n;
    }

    @Transient
    public BigDecimal getPrice() {
        BigDecimal bigDecimal = new BigDecimal(0);
        if (this.getOrderItems() != null) {
            for (OrderItem orderItem : this.getOrderItems()) {
                if (orderItem == null || orderItem.getSubtotal() == null) continue;
                bigDecimal = bigDecimal.add(orderItem.getSubtotal());
            }
        }
        return bigDecimal;
    }

    @Transient
    public BigDecimal getAmount() {
        BigDecimal bigDecimal = this.getPrice().subtract(this.getDiscount() != null ? this.getDiscount() : new BigDecimal(0)).add(this.getFreight() != null ? this.getFreight() : new BigDecimal(0)).add(this.getFee() != null ? this.getFee() : new BigDecimal(0)).add(this.getTax() != null ? this.getTax() : new BigDecimal(0));
        return bigDecimal.compareTo(new BigDecimal(0)) > 0 ? bigDecimal : new BigDecimal(0);
    }

    @Transient
    public BigDecimal getAmountPayable() {
        BigDecimal bigDecimal = this.getAmount().subtract(this.getAmountPaid());
        return bigDecimal.compareTo(new BigDecimal(0)) > 0 ? bigDecimal : new BigDecimal(0);
    }

    @Transient
    public boolean isExpired() {
        return this.getExpire() != null && new Date().after(this.getExpire());
    }

    @Transient
    public OrderItem getOrderItem(String sn) {
        if (sn != null && this.getOrderItems() != null) {
            for (OrderItem orderItem : this.getOrderItems()) {
                if (orderItem == null || !sn.equalsIgnoreCase(orderItem.getSn())) continue;
                return orderItem;
            }
        }
        return null;
    }

    @Transient
    public boolean isLocked(Admin operator) {
        return this.getLockExpire() != null && new Date().before(this.getLockExpire()) && this.getOperator() != operator;
    }

    @Transient
    public BigDecimal calculateTax() {
        Setting setting = SettingUtils.get();
        BigDecimal bigDecimal = setting.getIsTaxPriceEnabled() != false ? this.getPrice().subtract(this.getDiscount()).multiply(new BigDecimal(setting.getTaxRate().toString())) : new BigDecimal(0);
        return setting.setScale(bigDecimal);
    }

    @PrePersist
    public void prePersist() {
        if (this.getArea() != null) {
            this.setAreaName(this.getArea().getFullName());
        }
        if (this.getPaymentMethod() != null) {
            this.setPaymentMethodName(this.getPaymentMethod().getName());
        }
        if (this.getShippingMethod() != null) {
            this.setShippingMethodName(this.getShippingMethod().getName());
        }
    }

    @PreUpdate
    public void preUpdate() {
        if (this.getArea() != null) {
            this.setAreaName(this.getArea().getFullName());
        }
        if (this.getPaymentMethod() != null) {
            this.setPaymentMethodName(this.getPaymentMethod().getName());
        }
        if (this.getShippingMethod() != null) {
            this.setShippingMethodName(this.getShippingMethod().getName());
        }
    }

    @PreRemove
    public void preRemove() {
        Set set = this.getDeposits();
        if (set != null) {
            for (Deposit deposit : set) {
                deposit.setOrder(null);
            }
        }
    }
}

