/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PreRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.shopxx.entity.Attribute;
import net.shopxx.entity.Brand;
import net.shopxx.entity.OrderEntity;
import net.shopxx.entity.ParameterGroup;
import net.shopxx.entity.Product;
import net.shopxx.entity.Promotion;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="xx_product_category")
public class ProductCategory
extends OrderEntity {
    private static final long serialVersionUID = 5095521437302782717L;
    public static final String TREE_PATH_SEPARATOR = ",";
    private static final String IIIllIlI = "/product/list";
    private static final String IIIllIll = ".jhtml";
    private String IIIlllII;
    private String IIIlllIl;
    private String IIIllllI;
    private String IIIlllll;
    private String IIlIIIII;
    private Integer IIlIIIIl;
    private ProductCategory IIlIIIlI;
    private Set<ProductCategory> IIlIIIll = new HashSet();
    private Set<Product> IIlIIlII = new HashSet();
    private Set<Brand> IIlIIlIl = new HashSet();
    private Set<ParameterGroup> IIlIIllI = new HashSet();
    private Set<Attribute> IIlIIlll = new HashSet();
    private Set<Promotion> IIlIlIII = new HashSet();

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getName() {
        return this.IIIlllII;
    }

    public void setName(String name) {
        this.IIIlllII = name;
    }

    @Length(max=200)
    public String getSeoTitle() {
        return this.IIIlllIl;
    }

    public void setSeoTitle(String seoTitle) {
        this.IIIlllIl = seoTitle;
    }

    @Length(max=200)
    public String getSeoKeywords() {
        return this.IIIllllI;
    }

    public void setSeoKeywords(String seoKeywords) {
        this.IIIllllI = seoKeywords;
    }

    @Length(max=200)
    public String getSeoDescription() {
        return this.IIIlllll;
    }

    public void setSeoDescription(String seoDescription) {
        this.IIIlllll = seoDescription;
    }

    @Column(nullable=false)
    public String getTreePath() {
        return this.IIlIIIII;
    }

    public void setTreePath(String treePath) {
        this.IIlIIIII = treePath;
    }

    @Column(nullable=false)
    public Integer getGrade() {
        return this.IIlIIIIl;
    }

    public void setGrade(Integer grade) {
        this.IIlIIIIl = grade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public ProductCategory getParent() {
        return this.IIlIIIlI;
    }

    public void setParent(ProductCategory parent) {
        this.IIlIIIlI = parent;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY)
    @OrderBy(value="order asc")
    public Set<ProductCategory> getChildren() {
        return this.IIlIIIll;
    }

    public void setChildren(Set<ProductCategory> children) {
        this.IIlIIIll = children;
    }

    @OneToMany(mappedBy="productCategory", fetch=FetchType.LAZY)
    public Set<Product> getProducts() {
        return this.IIlIIlII;
    }

    public void setProducts(Set<Product> products) {
        this.IIlIIlII = products;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_product_category_brand")
    @OrderBy(value="order asc")
    public Set<Brand> getBrands() {
        return this.IIlIIlIl;
    }

    public void setBrands(Set<Brand> brands) {
        this.IIlIIlIl = brands;
    }

    @OneToMany(mappedBy="productCategory", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="order asc")
    public Set<ParameterGroup> getParameterGroups() {
        return this.IIlIIllI;
    }

    public void setParameterGroups(Set<ParameterGroup> parameterGroups) {
        this.IIlIIllI = parameterGroups;
    }

    @OneToMany(mappedBy="productCategory", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="order asc")
    public Set<Attribute> getAttributes() {
        return this.IIlIIlll;
    }

    public void setAttributes(Set<Attribute> attributes) {
        this.IIlIIlll = attributes;
    }

    @ManyToMany(mappedBy="productCategories", fetch=FetchType.LAZY)
    public Set<Promotion> getPromotions() {
        return this.IIlIlIII;
    }

    public void setPromotions(Set<Promotion> promotions) {
        this.IIlIlIII = promotions;
    }

    @Transient
    public List<Long> getTreePaths() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String[] stringArray = StringUtils.split((String)this.getTreePath(), (String)TREE_PATH_SEPARATOR);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                arrayList.add(Long.valueOf(string));
                ++n2;
            }
        }
        return arrayList;
    }

    @Transient
    public String getPath() {
        if (this.getId() != null) {
            return "/product/list/" + this.getId() + IIIllIll;
        }
        return null;
    }

    @PreRemove
    public void preRemove() {
        Set set = this.getPromotions();
        if (set != null) {
            for (Promotion promotion : set) {
                promotion.getProductCategories().remove(this);
            }
        }
    }
}

