/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.shopxx.entity.Brand;
import net.shopxx.entity.Coupon;
import net.shopxx.entity.GiftItem;
import net.shopxx.entity.MemberRank;
import net.shopxx.entity.OrderEntity;
import net.shopxx.entity.Product;
import net.shopxx.entity.ProductCategory;
import net.shopxx.entity.Promotion$Operator;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="xx_promotion")
public class Promotion
extends OrderEntity {
    private static final long serialVersionUID = 3536993535267962279L;
    private static final String IIIllIlI = "/promotion/content";
    private static final String IIIllIll = ".jhtml";
    private String IIIlllII;
    private String IIIlllIl;
    private Date IIIllllI;
    private Date IIIlllll;
    private BigDecimal IIlIIIII;
    private BigDecimal IIlIIIIl;
    private Promotion$Operator IIlIIIlI;
    private BigDecimal IIlIIIll;
    private Promotion$Operator IIlIIlII;
    private BigDecimal IIlIIlIl;
    private Boolean IIlIIllI;
    private Boolean IIlIIlll;
    private String IIlIlIII;
    private Set<MemberRank> IIlIlIIl = new HashSet();
    private Set<ProductCategory> IIlIlIlI = new HashSet();
    private Set<Product> IIlIlIll = new HashSet();
    private Set<Brand> IIlIllII = new HashSet();
    private Set<Coupon> IIlIllIl = new HashSet();
    private List<GiftItem> IIlIlllI = new ArrayList();

    @JsonProperty
    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getName() {
        return this.IIIlllII;
    }

    public void setName(String name) {
        this.IIIlllII = name;
    }

    @JsonProperty
    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getTitle() {
        return this.IIIlllIl;
    }

    public void setTitle(String title) {
        this.IIIlllIl = title;
    }

    @JsonProperty
    public Date getBeginDate() {
        return this.IIIllllI;
    }

    public void setBeginDate(Date beginDate) {
        this.IIIllllI = beginDate;
    }

    @JsonProperty
    public Date getEndDate() {
        return this.IIIlllll;
    }

    public void setEndDate(Date endDate) {
        this.IIIlllll = endDate;
    }

    @JsonProperty
    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(precision=21, scale=6)
    public BigDecimal getStartPrice() {
        return this.IIlIIIII;
    }

    public void setStartPrice(BigDecimal startPrice) {
        this.IIlIIIII = startPrice;
    }

    @JsonProperty
    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(precision=21, scale=6)
    public BigDecimal getEndPrice() {
        return this.IIlIIIIl;
    }

    public void setEndPrice(BigDecimal endPrice) {
        this.IIlIIIIl = endPrice;
    }

    @NotNull
    @Column(nullable=false)
    public Promotion$Operator getPriceOperator() {
        return this.IIlIIIlI;
    }

    public void setPriceOperator(Promotion$Operator priceOperator) {
        this.IIlIIIlI = priceOperator;
    }

    @Digits(integer=12, fraction=3)
    @Column(precision=21, scale=6)
    public BigDecimal getPriceValue() {
        return this.IIlIIIll;
    }

    public void setPriceValue(BigDecimal priceValue) {
        this.IIlIIIll = priceValue;
    }

    @NotNull
    @Column(nullable=false)
    public Promotion$Operator getPointOperator() {
        return this.IIlIIlII;
    }

    public void setPointOperator(Promotion$Operator pointOperator) {
        this.IIlIIlII = pointOperator;
    }

    public BigDecimal getPointValue() {
        return this.IIlIIlIl;
    }

    public void setPointValue(BigDecimal pointValue) {
        this.IIlIIlIl = pointValue;
    }

    @NotNull
    @Column(nullable=false)
    public Boolean getIsFreeShipping() {
        return this.IIlIIllI;
    }

    public void setIsFreeShipping(Boolean isFreeShipping) {
        this.IIlIIllI = isFreeShipping;
    }

    @JsonProperty
    @NotNull
    @Column(nullable=false)
    public Boolean getIsCouponAllowed() {
        return this.IIlIIlll;
    }

    public void setIsCouponAllowed(Boolean isCouponAllowed) {
        this.IIlIIlll = isCouponAllowed;
    }

    @Lob
    public String getIntroduction() {
        return this.IIlIlIII;
    }

    public void setIntroduction(String introduction) {
        this.IIlIlIII = introduction;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_promotion_member_rank")
    public Set<MemberRank> getMemberRanks() {
        return this.IIlIlIIl;
    }

    public void setMemberRanks(Set<MemberRank> memberRanks) {
        this.IIlIlIIl = memberRanks;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_promotion_product_category")
    public Set<ProductCategory> getProductCategories() {
        return this.IIlIlIlI;
    }

    public void setProductCategories(Set<ProductCategory> productCategories) {
        this.IIlIlIlI = productCategories;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_promotion_product")
    public Set<Product> getProducts() {
        return this.IIlIlIll;
    }

    public void setProducts(Set<Product> products) {
        this.IIlIlIll = products;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_promotion_brand")
    public Set<Brand> getBrands() {
        return this.IIlIllII;
    }

    public void setBrands(Set<Brand> brands) {
        this.IIlIllII = brands;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xx_promotion_coupon")
    public Set<Coupon> getCoupons() {
        return this.IIlIllIl;
    }

    public void setCoupons(Set<Coupon> coupons) {
        this.IIlIllIl = coupons;
    }

    @Valid
    @OneToMany(mappedBy="promotion", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<GiftItem> getGiftItems() {
        return this.IIlIlllI;
    }

    public void setGiftItems(List<GiftItem> giftItems) {
        this.IIlIlllI = giftItems;
    }

    @Transient
    public boolean hasBegun() {
        return this.getBeginDate() == null || new Date().after(this.getBeginDate());
    }

    @Transient
    public boolean hasEnded() {
        return this.getEndDate() != null && new Date().after(this.getEndDate());
    }

    @Transient
    public String getPath() {
        if (this.getId() != null) {
            return "/promotion/content/" + this.getId() + IIIllIll;
        }
        return null;
    }

    @Transient
    public BigDecimal calculatePrice(BigDecimal price) {
        if (price != null && this.getPriceOperator() != null && this.getPriceValue() != null) {
            BigDecimal bigDecimal = this.getPriceOperator() == Promotion$Operator.add ? price.add(this.getPriceValue()) : (this.getPriceOperator() == Promotion$Operator.subtract ? price.subtract(this.getPriceValue()) : (this.getPriceOperator() == Promotion$Operator.multiply ? price.multiply(this.getPriceValue()) : price.divide(this.getPriceValue())));
            return bigDecimal.compareTo(new BigDecimal(0)) > 0 ? bigDecimal : new BigDecimal(0);
        }
        return price;
    }

    @Transient
    public Integer calculatePoint(Integer point) {
        if (point != null && this.getPointOperator() != null && this.getPointValue() != null) {
            BigDecimal bigDecimal = this.getPointOperator() == Promotion$Operator.add ? new BigDecimal(point).add(this.getPointValue()) : (this.getPointOperator() == Promotion$Operator.subtract ? new BigDecimal(point).subtract(this.getPointValue()) : (this.getPointOperator() == Promotion$Operator.multiply ? new BigDecimal(point).multiply(this.getPointValue()) : new BigDecimal(point).divide(this.getPointValue())));
            return bigDecimal.compareTo(new BigDecimal(0)) > 0 ? bigDecimal.intValue() : 0;
        }
        return point;
    }
}

