/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.entity;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PreRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.shopxx.Setting;
import net.shopxx.entity.DeliveryCorp;
import net.shopxx.entity.Order;
import net.shopxx.entity.OrderEntity;
import net.shopxx.entity.PaymentMethod;
import net.shopxx.util.SettingUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="xx_shipping_method")
public class ShippingMethod
extends OrderEntity {
    private static final long serialVersionUID = 5873163245980853245L;
    private String IIIllIlI;
    private Integer IIIllIll;
    private Integer IIIlllII;
    private BigDecimal IIIlllIl;
    private BigDecimal IIIllllI;
    private String IIIlllll;
    private String IIlIIIII;
    private DeliveryCorp IIlIIIIl;
    private Set<PaymentMethod> IIlIIIlI = new HashSet();
    private Set<Order> IIlIIIll = new HashSet();

    @NotEmpty
    @Length(max=200)
    @Column(nullable=false)
    public String getName() {
        return this.IIIllIlI;
    }

    public void setName(String name) {
        this.IIIllIlI = name;
    }

    @NotNull
    @Min(value=0L)
    @Column(nullable=false)
    public Integer getFirstWeight() {
        return this.IIIllIll;
    }

    public void setFirstWeight(Integer firstWeight) {
        this.IIIllIll = firstWeight;
    }

    @NotNull
    @Min(value=1L)
    @Column(nullable=false)
    public Integer getContinueWeight() {
        return this.IIIlllII;
    }

    public void setContinueWeight(Integer continueWeight) {
        this.IIIlllII = continueWeight;
    }

    @NotNull
    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(nullable=false, precision=21, scale=6)
    public BigDecimal getFirstPrice() {
        return this.IIIlllIl;
    }

    public void setFirstPrice(BigDecimal firstPrice) {
        this.IIIlllIl = firstPrice;
    }

    @NotNull
    @Min(value=0L)
    @Digits(integer=12, fraction=3)
    @Column(nullable=false, precision=21, scale=6)
    public BigDecimal getContinuePrice() {
        return this.IIIllllI;
    }

    public void setContinuePrice(BigDecimal continuePrice) {
        this.IIIllllI = continuePrice;
    }

    @Length(max=200)
    public String getIcon() {
        return this.IIIlllll;
    }

    public void setIcon(String icon) {
        this.IIIlllll = icon;
    }

    @Lob
    public String getDescription() {
        return this.IIlIIIII;
    }

    public void setDescription(String description) {
        this.IIlIIIII = description;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public DeliveryCorp getDefaultDeliveryCorp() {
        return this.IIlIIIIl;
    }

    public void setDefaultDeliveryCorp(DeliveryCorp defaultDeliveryCorp) {
        this.IIlIIIIl = defaultDeliveryCorp;
    }

    @ManyToMany(mappedBy="shippingMethods", fetch=FetchType.LAZY)
    public Set<PaymentMethod> getPaymentMethods() {
        return this.IIlIIIlI;
    }

    public void setPaymentMethods(Set<PaymentMethod> paymentMethods) {
        this.IIlIIIlI = paymentMethods;
    }

    @OneToMany(mappedBy="shippingMethod", fetch=FetchType.LAZY)
    public Set<Order> getOrders() {
        return this.IIlIIIll;
    }

    public void setOrders(Set<Order> orders) {
        this.IIlIIIll = orders;
    }

    @Transient
    public BigDecimal calculateFreight(Integer weight) {
        Setting setting = SettingUtils.get();
        BigDecimal bigDecimal = new BigDecimal(0);
        if (weight != null) {
            if (weight <= this.getFirstWeight() || this.getContinuePrice().compareTo(new BigDecimal(0)) == 0) {
                bigDecimal = this.getFirstPrice();
            } else {
                double d = Math.ceil((double)(weight - this.getFirstWeight()) / (double)this.getContinueWeight().intValue());
                bigDecimal = this.getFirstPrice().add(this.getContinuePrice().multiply(new BigDecimal(d)));
            }
        }
        return setting.setScale(bigDecimal);
    }

    @PreRemove
    public void preRemove() {
        Set set3;
        Set set2 = this.getPaymentMethods();
        if (set2 != null) {
            for (Set set3 : set2) {
                set3.getShippingMethods().remove(this);
            }
        }
        if ((set3 = this.getOrders()) != null) {
            for (Order order : set3) {
                order.setShippingMethod(null);
            }
        }
    }
}

