/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.plugin;

import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Setting;
import net.shopxx.entity.PluginConfig;
import net.shopxx.plugin.PaymentPlugin$FeeType;
import net.shopxx.plugin.PaymentPlugin$Method;
import net.shopxx.service.PluginConfigService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PaymentPlugin
implements Comparable<PaymentPlugin> {
    public static final String PAYMENT_NAME_ATTRIBUTE_NAME = "paymentName";
    public static final String FEE_TYPE_ATTRIBUTE_NAME = "feeType";
    public static final String FEE_ATTRIBUTE_NAME = "fee";
    public static final String LOGO_ATTRIBUTE_NAME = "logo";
    public static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    @Resource(name="pluginConfigServiceImpl")
    private PluginConfigService IIIllIlI;

    public final String getId() {
        return this.getClass().getAnnotation(Component.class).value();
    }

    public abstract String getName();

    public abstract String getVersion();

    public abstract String getAuthor();

    public abstract String getSiteUrl();

    public abstract String getInstallUrl();

    public abstract String getUninstallUrl();

    public abstract String getSettingUrl();

    public boolean getIsInstalled() {
        return this.IIIllIlI.pluginIdExists(this.getId());
    }

    public PluginConfig getPluginConfig() {
        return this.IIIllIlI.findByPluginId(this.getId());
    }

    public boolean getIsEnabled() {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? pluginConfig.getIsEnabled() : false;
    }

    public String getAttribute(String name) {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? pluginConfig.getAttribute(name) : null;
    }

    public Integer getOrder() {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? pluginConfig.getOrder() : null;
    }

    public String getPaymentName() {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? pluginConfig.getAttribute(PAYMENT_NAME_ATTRIBUTE_NAME) : null;
    }

    public PaymentPlugin$FeeType getFeeType() {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? PaymentPlugin$FeeType.valueOf((String)pluginConfig.getAttribute(FEE_TYPE_ATTRIBUTE_NAME)) : null;
    }

    public BigDecimal getFee() {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? new BigDecimal(pluginConfig.getAttribute(FEE_ATTRIBUTE_NAME)) : null;
    }

    public String getLogo() {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? pluginConfig.getAttribute(LOGO_ATTRIBUTE_NAME) : null;
    }

    public String getDescription() {
        PluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? pluginConfig.getAttribute(DESCRIPTION_ATTRIBUTE_NAME) : null;
    }

    public abstract String getUrl();

    public abstract PaymentPlugin$Method getMethod();

    public abstract Integer getTimeout();

    public abstract Map<String, String> getParameterMap(String var1, BigDecimal var2, String var3, HttpServletRequest var4);

    public abstract boolean verify(String var1, HttpServletRequest var2);

    public abstract BigDecimal getAmount(String var1, HttpServletRequest var2);

    public abstract String getNotifyContext(String var1, HttpServletRequest var2);

    protected String IIIllIlI(String string) {
        Setting setting = SettingUtils.get();
        return String.valueOf(setting.getSiteUrl()) + "/payment/return/" + string + ".jhtml";
    }

    protected String IIIllIll(String string) {
        Setting setting = SettingUtils.get();
        return String.valueOf(setting.getSiteUrl()) + "/payment/notify/" + string + ".jhtml";
    }

    public final BigDecimal getFee(BigDecimal amount) {
        Setting setting = SettingUtils.get();
        BigDecimal bigDecimal = this.getFeeType() == PaymentPlugin$FeeType.scale ? amount.multiply(this.getFee()) : this.getFee();
        return setting.setScale(bigDecimal);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PaymentPlugin paymentPlugin = (PaymentPlugin)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)paymentPlugin.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }

    @Override
    public int compareTo(PaymentPlugin paymentPlugin) {
        return new CompareToBuilder().append((Object)this.getOrder(), (Object)paymentPlugin.getOrder()).append((Object)this.getId(), (Object)paymentPlugin.getId()).toComparison();
    }
}

